/*
 * Decompiled with CFR 0.152.
 */
package org.getopt.luke;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.FieldsEnum;
import org.apache.lucene.index.IndexGate;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.MultiFields;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.store.Directory;
import org.getopt.luke.FieldTermCount;
import org.getopt.luke.HighFreqTerms;
import org.getopt.luke.TermStats;
import org.getopt.luke.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndexInfo {
    private IndexReader reader;
    private Directory dir;
    private String indexPath;
    private long totalFileSize;
    private int numTerms = -1;
    private IndexGate.FormatDetails formatDetails;
    private TermStats[] topTerms = null;
    private List<String> fieldNames;
    private String lastModified;
    private String version;
    private String dirImpl;
    private HashMap<String, FieldTermCount> termCounts = null;

    public IndexInfo(IndexReader reader, String indexPath) throws Exception {
        this.reader = reader;
        this.dir = null;
        this.dirImpl = "N/A";
        if (reader instanceof DirectoryReader) {
            this.dir = ((DirectoryReader)reader).directory();
            this.dirImpl = this.dir.getClass().getName();
            this.version = Long.toString(((DirectoryReader)reader).getVersion());
        }
        this.indexPath = indexPath;
        this.lastModified = "N/A";
        this.totalFileSize = this.dir == null ? -1L : Util.calcTotalFileSize(indexPath, this.dir);
        this.fieldNames = new ArrayList<String>();
        this.fieldNames.addAll(Util.fieldNames(reader, false));
        Collections.sort(this.fieldNames);
        this.formatDetails = this.dir != null ? IndexGate.getIndexFormat(this.dir) : new IndexGate.FormatDetails();
    }

    private void countTerms() throws Exception {
        this.termCounts = new HashMap();
        this.numTerms = 0;
        Fields fields = MultiFields.getFields(this.reader);
        FieldsEnum fe = fields.iterator();
        String fld = null;
        TermsEnum te = null;
        while ((fld = fe.next()) != null) {
            FieldTermCount ftc = new FieldTermCount();
            ftc.fieldname = fld;
            Terms terms = fe.terms();
            if (terms != null) {
                te = terms.iterator(te);
                while (te.next() != null) {
                    ++ftc.termCount;
                    ++this.numTerms;
                }
            }
            this.termCounts.put(fld, ftc);
        }
    }

    public IndexReader getReader() {
        return this.reader;
    }

    public Directory getDirectory() {
        return this.dir;
    }

    public String getIndexPath() {
        return this.indexPath;
    }

    public long getTotalFileSize() {
        return this.totalFileSize;
    }

    public int getNumTerms() throws Exception {
        if (this.numTerms == -1) {
            this.countTerms();
        }
        return this.numTerms;
    }

    public IndexGate.FormatDetails getIndexFormat() {
        return this.formatDetails;
    }

    public Map<String, FieldTermCount> getFieldTermCounts() throws Exception {
        if (this.termCounts == null) {
            this.countTerms();
        }
        return this.termCounts;
    }

    public TermStats[] getTopTerms() throws Exception {
        if (this.topTerms == null) {
            this.topTerms = HighFreqTerms.getHighFreqTerms(this.reader, 50, null);
        }
        return this.topTerms;
    }

    public List<String> getFieldNames() {
        return this.fieldNames;
    }

    public String getLastModified() {
        return this.lastModified;
    }

    public String getVersion() {
        return this.version;
    }

    public String getDirImpl() {
        return this.dirImpl;
    }
}

