/*
 * Decompiled with CFR 0.152.
 */
package org.getopt.luke;

import java.io.File;
import java.util.Arrays;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.FieldsEnum;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.MultiFields;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.getopt.luke.TermStats;
import org.getopt.luke.TermStatsQueue;
import org.getopt.luke.TotalTermFreqComparatorSortDescending;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HighFreqTerms {
    private static final Logger LOG = LoggerFactory.getLogger(HighFreqTerms.class);
    public static final int DEFAULTnumTerms = 100;
    public static int numTerms = 100;
    private static final TermStats[] EMPTY_STATS = new TermStats[0];

    public static void main(String[] args) throws Exception {
        String[] stringArray;
        DirectoryReader reader = null;
        FSDirectory dir = null;
        String field = null;
        boolean IncludeTermFreqs = false;
        if (args.length == 0 || args.length > 4) {
            HighFreqTerms.usage();
            System.exit(1);
        }
        if (args.length > 0) {
            dir = FSDirectory.open(new File(args[0]));
        }
        for (int i = 1; i < args.length; ++i) {
            if (args[i].equals("-t")) {
                IncludeTermFreqs = true;
                continue;
            }
            try {
                numTerms = Integer.parseInt(args[i]);
                continue;
            }
            catch (NumberFormatException e) {
                field = args[i];
            }
        }
        if (field != null) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = field;
        } else {
            stringArray = null;
        }
        String[] fields = stringArray;
        reader = DirectoryReader.open(dir);
        TermStats[] terms = HighFreqTerms.getHighFreqTerms(reader, numTerms, fields);
        if (!IncludeTermFreqs) {
            for (int i = 0; i < terms.length; ++i) {
                System.out.printf("%s:%s %,d \n", terms[i].field, terms[i].termtext.utf8ToString(), terms[i].docFreq);
            }
        } else {
            TermStats[] termsWithTF = HighFreqTerms.sortByTotalTermFreq(reader, terms);
            for (int i = 0; i < termsWithTF.length; ++i) {
                System.out.printf("%s:%s \t totalTF = %,d \t doc freq = %,d \n", termsWithTF[i].field, termsWithTF[i].termtext.utf8ToString(), termsWithTF[i].totalTermFreq, termsWithTF[i].docFreq);
            }
        }
        reader.close();
    }

    private static void usage() {
        System.out.println("\n\njava org.apache.lucene.misc.HighFreqTerms <index dir> [-t][number_terms] [field]\n\t -t: include totalTermFreq\n\n");
    }

    public static TermStats[] getHighFreqTerms(IndexReader reader, int numTerms, String[] fieldNames) throws Exception {
        Fields fields;
        TermStatsQueue tiq = null;
        TermsEnum te = null;
        if (fieldNames != null) {
            fields = MultiFields.getFields(reader);
            if (fields == null) {
                LOG.info("Index with no fields - probably empty or corrupted");
                return EMPTY_STATS;
            }
            tiq = new TermStatsQueue(numTerms);
            for (String field : fieldNames) {
                Terms terms = fields.terms(field);
                if (terms == null) continue;
                te = terms.iterator(te);
                HighFreqTerms.fillQueue(te, tiq, field);
            }
        } else {
            String field;
            fields = MultiFields.getFields(reader);
            if (fields == null) {
                LOG.info("Index with no fields - probably empty or corrupted");
                return EMPTY_STATS;
            }
            tiq = new TermStatsQueue(numTerms);
            FieldsEnum fieldsEnum = fields.iterator();
            while ((field = fieldsEnum.next()) != null) {
                Terms terms = fieldsEnum.terms();
                te = terms.iterator(te);
                HighFreqTerms.fillQueue(te, tiq, field);
            }
        }
        TermStats[] result = new TermStats[tiq.size()];
        int count = tiq.size() - 1;
        while (tiq.size() != 0) {
            result[count] = (TermStats)tiq.pop();
            --count;
        }
        return result;
    }

    public static TermStats[] sortByTotalTermFreq(IndexReader reader, TermStats[] terms) throws Exception {
        TermStats[] ts = new TermStats[terms.length];
        for (int i = 0; i < terms.length; ++i) {
            long totalTF = HighFreqTerms.getTotalTermFreq(reader, terms[i].field, terms[i].termtext);
            ts[i] = new TermStats(terms[i].field, terms[i].termtext, terms[i].docFreq, totalTF);
        }
        TotalTermFreqComparatorSortDescending c = new TotalTermFreqComparatorSortDescending();
        Arrays.sort(ts, c);
        return ts;
    }

    public static long getTotalTermFreq(IndexReader reader, String field, BytesRef termtext) throws Exception {
        BytesRef br = termtext;
        long totalTF = 0L;
        try {
            Bits liveDocs = MultiFields.getLiveDocs(reader);
            totalTF = MultiFields.totalTermFreq(reader, field, termtext);
            return totalTF;
        }
        catch (Exception e) {
            return 0L;
        }
    }

    public static void fillQueue(TermsEnum termsEnum, TermStatsQueue tiq, String field) throws Exception {
        BytesRef term;
        while ((term = termsEnum.next()) != null) {
            BytesRef r = new BytesRef();
            r.copyBytes(term);
            tiq.insertWithOverflow(new TermStats(field, r, termsEnum.docFreq()));
        }
    }
}

