/*
 * Decompiled with CFR 0.152.
 */
package org.getopt.luke;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.AtomicReader;
import org.apache.lucene.index.CompositeReader;
import org.apache.lucene.index.DocsAndPositionsEnum;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.FieldsEnum;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.MultiFields;
import org.apache.lucene.index.SlowCompositeReaderWrapper;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.util.Bits;
import org.getopt.luke.GrowableStringArray;
import org.getopt.luke.IntPair;
import org.getopt.luke.ProgressNotification;
import org.getopt.luke.TermVectorMapper;
import org.getopt.luke.Util;

public class DocReconstructor
extends Observable {
    private ProgressNotification progress = new ProgressNotification();
    private String[] fieldNames = null;
    private AtomicReader reader = null;
    private int numTerms;
    private Bits live;

    public DocReconstructor(IndexReader reader) throws Exception {
        this(reader, null, -1);
    }

    public DocReconstructor(IndexReader reader, String[] fieldNames, int numTerms) throws Exception {
        if (reader == null) {
            throw new Exception("IndexReader cannot be null.");
        }
        if (reader instanceof CompositeReader) {
            this.reader = new SlowCompositeReaderWrapper((CompositeReader)reader);
        } else if (reader instanceof AtomicReader) {
            this.reader = (AtomicReader)reader;
        } else {
            throw new Exception("Unsupported IndexReader class " + reader.getClass().getName());
        }
        this.fieldNames = fieldNames == null || fieldNames.length == 0 ? Util.fieldNames(reader, false).toArray(new String[0]) : fieldNames;
        if (numTerms == -1) {
            Fields fields = MultiFields.getFields(reader);
            numTerms = 0;
            FieldsEnum fe = fields.iterator();
            String fld = null;
            while ((fld = fe.next()) != null) {
                Terms t = fe.terms();
                TermsEnum te = t.iterator(null);
                while (te.next() != null) {
                    ++numTerms;
                }
            }
            this.numTerms = numTerms;
        }
        this.live = MultiFields.getLiveDocs(reader);
    }

    public Reconstructed reconstruct(int docNum) throws Exception {
        if (docNum < 0 || docNum > this.reader.maxDoc()) {
            throw new Exception("Document number outside of valid range.");
        }
        Reconstructed res = new Reconstructed();
        if (this.live != null && !this.live.get(docNum)) {
            throw new Exception("Document is deleted.");
        }
        Document doc = this.reader.document(docNum);
        for (int i = 0; i < this.fieldNames.length; ++i) {
            IndexableField[] fs = doc.getFields(this.fieldNames[i]);
            if (fs == null || fs.length <= 0) continue;
            res.getStoredFields().put(this.fieldNames[i], fs);
        }
        HashSet<String> fields = new HashSet<String>(Arrays.asList(this.fieldNames));
        this.progress.maxValue = this.fieldNames.length;
        this.progress.curValue = 0;
        this.progress.minValue = 0;
        TermsEnum te = null;
        DocsAndPositionsEnum dpe = null;
        for (int i = 0; i < this.fieldNames.length; ++i) {
            Terms tvf = this.reader.getTermVector(docNum, this.fieldNames[i]);
            if (tvf == null) continue;
            te = tvf.iterator(te);
            this.progress.message = "Checking term vectors for '" + this.fieldNames[i] + "' ...";
            this.progress.curValue = i;
            this.setChanged();
            this.notifyObservers(this.progress);
            List<IntPair> vectors = TermVectorMapper.map(tvf, te, false, true);
            if (vectors == null) continue;
            GrowableStringArray gsa = res.getReconstructedFields().get(this.fieldNames[i]);
            if (gsa == null) {
                gsa = new GrowableStringArray();
                res.getReconstructedFields().put(this.fieldNames[i], gsa);
            }
            for (IntPair ip : vectors) {
                for (int m = 0; m < ip.positions.length; ++m) {
                    gsa.append(ip.positions[m], "|", ip.text);
                }
            }
            fields.remove(this.fieldNames[i]);
        }
        this.progress.maxValue = fields.size();
        this.progress.curValue = 0;
        this.progress.minValue = 0;
        for (String fld : fields) {
            DocsAndPositionsEnum newDpe;
            this.progress.message = "Collecting terms in " + fld + " ...";
            ++this.progress.curValue;
            this.setChanged();
            this.notifyObservers(this.progress);
            Terms terms = MultiFields.getTerms(this.reader, fld);
            if (terms == null) continue;
            te = terms.iterator(te);
            while (te.next() != null && (newDpe = te.docsAndPositions(this.live, dpe, false)) != null) {
                dpe = newDpe;
                int num = dpe.advance(docNum);
                if (num != docNum) continue;
                String term = te.term().utf8ToString();
                GrowableStringArray gsa = res.getReconstructedFields().get(fld);
                if (gsa == null) {
                    gsa = new GrowableStringArray();
                    res.getReconstructedFields().put(fld, gsa);
                }
                for (int k = 0; k < dpe.freq(); ++k) {
                    int pos = dpe.nextPosition();
                    gsa.append(pos, "|", term);
                }
            }
        }
        this.progress.message = "Done.";
        this.progress.curValue = 100;
        this.setChanged();
        this.notifyObservers(this.progress);
        return res;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Reconstructed {
        private Map<String, IndexableField[]> storedFields;
        private Map<String, GrowableStringArray> reconstructedFields;

        public Reconstructed() {
            this.storedFields = new HashMap<String, IndexableField[]>();
            this.reconstructedFields = new HashMap<String, GrowableStringArray>();
        }

        public Reconstructed(Map<String, IndexableField[]> storedFields, Map<String, GrowableStringArray> reconstructedFields) {
            this.storedFields = storedFields;
            this.reconstructedFields = reconstructedFields;
        }

        public List<String> getFieldNames() {
            HashSet<String> names = new HashSet<String>();
            names.addAll(this.storedFields.keySet());
            names.addAll(this.reconstructedFields.keySet());
            ArrayList<String> res = new ArrayList<String>(names.size());
            res.addAll(names);
            Collections.sort(res);
            return res;
        }

        public boolean hasField(String name) {
            return this.storedFields.containsKey(name) || this.reconstructedFields.containsKey(name);
        }

        public Map<String, IndexableField[]> getStoredFields() {
            return this.storedFields;
        }

        public Map<String, GrowableStringArray> getReconstructedFields() {
            return this.reconstructedFields;
        }
    }
}

