/*
 * Decompiled with CFR 0.152.
 */
package org.getopt.luke;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.search.Scorer;
import org.getopt.luke.AccessibleHitCollector;

class AllHitsCollector
extends AccessibleHitCollector {
    private ArrayList<AllHit> hits = new ArrayList();

    public AllHitsCollector(boolean outOfOrder, boolean shouldScore) {
        this.outOfOrder = outOfOrder;
        this.shouldScore = shouldScore;
    }

    public void collect(int doc) {
        float score = 1.0f;
        if (this.shouldScore) {
            try {
                score = this.scorer.score();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.hits.add(new AllHit(this.docBase + doc, score));
    }

    public int getTotalHits() {
        return this.hits.size();
    }

    public int getDocId(int i) {
        return this.hits.get((int)i).docId;
    }

    public float getScore(int i) {
        return this.hits.get((int)i).score;
    }

    public boolean acceptsDocsOutOfOrder() {
        return this.outOfOrder;
    }

    public void setNextReader(AtomicReaderContext context) throws IOException {
        this.docBase = context.docBase;
    }

    public void setScorer(Scorer scorer) throws IOException {
        this.scorer = scorer;
    }

    public void reset() {
        this.hits.clear();
    }

    private static class AllHit {
        public int docId;
        public float score;

        public AllHit(int docId, float score) {
            this.docId = docId;
            this.score = score;
        }
    }
}

