/*
 * Decompiled with CFR 0.152.
 */
package org.getopt.luke;

import java.io.IOException;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopScoreDocCollector;
import org.getopt.luke.AccessibleHitCollector;
import org.getopt.luke.NoScoringScorer;

public class AccessibleTopHitCollector
extends AccessibleHitCollector {
    private TopScoreDocCollector tdc;
    private TopDocs topDocs = null;
    private int size;

    public AccessibleTopHitCollector(int size, boolean outOfOrder, boolean shouldScore) {
        this.tdc = TopScoreDocCollector.create(size, outOfOrder);
        this.shouldScore = shouldScore;
        this.outOfOrder = outOfOrder;
        this.size = size;
    }

    public int getDocId(int pos) {
        if (this.topDocs == null) {
            this.topDocs = this.tdc.topDocs();
        }
        return this.topDocs.scoreDocs[pos].doc;
    }

    public float getScore(int pos) {
        if (this.topDocs == null) {
            this.topDocs = this.tdc.topDocs();
        }
        return this.topDocs.scoreDocs[pos].score;
    }

    public int getTotalHits() {
        return this.tdc.getTotalHits();
    }

    public boolean acceptsDocsOutOfOrder() {
        return this.tdc.acceptsDocsOutOfOrder();
    }

    public void collect(int doc) throws IOException {
        this.tdc.collect(doc);
    }

    public void setNextReader(AtomicReaderContext context) throws IOException {
        this.docBase = context.docBase;
        this.tdc.setNextReader(context);
    }

    public void setScorer(Scorer scorer) throws IOException {
        if (this.shouldScore) {
            this.tdc.setScorer(scorer);
        } else {
            this.tdc.setScorer(NoScoringScorer.INSTANCE);
        }
    }

    public void reset() {
        this.tdc = TopScoreDocCollector.create(this.size, this.outOfOrder);
        this.topDocs = null;
    }
}

