/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.update.processor;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.update.AddUpdateCommand;
import org.apache.solr.update.CommitUpdateCommand;
import org.apache.solr.update.DeleteUpdateCommand;
import org.apache.solr.update.MergeIndexesCommand;
import org.apache.solr.update.RollbackUpdateCommand;
import org.apache.solr.update.processor.LogUpdateProcessorFactory;
import org.apache.solr.update.processor.UpdateRequestProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class LogUpdateProcessor
extends UpdateRequestProcessor {
    public static final Logger log = LoggerFactory.getLogger(LogUpdateProcessor.class);
    private final SolrQueryRequest req;
    private final SolrQueryResponse rsp;
    private final NamedList<Object> toLog;
    int numAdds;
    int numDeletes;
    private List<String> adds;
    private List<String> deletes;
    private final int maxNumToLog;
    private final boolean logDebug = log.isDebugEnabled();

    public LogUpdateProcessor(SolrQueryRequest req, SolrQueryResponse rsp, LogUpdateProcessorFactory factory, UpdateRequestProcessor next) {
        super(next);
        this.req = req;
        this.rsp = rsp;
        this.maxNumToLog = factory.maxNumToLog;
        this.toLog = new SimpleOrderedMap<Object>();
    }

    @Override
    public void processAdd(AddUpdateCommand cmd) throws IOException {
        if (this.logDebug) {
            log.debug("PRE_UPDATE " + cmd.toString());
        }
        if (this.next != null) {
            this.next.processAdd(cmd);
        }
        if (this.adds == null) {
            this.adds = new ArrayList<String>();
            this.toLog.add("add", this.adds);
        }
        if (this.adds.size() < this.maxNumToLog) {
            long version = cmd.getVersion();
            String msg = cmd.getPrintableId();
            if (version != 0L) {
                msg = msg + " (" + version + ')';
            }
            this.adds.add(msg);
        }
        ++this.numAdds;
    }

    @Override
    public void processDelete(DeleteUpdateCommand cmd) throws IOException {
        if (this.logDebug) {
            log.debug("PRE_UPDATE " + cmd.toString());
        }
        if (this.next != null) {
            this.next.processDelete(cmd);
        }
        if (cmd.isDeleteById()) {
            if (this.deletes == null) {
                this.deletes = new ArrayList<String>();
                this.toLog.add("delete", this.deletes);
            }
            if (this.deletes.size() < this.maxNumToLog) {
                long version = cmd.getVersion();
                String msg = cmd.getId();
                if (version != 0L) {
                    msg = msg + " (" + version + ')';
                }
                this.deletes.add(msg);
            }
        } else if (this.toLog.size() < this.maxNumToLog) {
            long version = cmd.getVersion();
            String msg = cmd.query;
            if (version != 0L) {
                msg = msg + " (" + version + ')';
            }
            this.toLog.add("deleteByQuery", msg);
        }
        ++this.numDeletes;
    }

    @Override
    public void processMergeIndexes(MergeIndexesCommand cmd) throws IOException {
        if (this.logDebug) {
            log.debug("PRE_UPDATE " + cmd.toString());
        }
        if (this.next != null) {
            this.next.processMergeIndexes(cmd);
        }
        this.toLog.add("mergeIndexes", cmd.toString());
    }

    @Override
    public void processCommit(CommitUpdateCommand cmd) throws IOException {
        if (this.logDebug) {
            log.debug("PRE_UPDATE " + cmd.toString());
        }
        if (this.next != null) {
            this.next.processCommit(cmd);
        }
        String msg = cmd.optimize ? "optimize" : "commit";
        this.toLog.add(msg, "");
    }

    @Override
    public void processRollback(RollbackUpdateCommand cmd) throws IOException {
        if (this.logDebug) {
            log.debug("PRE_UPDATE " + cmd.toString());
        }
        if (this.next != null) {
            this.next.processRollback(cmd);
        }
        this.toLog.add("rollback", "");
    }

    @Override
    public void finish() throws IOException {
        if (this.logDebug) {
            log.debug("PRE_UPDATE finish()");
        }
        if (this.next != null) {
            this.next.finish();
        }
        NamedList<Object> stdLog = this.rsp.getToLog();
        StringBuilder sb = new StringBuilder(this.req.getCore().getLogId());
        for (int i = 0; i < stdLog.size(); ++i) {
            String name = stdLog.getName(i);
            Object val = stdLog.getVal(i);
            if (name != null) {
                sb.append(name).append('=');
            }
            sb.append(val).append(' ');
        }
        stdLog.clear();
        if (this.adds != null && this.numAdds > this.maxNumToLog) {
            this.adds.add("... (" + this.numAdds + " adds)");
        }
        if (this.deletes != null && this.numDeletes > this.maxNumToLog) {
            this.deletes.add("... (" + this.numDeletes + " deletes)");
        }
        long elapsed = this.rsp.getEndTime() - this.req.getStartTime();
        sb.append(this.toLog).append(" 0 ").append(elapsed);
        log.info(sb.toString());
    }
}

