/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.update;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.lucene.codecs.Codec;
import org.apache.lucene.index.IndexDeletionPolicy;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.InfoStream;
import org.apache.lucene.util.PrintStreamInfoStream;
import org.apache.solr.core.DirectoryFactory;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.update.SolrIndexConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolrIndexWriter
extends IndexWriter {
    private static Logger log = LoggerFactory.getLogger(SolrIndexWriter.class);
    public static final AtomicLong numOpens = new AtomicLong();
    public static final AtomicLong numCloses = new AtomicLong();
    public static final String COMMIT_TIME_MSEC_KEY = "commitTimeMSec";
    String name;
    private DirectoryFactory directoryFactory;
    private volatile boolean isClosed = false;

    public SolrIndexWriter(String name, String path, DirectoryFactory directoryFactory, boolean create, IndexSchema schema, SolrIndexConfig config, IndexDeletionPolicy delPolicy, Codec codec, boolean forceNewDirectory) throws IOException {
        super(directoryFactory.get(path, config.lockType, forceNewDirectory), config.toIndexWriterConfig(schema).setOpenMode(create ? IndexWriterConfig.OpenMode.CREATE : IndexWriterConfig.OpenMode.APPEND).setIndexDeletionPolicy(delPolicy).setCodec(codec).setInfoStream(SolrIndexWriter.toInfoStream(config)));
        log.debug("Opened Writer " + name);
        this.name = name;
        this.directoryFactory = directoryFactory;
        numOpens.incrementAndGet();
    }

    private static InfoStream toInfoStream(SolrIndexConfig config) throws IOException {
        String infoStreamFile = config.infoStreamFile;
        if (infoStreamFile != null) {
            File f = new File(infoStreamFile);
            File parent = f.getParentFile();
            if (parent != null) {
                parent.mkdirs();
            }
            FileOutputStream fos = new FileOutputStream(f, true);
            return new PrintStreamInfoStream(new PrintStream(fos, true));
        }
        return InfoStream.NO_OUTPUT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        log.debug("Closing Writer " + this.name);
        Directory directory = this.getDirectory();
        InfoStream infoStream = this.isClosed ? null : this.getConfig().getInfoStream();
        try {
            super.close();
            if (infoStream != null) {
                infoStream.close();
            }
        }
        finally {
            this.isClosed = true;
            this.directoryFactory.release(directory);
            numCloses.incrementAndGet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback() throws IOException {
        try {
            super.rollback();
        }
        finally {
            this.isClosed = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            if (!this.isClosed) {
                assert (false) : "SolrIndexWriter was not closed prior to finalize()";
                log.error("SolrIndexWriter was not closed prior to finalize(), indicates a bug -- POSSIBLE RESOURCE LEAK!!!");
                this.close();
            }
        }
        finally {
            super.finalize();
        }
    }
}

