/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.servlet;

import java.util.ArrayList;
import java.util.Locale;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.ContentStream;
import org.apache.solr.request.ServletSolrParams;
import org.apache.solr.servlet.MultipartRequestParser;
import org.apache.solr.servlet.RawRequestParser;
import org.apache.solr.servlet.SolrRequestParser;

class StandardRequestParser
implements SolrRequestParser {
    MultipartRequestParser multipart;
    RawRequestParser raw;

    StandardRequestParser(MultipartRequestParser multi, RawRequestParser raw) {
        this.multipart = multi;
        this.raw = raw;
    }

    @Override
    public SolrParams parseParamsAndFillStreams(HttpServletRequest req, ArrayList<ContentStream> streams) throws Exception {
        String method = req.getMethod().toUpperCase(Locale.ENGLISH);
        if ("GET".equals(method) || "HEAD".equals(method)) {
            return new ServletSolrParams((ServletRequest)req);
        }
        if ("POST".equals(method)) {
            String contentType = req.getContentType();
            if (contentType != null) {
                int idx = contentType.indexOf(59);
                if (idx > 0) {
                    contentType = contentType.substring(0, idx);
                }
                if ("application/x-www-form-urlencoded".equals(contentType.toLowerCase(Locale.ENGLISH))) {
                    return new ServletSolrParams((ServletRequest)req);
                }
                if (ServletFileUpload.isMultipartContent((HttpServletRequest)req)) {
                    return this.multipart.parseParamsAndFillStreams(req, streams);
                }
            }
            return this.raw.parseParamsAndFillStreams(req, streams);
        }
        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unsupported method: " + method);
    }
}

