/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.grouping.endresulttransformer;

import java.io.Serializable;
import java.util.Map;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.grouping.GroupDocs;
import org.apache.lucene.search.grouping.TopGroups;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.handler.component.ResponseBuilder;
import org.apache.solr.search.grouping.endresulttransformer.EndResultTransformer;

public class SimpleEndResultTransformer
implements EndResultTransformer {
    @Override
    public void transform(Map<String, ?> result, ResponseBuilder rb, EndResultTransformer.SolrDocumentSource solrDocumentSource) {
        SimpleOrderedMap commands = new SimpleOrderedMap();
        for (Map.Entry<String, ?> entry : result.entrySet()) {
            Object value = entry.getValue();
            if (!TopGroups.class.isInstance(value)) continue;
            TopGroups topGroups = (TopGroups)value;
            SimpleOrderedMap<Serializable> command = new SimpleOrderedMap<Serializable>();
            command.add("matches", Integer.valueOf(rb.totalHitCount));
            if (topGroups.totalGroupCount != null) {
                command.add("ngroups", topGroups.totalGroupCount);
            }
            SolrDocumentList docList = new SolrDocumentList();
            docList.setStart(rb.getGroupingSpec().getOffset());
            docList.setNumFound(topGroups.totalHitCount);
            Float maxScore = Float.valueOf(Float.NEGATIVE_INFINITY);
            for (GroupDocs group : topGroups.groups) {
                for (ScoreDoc scoreDoc : group.scoreDocs) {
                    if (maxScore.floatValue() < scoreDoc.score) {
                        maxScore = Float.valueOf(scoreDoc.score);
                    }
                    docList.add(solrDocumentSource.retrieve(scoreDoc));
                }
            }
            if (maxScore.floatValue() != Float.NEGATIVE_INFINITY) {
                docList.setMaxScore(maxScore);
            }
            command.add("doclist", docList);
            commands.add(entry.getKey(), command);
        }
        rb.rsp.add("grouped", commands);
    }
}

