/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import java.io.IOException;
import org.apache.lucene.index.AtomicReader;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.search.FieldCache;
import org.apache.lucene.search.FieldComparator;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.packed.PackedInts;

class TermOrdValComparator_SML
extends FieldComparator<Comparable> {
    private static final int NULL_ORD = Integer.MAX_VALUE;
    private final int[] ords;
    private final BytesRef[] values;
    private final int[] readerGen;
    private FieldCache.DocTermsIndex termsIndex;
    private final String field;
    private final BytesRef NULL_VAL;
    private PerSegmentComparator current;

    public TermOrdValComparator_SML(int numHits, String field, int sortPos, boolean reversed, BytesRef nullVal) {
        this.ords = new int[numHits];
        this.values = new BytesRef[numHits];
        this.readerGen = new int[numHits];
        this.field = field;
        this.NULL_VAL = nullVal;
    }

    @Override
    public int compare(int slot1, int slot2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setBottom(int slot) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int compareBottom(int doc) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void copy(int slot, int doc) {
        throw new UnsupportedOperationException();
    }

    @Override
    public BytesRef value(int slot) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int compareValues(Comparable first, Comparable second) {
        if (first == null) {
            if (second == null) {
                return 0;
            }
            return 1;
        }
        if (second == null) {
            return -1;
        }
        return first.compareTo(second);
    }

    @Override
    public FieldComparator setNextReader(AtomicReaderContext context) throws IOException {
        return TermOrdValComparator_SML.createComparator(context.reader(), this);
    }

    @Override
    public int compareDocToValue(int doc, Comparable docValue) {
        throw new UnsupportedOperationException();
    }

    public static FieldComparator createComparator(AtomicReader reader, TermOrdValComparator_SML parent) throws IOException {
        parent.termsIndex = FieldCache.DEFAULT.getTermsIndex(reader, parent.field);
        PackedInts.Reader docToOrd = parent.termsIndex.getDocToOrd();
        PerSegmentComparator perSegComp = null;
        if (docToOrd.hasArray()) {
            Object arr = docToOrd.getArray();
            if (arr instanceof byte[]) {
                perSegComp = new ByteOrdComparator((byte[])arr, parent);
            } else if (arr instanceof short[]) {
                perSegComp = new ShortOrdComparator((short[])arr, parent);
            } else if (arr instanceof int[]) {
                perSegComp = new IntOrdComparator((int[])arr, parent);
            }
        }
        if (perSegComp == null) {
            perSegComp = new AnyOrdComparator(docToOrd, parent);
        }
        if (perSegComp.bottomSlot != -1) {
            perSegComp.setBottom(perSegComp.bottomSlot);
        }
        parent.current = perSegComp;
        return perSegComp;
    }

    private static final class AnyOrdComparator
    extends PerSegmentComparator {
        private final PackedInts.Reader readerOrds;

        public AnyOrdComparator(PackedInts.Reader readerOrds, TermOrdValComparator_SML parent) {
            super(parent);
            this.readerOrds = readerOrds;
        }

        @Override
        public int compareBottom(int doc) {
            assert (this.bottomSlot != -1);
            int order = (int)this.readerOrds.get(doc);
            if (order == 0) {
                order = Integer.MAX_VALUE;
            }
            if (this.bottomSameReader) {
                return this.bottomOrd - order;
            }
            int cmp = this.bottomOrd - order;
            if (cmp != 0) {
                return cmp;
            }
            if (order == Integer.MAX_VALUE) {
                return 0;
            }
            this.termsIndex.lookup(order, this.tempBR);
            return this.bottomValue.compareTo(this.tempBR);
        }

        @Override
        public void copy(int slot, int doc) {
            int ord = (int)this.readerOrds.get(doc);
            if (ord == 0) {
                this.ords[slot] = Integer.MAX_VALUE;
                this.values[slot] = null;
            } else {
                this.ords[slot] = ord;
                assert (ord > 0);
                if (this.values[slot] == null) {
                    this.values[slot] = new BytesRef();
                }
                this.termsIndex.lookup(ord, this.values[slot]);
            }
            this.readerGen[slot] = this.currentReaderGen;
        }
    }

    private static final class IntOrdComparator
    extends PerSegmentComparator {
        private final int[] readerOrds;

        public IntOrdComparator(int[] readerOrds, TermOrdValComparator_SML parent) {
            super(parent);
            this.readerOrds = readerOrds;
        }

        @Override
        public int compareBottom(int doc) {
            assert (this.bottomSlot != -1);
            int order = this.readerOrds[doc];
            if (order == 0) {
                order = Integer.MAX_VALUE;
            }
            if (this.bottomSameReader) {
                return this.bottomOrd - order;
            }
            int cmp = this.bottomOrd - order;
            if (cmp != 0) {
                return cmp;
            }
            if (order == Integer.MAX_VALUE) {
                return 0;
            }
            this.termsIndex.lookup(order, this.tempBR);
            return this.bottomValue.compareTo(this.tempBR);
        }

        @Override
        public void copy(int slot, int doc) {
            int ord = this.readerOrds[doc];
            if (ord == 0) {
                this.ords[slot] = Integer.MAX_VALUE;
                this.values[slot] = null;
            } else {
                this.ords[slot] = ord;
                assert (ord > 0);
                if (this.values[slot] == null) {
                    this.values[slot] = new BytesRef();
                }
                this.termsIndex.lookup(ord, this.values[slot]);
            }
            this.readerGen[slot] = this.currentReaderGen;
        }
    }

    private static final class ShortOrdComparator
    extends PerSegmentComparator {
        private final short[] readerOrds;

        public ShortOrdComparator(short[] readerOrds, TermOrdValComparator_SML parent) {
            super(parent);
            this.readerOrds = readerOrds;
        }

        @Override
        public int compareBottom(int doc) {
            assert (this.bottomSlot != -1);
            int order = this.readerOrds[doc] & 0xFFFF;
            if (order == 0) {
                order = Integer.MAX_VALUE;
            }
            if (this.bottomSameReader) {
                return this.bottomOrd - order;
            }
            int cmp = this.bottomOrd - order;
            if (cmp != 0) {
                return cmp;
            }
            if (order == Integer.MAX_VALUE) {
                return 0;
            }
            this.termsIndex.lookup(order, this.tempBR);
            return this.bottomValue.compareTo(this.tempBR);
        }

        @Override
        public void copy(int slot, int doc) {
            int ord = this.readerOrds[doc] & 0xFFFF;
            if (ord == 0) {
                this.ords[slot] = Integer.MAX_VALUE;
                this.values[slot] = null;
            } else {
                this.ords[slot] = ord;
                assert (ord > 0);
                if (this.values[slot] == null) {
                    this.values[slot] = new BytesRef();
                }
                this.termsIndex.lookup(ord, this.values[slot]);
            }
            this.readerGen[slot] = this.currentReaderGen;
        }
    }

    private static final class ByteOrdComparator
    extends PerSegmentComparator {
        private final byte[] readerOrds;

        public ByteOrdComparator(byte[] readerOrds, TermOrdValComparator_SML parent) {
            super(parent);
            this.readerOrds = readerOrds;
        }

        @Override
        public int compareBottom(int doc) {
            assert (this.bottomSlot != -1);
            int order = this.readerOrds[doc] & 0xFF;
            if (order == 0) {
                order = Integer.MAX_VALUE;
            }
            if (this.bottomSameReader) {
                return this.bottomOrd - order;
            }
            int cmp = this.bottomOrd - order;
            if (cmp != 0) {
                return cmp;
            }
            if (order == Integer.MAX_VALUE) {
                return 0;
            }
            this.termsIndex.lookup(order, this.tempBR);
            return this.bottomValue.compareTo(this.tempBR);
        }

        @Override
        public void copy(int slot, int doc) {
            int ord = this.readerOrds[doc] & 0xFF;
            if (ord == 0) {
                this.ords[slot] = Integer.MAX_VALUE;
                this.values[slot] = null;
            } else {
                this.ords[slot] = ord;
                assert (ord > 0);
                if (this.values[slot] == null) {
                    this.values[slot] = new BytesRef();
                }
                this.termsIndex.lookup(ord, this.values[slot]);
            }
            this.readerGen[slot] = this.currentReaderGen;
        }
    }

    private static abstract class PerSegmentComparator
    extends FieldComparator<BytesRef> {
        protected TermOrdValComparator_SML parent;
        protected final int[] ords;
        protected final BytesRef[] values;
        protected final int[] readerGen;
        protected int currentReaderGen = -1;
        protected FieldCache.DocTermsIndex termsIndex;
        protected int bottomSlot = -1;
        protected int bottomOrd;
        protected boolean bottomSameReader = false;
        protected BytesRef bottomValue;
        protected final BytesRef tempBR = new BytesRef();

        public PerSegmentComparator(TermOrdValComparator_SML parent) {
            this.parent = parent;
            PerSegmentComparator previous = parent.current;
            if (previous != null) {
                this.currentReaderGen = previous.currentReaderGen;
                this.bottomSlot = previous.bottomSlot;
                this.bottomOrd = previous.bottomOrd;
                this.bottomValue = previous.bottomValue;
            }
            this.ords = parent.ords;
            this.values = parent.values;
            this.readerGen = parent.readerGen;
            this.termsIndex = parent.termsIndex;
            ++this.currentReaderGen;
        }

        @Override
        public FieldComparator setNextReader(AtomicReaderContext context) throws IOException {
            return TermOrdValComparator_SML.createComparator(context.reader(), this.parent);
        }

        @Override
        public int compare(int slot1, int slot2) {
            if (this.readerGen[slot1] == this.readerGen[slot2]) {
                return this.ords[slot1] - this.ords[slot2];
            }
            BytesRef val1 = this.values[slot1];
            BytesRef val2 = this.values[slot2];
            if (val1 == null) {
                if (val2 == null) {
                    return 0;
                }
                return 1;
            }
            if (val2 == null) {
                return -1;
            }
            return val1.compareTo(val2);
        }

        @Override
        public void setBottom(int bottom) {
            this.bottomSlot = bottom;
            this.bottomValue = this.values[this.bottomSlot];
            if (this.currentReaderGen == this.readerGen[this.bottomSlot]) {
                this.bottomOrd = this.ords[this.bottomSlot];
                this.bottomSameReader = true;
            } else if (this.bottomValue == null) {
                assert (this.ords[this.bottomSlot] == Integer.MAX_VALUE);
                this.bottomOrd = Integer.MAX_VALUE;
                this.bottomSameReader = true;
                this.readerGen[this.bottomSlot] = this.currentReaderGen;
            } else {
                int index = PerSegmentComparator.binarySearch(this.tempBR, this.termsIndex, this.bottomValue);
                if (index < 0) {
                    this.bottomOrd = -index - 2;
                    this.bottomSameReader = false;
                } else {
                    this.bottomOrd = index;
                    this.bottomSameReader = true;
                    this.readerGen[this.bottomSlot] = this.currentReaderGen;
                    this.ords[this.bottomSlot] = this.bottomOrd;
                }
            }
        }

        @Override
        public BytesRef value(int slot) {
            return this.values == null ? this.parent.NULL_VAL : this.values[slot];
        }

        @Override
        public int compareDocToValue(int doc, BytesRef value) {
            BytesRef docValue = this.termsIndex.getTerm(doc, this.tempBR);
            if (docValue == null) {
                if (value == null) {
                    return 0;
                }
                return 1;
            }
            if (value == null) {
                return -1;
            }
            return docValue.compareTo(value);
        }
    }
}

