/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;

public class SortSpec {
    Sort sort;
    int num;
    int offset;

    public SortSpec(Sort sort, int num) {
        this(sort, 0, num);
    }

    public SortSpec(Sort sort, int offset, int num) {
        this.sort = sort;
        this.offset = offset;
        this.num = num;
    }

    public void setSort(Sort s) {
        this.sort = s;
    }

    public static boolean includesScore(Sort sort) {
        if (sort == null) {
            return true;
        }
        for (SortField sf : sort.getSort()) {
            if (sf.getType() != SortField.Type.SCORE) continue;
            return true;
        }
        return false;
    }

    public boolean includesScore() {
        return SortSpec.includesScore(this.sort);
    }

    public Sort getSort() {
        return this.sort;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getCount() {
        return this.num;
    }

    public String toString() {
        return "start=" + this.offset + "&rows=" + this.num + (this.sort == null ? "" : "&sort=" + this.sort);
    }
}

