/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import java.io.IOException;
import org.apache.lucene.index.AtomicReader;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.search.BitsFilteredDocIdSet;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Filter;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.OpenBitSet;
import org.apache.solr.common.SolrException;
import org.apache.solr.search.BitDocSet;
import org.apache.solr.search.DocIterator;
import org.apache.solr.search.DocList;
import org.apache.solr.search.DocSet;

abstract class DocSetBase
implements DocSet {
    DocSetBase() {
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DocSet)) {
            return false;
        }
        DocSet other = (DocSet)obj;
        if (this.size() != other.size()) {
            return false;
        }
        if (this instanceof DocList && other instanceof DocList) {
            DocIterator i1 = this.iterator();
            DocIterator i2 = other.iterator();
            while (i1.hasNext() && i2.hasNext()) {
                if (i1.nextDoc() == i2.nextDoc()) continue;
                return false;
            }
            return true;
        }
        return this.getBits().equals(other.getBits());
    }

    @Override
    public void add(int doc) {
        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unsupported Operation");
    }

    @Override
    public void addUnique(int doc) {
        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unsupported Operation");
    }

    @Override
    public OpenBitSet getBits() {
        OpenBitSet bits = new OpenBitSet();
        DocIterator iter = this.iterator();
        while (iter.hasNext()) {
            bits.set(iter.nextDoc());
        }
        return bits;
    }

    @Override
    public DocSet intersection(DocSet other) {
        if (!(other instanceof BitDocSet)) {
            return other.intersection(this);
        }
        OpenBitSet newbits = this.getBits().clone();
        newbits.and(other.getBits());
        return new BitDocSet(newbits);
    }

    @Override
    public boolean intersects(DocSet other) {
        if (!(other instanceof BitDocSet)) {
            return other.intersects(this);
        }
        return this.intersectionSize(other) > 0;
    }

    @Override
    public DocSet union(DocSet other) {
        OpenBitSet newbits = this.getBits().clone();
        newbits.or(other.getBits());
        return new BitDocSet(newbits);
    }

    @Override
    public int intersectionSize(DocSet other) {
        if (!(other instanceof BitDocSet)) {
            return other.intersectionSize(this);
        }
        return this.intersection(other).size();
    }

    @Override
    public int unionSize(DocSet other) {
        return this.size() + other.size() - this.intersectionSize(other);
    }

    @Override
    public DocSet andNot(DocSet other) {
        OpenBitSet newbits = this.getBits().clone();
        newbits.andNot(other.getBits());
        return new BitDocSet(newbits);
    }

    @Override
    public int andNotSize(DocSet other) {
        return this.size() - this.intersectionSize(other);
    }

    @Override
    public Filter getTopFilter() {
        final OpenBitSet bs = this.getBits();
        return new Filter(){

            @Override
            public DocIdSet getDocIdSet(AtomicReaderContext context, Bits acceptDocs) throws IOException {
                Bits acceptDocs2;
                AtomicReader reader = context.reader();
                Bits bits = acceptDocs == null ? null : (acceptDocs2 = reader.getLiveDocs() == acceptDocs ? null : acceptDocs);
                if (context.isTopLevel) {
                    return BitsFilteredDocIdSet.wrap(bs, acceptDocs);
                }
                final int base = context.docBase;
                int maxDoc = reader.maxDoc();
                final int max = base + maxDoc;
                return BitsFilteredDocIdSet.wrap(new DocIdSet(){

                    @Override
                    public DocIdSetIterator iterator() throws IOException {
                        return new DocIdSetIterator(){
                            int pos;
                            int adjustedDoc;
                            {
                                this.pos = base - 1;
                                this.adjustedDoc = -1;
                            }

                            @Override
                            public int docID() {
                                return this.adjustedDoc;
                            }

                            @Override
                            public int nextDoc() throws IOException {
                                this.pos = bs.nextSetBit(this.pos + 1);
                                this.adjustedDoc = this.pos >= 0 && this.pos < max ? this.pos - base : Integer.MAX_VALUE;
                                return this.adjustedDoc;
                            }

                            @Override
                            public int advance(int target) throws IOException {
                                if (target == Integer.MAX_VALUE) {
                                    this.adjustedDoc = Integer.MAX_VALUE;
                                    return Integer.MAX_VALUE;
                                }
                                this.pos = bs.nextSetBit(target + base);
                                this.adjustedDoc = this.pos >= 0 && this.pos < max ? this.pos - base : Integer.MAX_VALUE;
                                return this.adjustedDoc;
                            }
                        };
                    }

                    @Override
                    public boolean isCacheable() {
                        return true;
                    }

                    @Override
                    public Bits bits() throws IOException {
                        return null;
                    }
                }, acceptDocs2);
            }
        };
    }

    @Override
    public void setBitsOn(OpenBitSet target) {
        DocIterator iter = this.iterator();
        while (iter.hasNext()) {
            target.fastSet(iter.nextDoc());
        }
    }
}

