/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import org.apache.lucene.queries.function.BoostedQuery;
import org.apache.lucene.queries.function.FunctionQuery;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.queries.function.valuesource.QueryValueSource;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.search.Query;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.search.FunctionQParserPlugin;
import org.apache.solr.search.QParser;
import org.apache.solr.search.QParserPlugin;

public class BoostQParserPlugin
extends QParserPlugin {
    public static String NAME = "boost";
    public static String BOOSTFUNC = "b";

    @Override
    public void init(NamedList args) {
    }

    @Override
    public QParser createParser(String qstr, SolrParams localParams, SolrParams params, SolrQueryRequest req) {
        return new QParser(qstr, localParams, params, req){
            QParser baseParser;
            ValueSource vs;
            String b;

            @Override
            public Query parse() throws ParseException {
                this.b = this.localParams.get(BOOSTFUNC);
                this.baseParser = this.subQuery(this.localParams.get("v"), null);
                Query q = this.baseParser.getQuery();
                if (this.b == null) {
                    return q;
                }
                Query bq = this.subQuery(this.b, FunctionQParserPlugin.NAME).getQuery();
                this.vs = bq instanceof FunctionQuery ? ((FunctionQuery)bq).getValueSource() : new QueryValueSource(bq, 0.0f);
                return new BoostedQuery(q, this.vs);
            }

            @Override
            public String[] getDefaultHighlightFields() {
                return this.baseParser.getDefaultHighlightFields();
            }

            @Override
            public Query getHighlightQuery() throws ParseException {
                return this.baseParser.getHighlightQuery();
            }

            @Override
            public void addDebugInfo(NamedList<Object> debugInfo) {
                this.baseParser.addDebugInfo(debugInfo);
                debugInfo.add("boost_str", this.b);
                debugInfo.add("boost_parsed", this.vs);
            }
        };
    }
}

