/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import java.io.IOException;
import org.apache.lucene.index.AtomicReader;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.search.BitsFilteredDocIdSet;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Filter;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.OpenBitSet;
import org.apache.lucene.util.OpenBitSetIterator;
import org.apache.solr.search.DocIterator;
import org.apache.solr.search.DocSet;
import org.apache.solr.search.DocSetBase;

public class BitDocSet
extends DocSetBase {
    final OpenBitSet bits;
    int size;

    public BitDocSet() {
        this.bits = new OpenBitSet();
    }

    public BitDocSet(OpenBitSet bits) {
        this.bits = bits;
        this.size = -1;
    }

    public BitDocSet(OpenBitSet bits, int size) {
        this.bits = bits;
        this.size = size;
    }

    @Override
    public DocIterator iterator() {
        return new DocIterator(){
            private final OpenBitSetIterator iter;
            private int pos;
            {
                this.iter = new OpenBitSetIterator(BitDocSet.this.bits);
                this.pos = this.iter.nextDoc();
            }

            @Override
            public boolean hasNext() {
                return this.pos != Integer.MAX_VALUE;
            }

            @Override
            public Integer next() {
                return this.nextDoc();
            }

            @Override
            public void remove() {
                BitDocSet.this.bits.clear(this.pos);
            }

            @Override
            public int nextDoc() {
                int old = this.pos;
                this.pos = this.iter.nextDoc();
                return old;
            }

            @Override
            public float score() {
                return 0.0f;
            }
        };
    }

    @Override
    public OpenBitSet getBits() {
        return this.bits;
    }

    @Override
    public void add(int doc) {
        this.bits.set(doc);
        this.size = -1;
    }

    @Override
    public void addUnique(int doc) {
        this.bits.set(doc);
        this.size = -1;
    }

    @Override
    public int size() {
        if (this.size != -1) {
            return this.size;
        }
        this.size = (int)this.bits.cardinality();
        return this.size;
    }

    public void invalidateSize() {
        this.size = -1;
    }

    @Override
    public boolean exists(int doc) {
        return this.bits.fastGet(doc);
    }

    @Override
    public int intersectionSize(DocSet other) {
        if (other instanceof BitDocSet) {
            return (int)OpenBitSet.intersectionCount(this.bits, ((BitDocSet)other).bits);
        }
        return other.intersectionSize(this);
    }

    @Override
    public boolean intersects(DocSet other) {
        if (other instanceof BitDocSet) {
            return this.bits.intersects(((BitDocSet)other).bits);
        }
        return other.intersects(this);
    }

    @Override
    public int unionSize(DocSet other) {
        if (other instanceof BitDocSet) {
            return (int)OpenBitSet.unionCount(this.bits, ((BitDocSet)other).bits);
        }
        return other.unionSize(this);
    }

    @Override
    public int andNotSize(DocSet other) {
        if (other instanceof BitDocSet) {
            return (int)OpenBitSet.andNotCount(this.bits, ((BitDocSet)other).bits);
        }
        return super.andNotSize(other);
    }

    @Override
    public void setBitsOn(OpenBitSet target) {
        target.union(this.bits);
    }

    @Override
    public DocSet andNot(DocSet other) {
        OpenBitSet newbits = this.bits.clone();
        if (other instanceof BitDocSet) {
            newbits.andNot(((BitDocSet)other).bits);
        } else {
            DocIterator iter = other.iterator();
            while (iter.hasNext()) {
                newbits.clear(iter.nextDoc());
            }
        }
        return new BitDocSet(newbits);
    }

    @Override
    public DocSet union(DocSet other) {
        OpenBitSet newbits = this.bits.clone();
        if (other instanceof BitDocSet) {
            newbits.union(((BitDocSet)other).bits);
        } else {
            DocIterator iter = other.iterator();
            while (iter.hasNext()) {
                newbits.set(iter.nextDoc());
            }
        }
        return new BitDocSet(newbits);
    }

    @Override
    public long memSize() {
        return (this.bits.getBits().length << 3) + 16;
    }

    protected BitDocSet clone() {
        return new BitDocSet(this.bits.clone(), this.size);
    }

    @Override
    public Filter getTopFilter() {
        final OpenBitSet bs = this.bits;
        return new Filter(){

            @Override
            public DocIdSet getDocIdSet(AtomicReaderContext context, Bits acceptDocs) throws IOException {
                Bits acceptDocs2;
                AtomicReader reader = context.reader();
                Bits bits = acceptDocs == null ? null : (acceptDocs2 = reader.getLiveDocs() == acceptDocs ? null : acceptDocs);
                if (context.isTopLevel) {
                    return BitsFilteredDocIdSet.wrap(bs, acceptDocs);
                }
                final int base = context.docBase;
                final int maxDoc = reader.maxDoc();
                final int max = base + maxDoc;
                return BitsFilteredDocIdSet.wrap(new DocIdSet(){

                    @Override
                    public DocIdSetIterator iterator() throws IOException {
                        return new DocIdSetIterator(){
                            int pos;
                            int adjustedDoc;
                            {
                                this.pos = base - 1;
                                this.adjustedDoc = -1;
                            }

                            @Override
                            public int docID() {
                                return this.adjustedDoc;
                            }

                            @Override
                            public int nextDoc() throws IOException {
                                this.pos = bs.nextSetBit(this.pos + 1);
                                this.adjustedDoc = this.pos >= 0 && this.pos < max ? this.pos - base : Integer.MAX_VALUE;
                                return this.adjustedDoc;
                            }

                            @Override
                            public int advance(int target) throws IOException {
                                if (target == Integer.MAX_VALUE) {
                                    this.adjustedDoc = Integer.MAX_VALUE;
                                    return Integer.MAX_VALUE;
                                }
                                this.pos = bs.nextSetBit(target + base);
                                this.adjustedDoc = this.pos >= 0 && this.pos < max ? this.pos - base : Integer.MAX_VALUE;
                                return this.adjustedDoc;
                            }
                        };
                    }

                    @Override
                    public boolean isCacheable() {
                        return true;
                    }

                    @Override
                    public Bits bits() throws IOException {
                        return new Bits(){

                            @Override
                            public boolean get(int index) {
                                return bs.fastGet(index + base);
                            }

                            @Override
                            public int length() {
                                return maxDoc;
                            }
                        };
                    }
                }, acceptDocs2);
            }
        };
    }
}

