/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.schema;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.docvalues.DocTermsIndexDocValues;
import org.apache.lucene.queries.function.valuesource.FieldCacheSource;
import org.apache.solr.schema.SortableFloatFieldSource;

public class StrFieldSource
extends FieldCacheSource {
    private static int hcode = SortableFloatFieldSource.class.hashCode();

    public StrFieldSource(String field) {
        super(field);
    }

    @Override
    public String description() {
        return "str(" + this.field + ')';
    }

    @Override
    public FunctionValues getValues(Map context, AtomicReaderContext readerContext) throws IOException {
        return new DocTermsIndexDocValues(this, readerContext, this.field){

            @Override
            protected String toTerm(String readableValue) {
                return readableValue;
            }

            @Override
            public int ordVal(int doc) {
                return this.termsIndex.getOrd(doc);
            }

            @Override
            public int numOrd() {
                return this.termsIndex.numOrd();
            }

            @Override
            public Object objectVal(int doc) {
                return this.strVal(doc);
            }

            @Override
            public String toString(int doc) {
                return StrFieldSource.this.description() + '=' + this.strVal(doc);
            }
        };
    }

    @Override
    public boolean equals(Object o) {
        return o instanceof StrFieldSource && super.equals(o);
    }

    @Override
    public int hashCode() {
        return hcode + super.hashCode();
    }
}

