/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.schema;

import java.io.IOException;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.search.SortField;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.CharsRef;
import org.apache.lucene.util.UnicodeUtil;
import org.apache.solr.response.TextResponseWriter;
import org.apache.solr.schema.PrimitiveFieldType;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.schema.SortableLongFieldSource;
import org.apache.solr.search.QParser;
import org.apache.solr.util.NumberUtils;

@Deprecated
public class SortableLongField
extends PrimitiveFieldType {
    @Override
    public SortField getSortField(SchemaField field, boolean reverse) {
        return this.getStringSort(field, reverse);
    }

    @Override
    public ValueSource getValueSource(SchemaField field, QParser qparser) {
        field.checkFieldCacheSource(qparser);
        return new SortableLongFieldSource(field.name);
    }

    @Override
    public String toInternal(String val) {
        return NumberUtils.long2sortableStr(val);
    }

    @Override
    public String indexedToReadable(String indexedForm) {
        return NumberUtils.SortableStr2long(indexedForm);
    }

    @Override
    public CharsRef indexedToReadable(BytesRef input, CharsRef charsRef) {
        UnicodeUtil.UTF8toUTF16(input, charsRef);
        char[] indexedToReadable = this.indexedToReadable(charsRef.toString()).toCharArray();
        charsRef.copyChars(indexedToReadable, 0, indexedToReadable.length);
        return charsRef;
    }

    @Override
    public String toExternal(IndexableField f) {
        return this.indexedToReadable(f.stringValue());
    }

    @Override
    public Long toObject(IndexableField f) {
        return NumberUtils.SortableStr2long(f.stringValue(), 0, 5);
    }

    @Override
    public void write(TextResponseWriter writer, String name, IndexableField f) throws IOException {
        String sval = f.stringValue();
        writer.writeLong(name, NumberUtils.SortableStr2long(sval, 0, sval.length()));
    }
}

