/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.schema;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.docvalues.DocTermsIndexDocValues;
import org.apache.lucene.queries.function.valuesource.FieldCacheSource;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.mutable.MutableValue;
import org.apache.lucene.util.mutable.MutableValueInt;
import org.apache.solr.util.NumberUtils;

class SortableIntFieldSource
extends FieldCacheSource {
    protected int defVal;
    private static int hcode = SortableIntFieldSource.class.hashCode();

    public SortableIntFieldSource(String field) {
        this(field, 0);
    }

    public SortableIntFieldSource(String field, int defVal) {
        super(field);
        this.defVal = defVal;
    }

    @Override
    public String description() {
        return "sint(" + this.field + ')';
    }

    @Override
    public FunctionValues getValues(Map context, AtomicReaderContext readerContext) throws IOException {
        final int def = this.defVal;
        return new DocTermsIndexDocValues(this, readerContext, this.field){
            private final BytesRef spare;
            {
                super(x0, x1, x2);
                this.spare = new BytesRef();
            }

            @Override
            protected String toTerm(String readableValue) {
                return NumberUtils.int2sortableStr(readableValue);
            }

            @Override
            public float floatVal(int doc) {
                return this.intVal(doc);
            }

            @Override
            public int intVal(int doc) {
                int ord = this.termsIndex.getOrd(doc);
                return ord == 0 ? def : NumberUtils.SortableStr2int(this.termsIndex.lookup(ord, this.spare), 0, 3);
            }

            @Override
            public long longVal(int doc) {
                return this.intVal(doc);
            }

            @Override
            public double doubleVal(int doc) {
                return this.intVal(doc);
            }

            @Override
            public String strVal(int doc) {
                return Integer.toString(this.intVal(doc));
            }

            @Override
            public String toString(int doc) {
                return SortableIntFieldSource.this.description() + '=' + this.intVal(doc);
            }

            @Override
            public Object objectVal(int doc) {
                int ord = this.termsIndex.getOrd(doc);
                return ord == 0 ? null : NumberUtils.SortableStr2int(this.termsIndex.lookup(ord, this.spare));
            }

            @Override
            public FunctionValues.ValueFiller getValueFiller() {
                return new FunctionValues.ValueFiller(){
                    private final MutableValueInt mval = new MutableValueInt();

                    @Override
                    public MutableValue getValue() {
                        return this.mval;
                    }

                    @Override
                    public void fillValue(int doc) {
                        int ord = termsIndex.getOrd(doc);
                        if (ord == 0) {
                            this.mval.value = def;
                            this.mval.exists = false;
                        } else {
                            this.mval.value = NumberUtils.SortableStr2int(termsIndex.lookup(ord, spare), 0, 3);
                            this.mval.exists = true;
                        }
                    }
                };
            }
        };
    }

    @Override
    public boolean equals(Object o) {
        return o instanceof SortableIntFieldSource && super.equals(o) && this.defVal == ((SortableIntFieldSource)o).defVal;
    }

    @Override
    public int hashCode() {
        return hcode + super.hashCode() + this.defVal;
    }
}

