/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.request;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EnumSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.lucene.index.AtomicReader;
import org.apache.lucene.index.DocsEnum;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.MultiDocsEnum;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.FieldCache;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TermRangeQuery;
import org.apache.lucene.search.grouping.AbstractAllGroupHeadsCollector;
import org.apache.lucene.search.grouping.AbstractGroupFacetCollector;
import org.apache.lucene.search.grouping.term.TermAllGroupsCollector;
import org.apache.lucene.search.grouping.term.TermGroupFacetCollector;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.CharsRef;
import org.apache.lucene.util.FixedBitSet;
import org.apache.lucene.util.OpenBitSet;
import org.apache.lucene.util.StringHelper;
import org.apache.lucene.util.UnicodeUtil;
import org.apache.lucene.util.packed.PackedInts;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.FacetParams;
import org.apache.solr.common.params.RequiredSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.handler.component.ResponseBuilder;
import org.apache.solr.request.PerSegmentSingleValuedFaceting;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.request.UnInvertedField;
import org.apache.solr.schema.BoolField;
import org.apache.solr.schema.DateField;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.schema.SortableDoubleField;
import org.apache.solr.schema.SortableFloatField;
import org.apache.solr.schema.SortableIntField;
import org.apache.solr.schema.SortableLongField;
import org.apache.solr.schema.TrieField;
import org.apache.solr.search.BitDocSet;
import org.apache.solr.search.DocIterator;
import org.apache.solr.search.DocSet;
import org.apache.solr.search.Grouping;
import org.apache.solr.search.HashDocSet;
import org.apache.solr.search.QParser;
import org.apache.solr.search.QueryParsing;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.search.SortedIntDocSet;
import org.apache.solr.search.grouping.GroupingSpecification;
import org.apache.solr.util.BoundedTreeSet;
import org.apache.solr.util.DateMathParser;
import org.apache.solr.util.DefaultSolrThreadFactory;
import org.apache.solr.util.LongPriorityQueue;

public class SimpleFacets {
    protected DocSet docs;
    protected SolrParams params;
    protected SolrParams required;
    protected SolrIndexSearcher searcher;
    protected SolrQueryRequest req;
    protected ResponseBuilder rb;
    protected SimpleOrderedMap<Object> facetResponse;
    SolrParams localParams;
    String facetValue;
    DocSet base;
    String key;
    int threads;
    static final Executor directExecutor = new Executor(){

        @Override
        public void execute(Runnable r) {
            r.run();
        }
    };
    static final Executor facetExecutor = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 10L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new DefaultSolrThreadFactory("facetExectutor"));

    public SimpleFacets(SolrQueryRequest req, DocSet docs, SolrParams params) {
        this(req, docs, params, null);
    }

    public SimpleFacets(SolrQueryRequest req, DocSet docs, SolrParams params, ResponseBuilder rb) {
        this.req = req;
        this.searcher = req.getSearcher();
        this.base = this.docs = docs;
        this.params = params;
        this.required = new RequiredSolrParams(params);
        this.rb = rb;
    }

    void parseParams(String type, String param) throws ParseException, IOException {
        String excludeStr;
        this.localParams = QueryParsing.getLocalParams(param, this.req.getParams());
        this.base = this.docs;
        this.facetValue = param;
        this.key = param;
        this.threads = -1;
        if (this.localParams == null) {
            return;
        }
        if (type != "facet.query") {
            this.facetValue = this.localParams.get("v");
        }
        this.key = this.facetValue;
        this.key = this.localParams.get("key", this.key);
        String threadStr = this.localParams.get("threads");
        if (threadStr != null) {
            this.threads = Integer.parseInt(threadStr);
        }
        if ((excludeStr = this.localParams.get("ex")) == null) {
            return;
        }
        Map tagMap = (Map)this.req.getContext().get("tags");
        if (tagMap != null && this.rb != null) {
            List<String> excludeTagList = StrUtils.splitSmart(excludeStr, ',');
            IdentityHashMap<Query, Boolean> excludeSet = new IdentityHashMap<Query, Boolean>();
            for (String excludeTag : excludeTagList) {
                Object olst = tagMap.get(excludeTag);
                if (!(olst instanceof Collection)) continue;
                for (Object o : (Collection)olst) {
                    if (!(o instanceof QParser)) continue;
                    QParser qp = (QParser)o;
                    excludeSet.put(qp.getQuery(), Boolean.TRUE);
                }
            }
            if (excludeSet.size() == 0) {
                return;
            }
            ArrayList<Query> qlist = new ArrayList<Query>();
            if (!excludeSet.containsKey(this.rb.getQuery())) {
                qlist.add(this.rb.getQuery());
            }
            if (this.rb.getFilters() != null) {
                for (Query q : this.rb.getFilters()) {
                    if (excludeSet.containsKey(q)) continue;
                    qlist.add(q);
                }
            }
            DocSet base = this.searcher.getDocSet(qlist);
            if (this.rb.grouping() && this.rb.getGroupingSpec().isTruncateGroups()) {
                Grouping grouping = new Grouping(this.searcher, null, this.rb.getQueryCommand(), false, 0, false);
                if (this.rb.getGroupingSpec().getFields().length > 0) {
                    grouping.addFieldCommand(this.rb.getGroupingSpec().getFields()[0], this.req);
                } else if (this.rb.getGroupingSpec().getFunctions().length > 0) {
                    grouping.addFunctionCommand(this.rb.getGroupingSpec().getFunctions()[0], this.req);
                } else {
                    this.base = base;
                    return;
                }
                AbstractAllGroupHeadsCollector<?> allGroupHeadsCollector = grouping.getCommands().get(0).createAllGroupCollector();
                this.searcher.search((Query)new MatchAllDocsQuery(), base.getTopFilter(), (Collector)allGroupHeadsCollector);
                int maxDoc = this.searcher.maxDoc();
                FixedBitSet fixedBitSet = allGroupHeadsCollector.retrieveGroupHeads(maxDoc);
                long[] bits = fixedBitSet.getBits();
                this.base = new BitDocSet(new OpenBitSet(bits, bits.length));
            } else {
                this.base = base;
            }
        }
    }

    public NamedList<Object> getFacetCounts() {
        if (!this.params.getBool("facet", true)) {
            return null;
        }
        this.facetResponse = new SimpleOrderedMap();
        try {
            this.facetResponse.add("facet_queries", this.getFacetQueryCounts());
            this.facetResponse.add("facet_fields", this.getFacetFieldCounts());
            this.facetResponse.add("facet_dates", this.getFacetDateCounts());
            this.facetResponse.add("facet_ranges", this.getFacetRangeCounts());
        }
        catch (IOException e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
        }
        catch (ParseException e) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, (Throwable)e);
        }
        return this.facetResponse;
    }

    public NamedList<Integer> getFacetQueryCounts() throws IOException, ParseException {
        SimpleOrderedMap<Integer> res = new SimpleOrderedMap<Integer>();
        String[] facetQs = this.params.getParams("facet.query");
        if (null != facetQs && 0 != facetQs.length) {
            for (String q : facetQs) {
                this.parseParams("facet.query", q);
                Query qobj = QParser.getParser(q, null, this.req).getQuery();
                if (this.params.getBool("group.facet", false)) {
                    res.add(this.key, this.getGroupedFacetQueryCount(qobj));
                    continue;
                }
                res.add(this.key, this.searcher.numDocs(qobj, this.base));
            }
        }
        return res;
    }

    public int getGroupedFacetQueryCount(Query facetQuery) throws IOException {
        String groupField;
        GroupingSpecification groupingSpecification = this.rb.getGroupingSpec();
        String string = groupField = groupingSpecification != null ? groupingSpecification.getFields()[0] : null;
        if (groupField == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Specify the group.field as parameter or local parameter");
        }
        TermAllGroupsCollector collector = new TermAllGroupsCollector(groupField);
        Filter mainQueryFilter = this.docs.getTopFilter();
        this.searcher.search(facetQuery, mainQueryFilter, (Collector)collector);
        return collector.getGroupCount();
    }

    public NamedList<Integer> getTermCounts(String field) throws IOException {
        NamedList<Integer> counts;
        boolean multiToken;
        int offset = this.params.getFieldInt(field, "facet.offset", 0);
        int limit = this.params.getFieldInt(field, "facet.limit", 100);
        if (limit == 0) {
            return new NamedList<Integer>();
        }
        Integer mincount = this.params.getFieldInt(field, "facet.mincount");
        if (mincount == null) {
            Boolean zeros = this.params.getFieldBool(field, "facet.zeros");
            mincount = zeros != null && zeros == false ? 1 : 0;
        }
        boolean missing = this.params.getFieldBool(field, "facet.missing", false);
        String sort = this.params.getFieldParam(field, "facet.sort", limit > 0 ? "count" : "index");
        String prefix = this.params.getFieldParam(field, "facet.prefix");
        SchemaField sf = this.searcher.getSchema().getField(field);
        FieldType ft = sf.getType();
        String method = this.params.getFieldParam(field, "facet.method");
        boolean enumMethod = "enum".equals(method);
        boolean per_segment = "fcs".equals(method);
        if (method == null && ft instanceof BoolField) {
            enumMethod = true;
        }
        boolean bl = multiToken = sf.multiValued() || ft.multiValuedFieldCache();
        if (TrieField.getMainValuePrefix(ft) != null) {
            enumMethod = false;
            multiToken = true;
        }
        if (this.params.getFieldBool(field, "group.facet", false)) {
            counts = this.getGroupedCounts(this.searcher, this.base, field, multiToken, offset, limit, mincount, missing, sort, prefix);
        } else if (enumMethod) {
            counts = this.getFacetTermEnumCounts(this.searcher, this.base, field, offset, limit, mincount, missing, sort, prefix);
        } else if (multiToken) {
            UnInvertedField uif = UnInvertedField.getUnInvertedField(field, this.searcher);
            counts = uif.getCounts(this.searcher, this.base, offset, limit, mincount, missing, sort, prefix);
        } else if (per_segment) {
            PerSegmentSingleValuedFaceting ps = new PerSegmentSingleValuedFaceting(this.searcher, this.base, field, offset, limit, mincount, missing, sort, prefix);
            Executor executor = this.threads == 0 ? directExecutor : facetExecutor;
            ps.setNumThreads(this.threads);
            counts = ps.getFacetCounts(executor);
        } else {
            counts = SimpleFacets.getFieldCacheCounts(this.searcher, this.base, field, offset, limit, mincount, missing, sort, prefix);
        }
        return counts;
    }

    public NamedList<Integer> getGroupedCounts(SolrIndexSearcher searcher, DocSet base, String field, boolean multiToken, int offset, int limit, int mincount, boolean missing, String sort, String prefix) throws IOException {
        String groupField;
        GroupingSpecification groupingSpecification = this.rb.getGroupingSpec();
        String string = groupField = groupingSpecification != null ? groupingSpecification.getFields()[0] : null;
        if (groupField == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Specify the group.field as parameter or local parameter");
        }
        BytesRef prefixBR = prefix != null ? new BytesRef(prefix) : null;
        TermGroupFacetCollector collector = TermGroupFacetCollector.createTermGroupFacetCollector((String)groupField, (String)field, (boolean)multiToken, (BytesRef)prefixBR, (int)128);
        searcher.search((Query)new MatchAllDocsQuery(), base.getTopFilter(), (Collector)collector);
        boolean orderByCount = sort.equals("count") || sort.equals("true");
        AbstractGroupFacetCollector.GroupedFacetResult result = collector.mergeSegmentResults(offset + limit, mincount, orderByCount);
        CharsRef charsRef = new CharsRef();
        FieldType facetFieldType = searcher.getSchema().getFieldType(field);
        NamedList<Integer> facetCounts = new NamedList<Integer>();
        List scopedEntries = result.getFacetEntries(offset, limit);
        for (AbstractGroupFacetCollector.FacetEntry facetEntry : scopedEntries) {
            facetFieldType.indexedToReadable(facetEntry.getValue(), charsRef);
            facetCounts.add(charsRef.toString(), facetEntry.getCount());
        }
        if (missing) {
            facetCounts.add(null, result.getTotalMissingCount());
        }
        return facetCounts;
    }

    public NamedList<Object> getFacetFieldCounts() throws IOException, ParseException {
        SimpleOrderedMap<Object> res = new SimpleOrderedMap<Object>();
        String[] facetFs = this.params.getParams("facet.field");
        if (null != facetFs) {
            for (String f : facetFs) {
                String termList;
                this.parseParams("facet.field", f);
                String string = termList = this.localParams == null ? null : this.localParams.get("terms");
                if (termList != null) {
                    res.add(this.key, this.getListedTermCounts(this.facetValue, termList));
                    continue;
                }
                res.add(this.key, this.getTermCounts(this.facetValue));
            }
        }
        return res;
    }

    private NamedList<Integer> getListedTermCounts(String field, String termList) throws IOException {
        FieldType ft = this.searcher.getSchema().getFieldType(field);
        List<String> terms = StrUtils.splitSmart(termList, ",", true);
        NamedList<Integer> res = new NamedList<Integer>();
        for (String term : terms) {
            String internal = ft.toInternal(term);
            int count = this.searcher.numDocs((Query)new TermQuery(new Term(field, internal)), this.base);
            res.add(term, count);
        }
        return res;
    }

    public static int getFieldMissingCount(SolrIndexSearcher searcher, DocSet docs, String fieldName) throws IOException {
        DocSet hasVal = searcher.getDocSet(new TermRangeQuery(fieldName, null, null, false, false));
        return docs.andNotSize(hasVal);
    }

    public static NamedList<Integer> getFieldCacheCounts(SolrIndexSearcher searcher, DocSet docs, String fieldName, int offset, int limit, int mincount, boolean missing, String sort, String prefix) throws IOException {
        int endTermIndex;
        int startTermIndex;
        BytesRef prefixRef;
        FieldType ft = searcher.getSchema().getFieldType(fieldName);
        NamedList<Integer> res = new NamedList<Integer>();
        FieldCache.DocTermsIndex si = FieldCache.DEFAULT.getTermsIndex(searcher.getAtomicReader(), fieldName);
        if (prefix == null) {
            prefixRef = null;
        } else if (prefix.length() == 0) {
            prefix = null;
            prefixRef = null;
        } else {
            prefixRef = new BytesRef(prefix);
        }
        BytesRef br = new BytesRef();
        if (prefix != null) {
            startTermIndex = si.binarySearchLookup(prefixRef, br);
            if (startTermIndex < 0) {
                startTermIndex = -startTermIndex - 1;
            }
            prefixRef.append(UnicodeUtil.BIG_TERM);
            endTermIndex = si.binarySearchLookup(prefixRef, br);
            assert (endTermIndex < 0);
            endTermIndex = -endTermIndex - 1;
        } else {
            startTermIndex = 0;
            endTermIndex = si.numOrd();
        }
        int nTerms = endTermIndex - startTermIndex;
        int missingCount = -1;
        CharsRef charsRef = new CharsRef(10);
        if (nTerms > 0 && docs.size() >= mincount) {
            int lim;
            int arrIdx;
            int term;
            int[] counts = new int[nTerms];
            DocIterator iter = docs.iterator();
            PackedInts.Reader ordReader = si.getDocToOrd();
            Object arr = ordReader.hasArray() ? ordReader.getArray() : null;
            if (arr instanceof int[]) {
                int[] ords = (int[])arr;
                if (prefix == null) {
                    while (iter.hasNext()) {
                        int n = ords[iter.nextDoc()];
                        counts[n] = counts[n] + 1;
                    }
                } else {
                    while (iter.hasNext()) {
                        term = ords[iter.nextDoc()];
                        arrIdx = term - startTermIndex;
                        if (arrIdx < 0 || arrIdx >= nTerms) continue;
                        int n = arrIdx;
                        counts[n] = counts[n] + 1;
                    }
                }
            } else if (arr instanceof short[]) {
                short[] ords = (short[])arr;
                if (prefix == null) {
                    while (iter.hasNext()) {
                        int n = ords[iter.nextDoc()] & 0xFFFF;
                        counts[n] = counts[n] + 1;
                    }
                } else {
                    while (iter.hasNext()) {
                        term = ords[iter.nextDoc()] & 0xFFFF;
                        arrIdx = term - startTermIndex;
                        if (arrIdx < 0 || arrIdx >= nTerms) continue;
                        int n = arrIdx;
                        counts[n] = counts[n] + 1;
                    }
                }
            } else if (arr instanceof byte[]) {
                byte[] ords = (byte[])arr;
                if (prefix == null) {
                    while (iter.hasNext()) {
                        int n = ords[iter.nextDoc()] & 0xFF;
                        counts[n] = counts[n] + 1;
                    }
                } else {
                    while (iter.hasNext()) {
                        term = ords[iter.nextDoc()] & 0xFF;
                        arrIdx = term - startTermIndex;
                        if (arrIdx < 0 || arrIdx >= nTerms) continue;
                        int n = arrIdx;
                        counts[n] = counts[n] + 1;
                    }
                }
            } else {
                while (iter.hasNext()) {
                    int term2 = si.getOrd(iter.nextDoc());
                    int arrIdx2 = term2 - startTermIndex;
                    if (arrIdx2 < 0 || arrIdx2 >= nTerms) continue;
                    int n = arrIdx2;
                    counts[n] = counts[n] + 1;
                }
            }
            if (startTermIndex == 0) {
                missingCount = counts[0];
            }
            int off = offset;
            int n = lim = limit >= 0 ? limit : Integer.MAX_VALUE;
            if (sort.equals("count") || sort.equals("true")) {
                int i;
                int maxsize = limit > 0 ? offset + limit : 0x7FFFFFFE;
                maxsize = Math.min(maxsize, nTerms);
                LongPriorityQueue queue = new LongPriorityQueue(Math.min(maxsize, 1000), maxsize, Long.MIN_VALUE);
                int min = mincount - 1;
                int n2 = i = startTermIndex == 0 ? 1 : 0;
                while (i < nTerms) {
                    long pair;
                    boolean displaced;
                    int c = counts[i];
                    if (c > min && (displaced = queue.insert(pair = ((long)c << 32) + (long)(Integer.MAX_VALUE - i)))) {
                        min = (int)(queue.top() >>> 32);
                    }
                    ++i;
                }
                int collectCount = Math.max(0, queue.size() - off);
                assert (collectCount <= lim);
                int sortedIdxStart = queue.size() - (collectCount - 1);
                int sortedIdxEnd = queue.size() + 1;
                long[] sorted = queue.sort(collectCount);
                for (int i2 = sortedIdxStart; i2 < sortedIdxEnd; ++i2) {
                    long pair = sorted[i2];
                    int c = (int)(pair >>> 32);
                    int tnum = Integer.MAX_VALUE - (int)pair;
                    ft.indexedToReadable(si.lookup(startTermIndex + tnum, br), charsRef);
                    res.add(charsRef.toString(), c);
                }
            } else {
                int i;
                int n3 = i = startTermIndex == 0 ? 1 : 0;
                if (mincount <= 0) {
                    i += off;
                    off = 0;
                }
                while (i < nTerms) {
                    int c = counts[i];
                    if (c >= mincount && --off < 0) {
                        if (--lim < 0) break;
                        ft.indexedToReadable(si.lookup(startTermIndex + i, br), charsRef);
                        res.add(charsRef.toString(), c);
                    }
                    ++i;
                }
            }
        }
        if (missing) {
            if (missingCount < 0) {
                missingCount = SimpleFacets.getFieldMissingCount(searcher, docs, fieldName);
            }
            res.add(null, missingCount);
        }
        return res;
    }

    public NamedList<Integer> getFacetTermEnumCounts(SolrIndexSearcher searcher, DocSet docs, String field, int offset, int limit, int mincount, boolean missing, String sort, String prefix) throws IOException {
        Fields fields;
        int minDfFilterCache = this.params.getFieldInt(field, "facet.enum.cache.minDf", 0);
        DocSet fastForRandomSet = docs;
        if (minDfFilterCache > 0 && docs instanceof SortedIntDocSet) {
            SortedIntDocSet sset = (SortedIntDocSet)docs;
            fastForRandomSet = new HashDocSet(sset.getDocs(), 0, sset.size());
        }
        IndexSchema schema = searcher.getSchema();
        AtomicReader r = searcher.getAtomicReader();
        FieldType ft = schema.getFieldType(field);
        boolean sortByCount = sort.equals("count") || sort.equals("true");
        int maxsize = limit >= 0 ? offset + limit : 0x7FFFFFFE;
        BoundedTreeSet<CountPair<BytesRef, Integer>> queue = sortByCount ? new BoundedTreeSet<CountPair<BytesRef, Integer>>(maxsize) : null;
        NamedList<Integer> res = new NamedList<Integer>();
        int min = mincount - 1;
        int off = offset;
        int lim = limit >= 0 ? limit : Integer.MAX_VALUE;
        BytesRef startTermBytes = null;
        if (prefix != null) {
            String indexedPrefix = ft.toInternal(prefix);
            startTermBytes = new BytesRef(indexedPrefix);
        }
        Terms terms = (fields = r.fields()) == null ? null : fields.terms(field);
        TermsEnum termsEnum = null;
        SolrIndexSearcher.DocsEnumState deState = null;
        BytesRef term = null;
        if (terms != null) {
            termsEnum = terms.iterator(null);
            if (startTermBytes != null) {
                if (termsEnum.seekCeil(startTermBytes, true) == TermsEnum.SeekStatus.END) {
                    termsEnum = null;
                } else {
                    term = termsEnum.term();
                }
            } else {
                term = termsEnum.next();
            }
        }
        DocsEnum docsEnum = null;
        CharsRef charsRef = new CharsRef(10);
        if (docs.size() >= mincount) {
            while (term != null && (startTermBytes == null || StringHelper.startsWith(term, startTermBytes))) {
                int df = termsEnum.docFreq();
                if (df > 0 && df > min) {
                    int n;
                    if (df >= minDfFilterCache) {
                        if (deState == null) {
                            deState = new SolrIndexSearcher.DocsEnumState();
                            deState.fieldName = field;
                            deState.liveDocs = r.getLiveDocs();
                            deState.termsEnum = termsEnum;
                            deState.docsEnum = docsEnum;
                        }
                        n = searcher.numDocs(docs, deState);
                        docsEnum = deState.docsEnum;
                    } else {
                        docsEnum = termsEnum.docs(null, docsEnum, false);
                        n = 0;
                        if (docsEnum instanceof MultiDocsEnum) {
                            MultiDocsEnum.EnumWithSlice[] subs = ((MultiDocsEnum)docsEnum).getSubs();
                            int numSubs = ((MultiDocsEnum)docsEnum).getNumSubs();
                            for (int subindex = 0; subindex < numSubs; ++subindex) {
                                int docid;
                                MultiDocsEnum.EnumWithSlice sub = subs[subindex];
                                if (sub.docsEnum == null) continue;
                                int base = sub.slice.start;
                                while ((docid = sub.docsEnum.nextDoc()) != Integer.MAX_VALUE) {
                                    if (!fastForRandomSet.exists(docid + base)) continue;
                                    ++n;
                                }
                            }
                        } else {
                            int docid;
                            while ((docid = docsEnum.nextDoc()) != Integer.MAX_VALUE) {
                                if (!fastForRandomSet.exists(docid)) continue;
                                ++n;
                            }
                        }
                    }
                    if (sortByCount) {
                        if (n > min) {
                            BytesRef termCopy = BytesRef.deepCopyOf(term);
                            queue.add(new CountPair<BytesRef, Integer>(termCopy, n));
                            if (queue.size() >= maxsize) {
                                min = (Integer)((CountPair)queue.last()).val;
                            }
                        }
                    } else if (n >= mincount && --off < 0) {
                        if (--lim < 0) break;
                        ft.indexedToReadable(term, charsRef);
                        res.add(charsRef.toString(), n);
                    }
                }
                term = termsEnum.next();
            }
        }
        if (sortByCount) {
            for (CountPair countPair : queue) {
                if (--off >= 0) continue;
                if (--lim < 0) break;
                ft.indexedToReadable((BytesRef)countPair.key, charsRef);
                res.add(charsRef.toString(), (Integer)countPair.val);
            }
        }
        if (missing) {
            res.add(null, SimpleFacets.getFieldMissingCount(searcher, docs, field));
        }
        return res;
    }

    @Deprecated
    public NamedList<Object> getFacetDateCounts() throws IOException, ParseException {
        SimpleOrderedMap<Object> resOuter = new SimpleOrderedMap<Object>();
        String[] fields = this.params.getParams("facet.date");
        if (null == fields || 0 == fields.length) {
            return resOuter;
        }
        for (String f : fields) {
            this.getFacetDateCounts(f, resOuter);
        }
        return resOuter;
    }

    @Deprecated
    public void getFacetDateCounts(String dateFacet, NamedList<Object> resOuter) throws IOException, ParseException {
        Date end;
        Date start;
        IndexSchema schema = this.searcher.getSchema();
        this.parseParams("facet.date", dateFacet);
        String f = this.facetValue;
        SimpleOrderedMap<Object> resInner = new SimpleOrderedMap<Object>();
        resOuter.add(this.key, resInner);
        SchemaField sf = schema.getField(f);
        if (!(sf.getType() instanceof DateField)) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Can not date facet on a field which is not a DateField: " + f);
        }
        DateField ft = (DateField)sf.getType();
        String startS = this.required.getFieldParam(f, "facet.date.start");
        try {
            start = ft.parseMath(null, startS);
        }
        catch (SolrException e) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "date facet 'start' is not a valid Date string: " + startS, e);
        }
        String endS = this.required.getFieldParam(f, "facet.date.end");
        try {
            end = ft.parseMath(null, endS);
        }
        catch (SolrException e) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "date facet 'end' is not a valid Date string: " + endS, e);
        }
        if (end.before(start)) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "date facet 'end' comes before 'start': " + endS + " < " + startS);
        }
        String gap = this.required.getFieldParam(f, "facet.date.gap");
        DateMathParser dmp = new DateMathParser();
        int minCount = this.params.getFieldInt(f, "facet.mincount", 0);
        String[] iStrs = this.params.getFieldParams(f, "facet.date.include");
        EnumSet<FacetParams.FacetRangeInclude> include = null == iStrs || 0 == iStrs.length ? EnumSet.of(FacetParams.FacetRangeInclude.LOWER, FacetParams.FacetRangeInclude.UPPER, FacetParams.FacetRangeInclude.EDGE) : FacetParams.FacetRangeInclude.parseParam(iStrs);
        try {
            Date low = start;
            while (low.before(end)) {
                boolean includeUpper;
                dmp.setNow(low);
                String label = ft.toExternal(low);
                Date high = dmp.parseMath(gap);
                if (end.before(high)) {
                    if (this.params.getFieldBool(f, "facet.date.hardend", false)) {
                        high = end;
                    } else {
                        end = high;
                    }
                }
                if (high.before(low)) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "date facet infinite loop (is gap negative?)");
                }
                boolean includeLower = include.contains((Object)FacetParams.FacetRangeInclude.LOWER) || include.contains((Object)FacetParams.FacetRangeInclude.EDGE) && low.equals(start);
                int count = this.rangeCount(sf, low, high, includeLower, includeUpper = include.contains((Object)FacetParams.FacetRangeInclude.UPPER) || include.contains((Object)FacetParams.FacetRangeInclude.EDGE) && high.equals(end));
                if (count >= minCount) {
                    resInner.add(label, count);
                }
                low = high;
            }
        }
        catch (java.text.ParseException e) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "date facet 'gap' is not a valid Date Math string: " + gap, e);
        }
        resInner.add("gap", gap);
        resInner.add("start", start);
        resInner.add("end", end);
        String[] othersP = this.params.getFieldParams(f, "facet.date.other");
        if (null != othersP && 0 < othersP.length) {
            EnumSet<FacetParams.FacetRangeOther> others = EnumSet.noneOf(FacetParams.FacetRangeOther.class);
            for (String o : othersP) {
                others.add(FacetParams.FacetRangeOther.get(o));
            }
            if (!others.contains((Object)FacetParams.FacetRangeOther.NONE)) {
                boolean all = others.contains((Object)FacetParams.FacetRangeOther.ALL);
                if (all || others.contains((Object)FacetParams.FacetRangeOther.BEFORE)) {
                    resInner.add(FacetParams.FacetRangeOther.BEFORE.toString(), this.rangeCount(sf, null, start, false, include.contains((Object)FacetParams.FacetRangeInclude.OUTER) || !include.contains((Object)FacetParams.FacetRangeInclude.LOWER) && !include.contains((Object)FacetParams.FacetRangeInclude.EDGE)));
                }
                if (all || others.contains((Object)FacetParams.FacetRangeOther.AFTER)) {
                    resInner.add(FacetParams.FacetRangeOther.AFTER.toString(), this.rangeCount(sf, end, null, include.contains((Object)FacetParams.FacetRangeInclude.OUTER) || !include.contains((Object)FacetParams.FacetRangeInclude.UPPER) && !include.contains((Object)FacetParams.FacetRangeInclude.EDGE), false));
                }
                if (all || others.contains((Object)FacetParams.FacetRangeOther.BETWEEN)) {
                    resInner.add(FacetParams.FacetRangeOther.BETWEEN.toString(), this.rangeCount(sf, start, end, include.contains((Object)FacetParams.FacetRangeInclude.LOWER) || include.contains((Object)FacetParams.FacetRangeInclude.EDGE), include.contains((Object)FacetParams.FacetRangeInclude.UPPER) || include.contains((Object)FacetParams.FacetRangeInclude.EDGE)));
                }
            }
        }
    }

    public NamedList<Object> getFacetRangeCounts() throws IOException, ParseException {
        SimpleOrderedMap<Object> resOuter = new SimpleOrderedMap<Object>();
        String[] fields = this.params.getParams("facet.range");
        if (null == fields || 0 == fields.length) {
            return resOuter;
        }
        for (String f : fields) {
            this.getFacetRangeCounts(f, resOuter);
        }
        return resOuter;
    }

    void getFacetRangeCounts(String facetRange, NamedList<Object> resOuter) throws IOException, ParseException {
        IndexSchema schema = this.searcher.getSchema();
        this.parseParams("facet.range", facetRange);
        String f = this.facetValue;
        SchemaField sf = schema.getField(f);
        FieldType ft = sf.getType();
        RangeEndpointCalculator calc = null;
        if (ft instanceof TrieField) {
            TrieField trie = (TrieField)ft;
            switch (trie.getType()) {
                case FLOAT: {
                    calc = new FloatRangeEndpointCalculator(sf);
                    break;
                }
                case DOUBLE: {
                    calc = new DoubleRangeEndpointCalculator(sf);
                    break;
                }
                case INTEGER: {
                    calc = new IntegerRangeEndpointCalculator(sf);
                    break;
                }
                case LONG: {
                    calc = new LongRangeEndpointCalculator(sf);
                    break;
                }
                default: {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unable to range facet on tried field of unexpected type:" + f);
                }
            }
        } else if (ft instanceof DateField) {
            calc = new DateRangeEndpointCalculator(sf, null);
        } else if (ft instanceof SortableIntField) {
            calc = new IntegerRangeEndpointCalculator(sf);
        } else if (ft instanceof SortableLongField) {
            calc = new LongRangeEndpointCalculator(sf);
        } else if (ft instanceof SortableFloatField) {
            calc = new FloatRangeEndpointCalculator(sf);
        } else if (ft instanceof SortableDoubleField) {
            calc = new DoubleRangeEndpointCalculator(sf);
        } else {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unable to range facet on field:" + sf);
        }
        resOuter.add(this.key, this.getFacetRangeCounts(sf, calc));
    }

    private <T extends Comparable<T>> NamedList getFacetRangeCounts(SchemaField sf, RangeEndpointCalculator<T> calc) throws IOException {
        String f = sf.getName();
        SimpleOrderedMap<Object> res = new SimpleOrderedMap<Object>();
        NamedList<Integer> counts = new NamedList<Integer>();
        res.add("counts", counts);
        T start = calc.getValue(this.required.getFieldParam(f, "facet.range.start"));
        T end = calc.getValue(this.required.getFieldParam(f, "facet.range.end"));
        if (end.compareTo(start) < 0) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "range facet 'end' comes before 'start': " + end + " < " + start);
        }
        String gap = this.required.getFieldParam(f, "facet.range.gap");
        res.add("gap", calc.getGap(gap));
        int minCount = this.params.getFieldInt(f, "facet.mincount", 0);
        EnumSet<FacetParams.FacetRangeInclude> include = FacetParams.FacetRangeInclude.parseParam(this.params.getFieldParams(f, "facet.range.include"));
        T low = start;
        while (low.compareTo(end) < 0) {
            String highS;
            T high = calc.addGap(low, gap);
            if (end.compareTo(high) < 0) {
                if (this.params.getFieldBool(f, "facet.range.hardend", false)) {
                    high = end;
                } else {
                    end = high;
                }
            }
            if (high.compareTo(low) < 0) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "range facet infinite loop (is gap negative? did the math overflow?)");
            }
            boolean includeLower = include.contains((Object)FacetParams.FacetRangeInclude.LOWER) || include.contains((Object)FacetParams.FacetRangeInclude.EDGE) && 0 == low.compareTo(start);
            boolean includeUpper = include.contains((Object)FacetParams.FacetRangeInclude.UPPER) || include.contains((Object)FacetParams.FacetRangeInclude.EDGE) && 0 == high.compareTo(end);
            String lowS = calc.formatValue(low);
            int count = this.rangeCount(sf, lowS, highS = calc.formatValue(high), includeLower, includeUpper);
            if (count >= minCount) {
                counts.add(lowS, count);
            }
            low = high;
        }
        res.add("start", start);
        res.add("end", end);
        String[] othersP = this.params.getFieldParams(f, "facet.range.other");
        if (null != othersP && 0 < othersP.length) {
            EnumSet<FacetParams.FacetRangeOther> others = EnumSet.noneOf(FacetParams.FacetRangeOther.class);
            for (String o : othersP) {
                others.add(FacetParams.FacetRangeOther.get(o));
            }
            if (!others.contains((Object)FacetParams.FacetRangeOther.NONE)) {
                boolean all = others.contains((Object)FacetParams.FacetRangeOther.ALL);
                String startS = calc.formatValue(start);
                String endS = calc.formatValue(end);
                if (all || others.contains((Object)FacetParams.FacetRangeOther.BEFORE)) {
                    res.add(FacetParams.FacetRangeOther.BEFORE.toString(), this.rangeCount(sf, null, startS, false, include.contains((Object)FacetParams.FacetRangeInclude.OUTER) || !include.contains((Object)FacetParams.FacetRangeInclude.LOWER) && !include.contains((Object)FacetParams.FacetRangeInclude.EDGE)));
                }
                if (all || others.contains((Object)FacetParams.FacetRangeOther.AFTER)) {
                    res.add(FacetParams.FacetRangeOther.AFTER.toString(), this.rangeCount(sf, endS, null, include.contains((Object)FacetParams.FacetRangeInclude.OUTER) || !include.contains((Object)FacetParams.FacetRangeInclude.UPPER) && !include.contains((Object)FacetParams.FacetRangeInclude.EDGE), false));
                }
                if (all || others.contains((Object)FacetParams.FacetRangeOther.BETWEEN)) {
                    res.add(FacetParams.FacetRangeOther.BETWEEN.toString(), this.rangeCount(sf, startS, endS, include.contains((Object)FacetParams.FacetRangeInclude.LOWER) || include.contains((Object)FacetParams.FacetRangeInclude.EDGE), include.contains((Object)FacetParams.FacetRangeInclude.UPPER) || include.contains((Object)FacetParams.FacetRangeInclude.EDGE)));
                }
            }
        }
        return res;
    }

    protected int rangeCount(SchemaField sf, String low, String high, boolean iLow, boolean iHigh) throws IOException {
        Query rangeQ = sf.getType().getRangeQuery(null, sf, low, high, iLow, iHigh);
        if (this.params.getBool("group.facet", false)) {
            return this.getGroupedFacetQueryCount(rangeQ);
        }
        return this.searcher.numDocs(rangeQ, this.base);
    }

    @Deprecated
    protected int rangeCount(SchemaField sf, Date low, Date high, boolean iLow, boolean iHigh) throws IOException {
        Query rangeQ = ((DateField)sf.getType()).getRangeQuery(null, sf, low, high, iLow, iHigh);
        return this.searcher.numDocs(rangeQ, this.base);
    }

    private static class DateRangeEndpointCalculator
    extends RangeEndpointCalculator<Date> {
        private final Date now;

        public DateRangeEndpointCalculator(SchemaField f, Date now) {
            super(f);
            this.now = now;
            if (!(this.field.getType() instanceof DateField)) {
                throw new IllegalArgumentException("SchemaField must use filed type extending DateField");
            }
        }

        @Override
        public String formatValue(Date val) {
            return ((DateField)this.field.getType()).toExternal(val);
        }

        @Override
        protected Date parseVal(String rawval) {
            return ((DateField)this.field.getType()).parseMath(this.now, rawval);
        }

        @Override
        protected Object parseGap(String rawval) {
            return rawval;
        }

        @Override
        public Date parseAndAddGap(Date value, String gap) throws java.text.ParseException {
            DateMathParser dmp = new DateMathParser();
            dmp.setNow(value);
            return dmp.parseMath(gap);
        }
    }

    private static class LongRangeEndpointCalculator
    extends RangeEndpointCalculator<Long> {
        public LongRangeEndpointCalculator(SchemaField f) {
            super(f);
        }

        @Override
        protected Long parseVal(String rawval) {
            return Long.valueOf(rawval);
        }

        @Override
        public Long parseAndAddGap(Long value, String gap) {
            return new Long(value + Long.valueOf(gap));
        }
    }

    private static class IntegerRangeEndpointCalculator
    extends RangeEndpointCalculator<Integer> {
        public IntegerRangeEndpointCalculator(SchemaField f) {
            super(f);
        }

        @Override
        protected Integer parseVal(String rawval) {
            return Integer.valueOf(rawval);
        }

        @Override
        public Integer parseAndAddGap(Integer value, String gap) {
            return new Integer(value + Integer.valueOf(gap));
        }
    }

    private static class DoubleRangeEndpointCalculator
    extends RangeEndpointCalculator<Double> {
        public DoubleRangeEndpointCalculator(SchemaField f) {
            super(f);
        }

        @Override
        protected Double parseVal(String rawval) {
            return Double.valueOf(rawval);
        }

        @Override
        public Double parseAndAddGap(Double value, String gap) {
            return new Double(value + Double.valueOf(gap));
        }
    }

    private static class FloatRangeEndpointCalculator
    extends RangeEndpointCalculator<Float> {
        public FloatRangeEndpointCalculator(SchemaField f) {
            super(f);
        }

        @Override
        protected Float parseVal(String rawval) {
            return Float.valueOf(rawval);
        }

        @Override
        public Float parseAndAddGap(Float value, String gap) {
            return new Float(value.floatValue() + Float.valueOf(gap).floatValue());
        }
    }

    private static abstract class RangeEndpointCalculator<T extends Comparable<T>> {
        protected final SchemaField field;

        public RangeEndpointCalculator(SchemaField field) {
            this.field = field;
        }

        public String formatValue(T val) {
            return val.toString();
        }

        public final T getValue(String rawval) {
            try {
                return this.parseVal(rawval);
            }
            catch (Exception e) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Can't parse value " + rawval + " for field: " + this.field.getName(), e);
            }
        }

        protected abstract T parseVal(String var1) throws java.text.ParseException;

        public final Object getGap(String gap) {
            try {
                return this.parseGap(gap);
            }
            catch (Exception e) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Can't parse gap " + gap + " for field: " + this.field.getName(), e);
            }
        }

        protected Object parseGap(String rawval) throws java.text.ParseException {
            return this.parseVal(rawval);
        }

        public final T addGap(T value, String gap) {
            try {
                return this.parseAndAddGap(value, gap);
            }
            catch (Exception e) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Can't add gap " + gap + " to value " + value + " for field: " + this.field.getName(), e);
            }
        }

        protected abstract T parseAndAddGap(T var1, String var2) throws java.text.ParseException;
    }

    public static class CountPair<K extends Comparable<? super K>, V extends Comparable<? super V>>
    implements Comparable<CountPair<K, V>> {
        public K key;
        public V val;

        public CountPair(K k, V v) {
            this.key = k;
            this.val = v;
        }

        public int hashCode() {
            return this.key.hashCode() ^ this.val.hashCode();
        }

        public boolean equals(Object o) {
            if (!(o instanceof CountPair)) {
                return false;
            }
            CountPair that = (CountPair)o;
            return this.key.equals(that.key) && this.val.equals(that.val);
        }

        @Override
        public int compareTo(CountPair<K, V> o) {
            int vc = o.val.compareTo(this.val);
            return 0 != vc ? vc : this.key.compareTo(o.key);
        }
    }
}

