/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.highlight;

import java.io.IOException;
import java.util.LinkedList;
import java.util.ListIterator;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.solr.highlight.OrderedToken;

final class TokenOrderingFilter
extends TokenFilter {
    private final int windowSize;
    private final LinkedList<OrderedToken> queue = new LinkedList();
    private boolean done = false;
    private final OffsetAttribute offsetAtt = this.addAttribute(OffsetAttribute.class);

    protected TokenOrderingFilter(TokenStream input, int windowSize) {
        super(input);
        this.windowSize = windowSize;
    }

    @Override
    public boolean incrementToken() throws IOException {
        while (!this.done && this.queue.size() < this.windowSize) {
            if (!this.input.incrementToken()) {
                this.done = true;
                break;
            }
            ListIterator<OrderedToken> iter = this.queue.listIterator(this.queue.size());
            while (iter.hasPrevious()) {
                if (this.offsetAtt.startOffset() < iter.previous().startOffset) continue;
                iter.next();
                break;
            }
            OrderedToken ot = new OrderedToken();
            ot.state = this.captureState();
            ot.startOffset = this.offsetAtt.startOffset();
            iter.add(ot);
        }
        if (this.queue.isEmpty()) {
            return false;
        }
        this.restoreState(this.queue.removeFirst().state);
        return true;
    }
}

