/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.component;

import java.util.Date;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.handler.component.AbstractStatsValues;
import org.apache.solr.schema.SchemaField;

class DateStatsValues
extends AbstractStatsValues<Date> {
    private long sum = -1L;
    double sumOfSquares = 0.0;

    public DateStatsValues(SchemaField sf) {
        super(sf);
    }

    @Override
    protected void updateTypeSpecificStats(NamedList stv) {
        this.sum += ((Date)stv.get("sum")).getTime();
        this.sumOfSquares += ((Number)stv.get("sumOfSquares")).doubleValue();
    }

    @Override
    public void updateTypeSpecificStats(Date v) {
        long value = v.getTime();
        this.sumOfSquares += (double)(value * value);
        this.sum += value;
    }

    @Override
    public void updateTypeSpecificStats(Date v, int count) {
        long value = v.getTime();
        this.sumOfSquares += (double)(value * value * (long)count);
        this.sum += value * (long)count;
    }

    @Override
    protected void updateMinMax(Date min, Date max) {
        if (this.min == null || ((Date)this.min).after(min)) {
            this.min = min;
        }
        if (this.max == null || ((Date)this.max).before(min)) {
            this.max = max;
        }
    }

    @Override
    protected void addTypeSpecificStats(NamedList<Object> res) {
        if (this.sum <= 0L) {
            return;
        }
        res.add("sum", new Date(this.sum));
        if (this.count > 0L) {
            res.add("mean", new Date(this.sum / this.count));
        }
        res.add("sumOfSquares", this.sumOfSquares);
        res.add("stddev", this.getStandardDeviation());
    }

    private double getStandardDeviation() {
        if (this.count <= 1L) {
            return 0.0;
        }
        return Math.sqrt(((double)this.count * this.sumOfSquares - (double)(this.sum * this.sum)) / ((double)this.count * ((double)this.count - 1.0)));
    }
}

