/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.component;

import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.util.BytesRef;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.handler.component.StatsValues;
import org.apache.solr.handler.component.StatsValuesFactory;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.SchemaField;

abstract class AbstractStatsValues<T>
implements StatsValues {
    private static final String FACETS = "facets";
    protected final SchemaField sf;
    protected final FieldType ft;
    protected T max;
    protected T min;
    protected long missing;
    protected long count;
    protected Map<String, Map<String, StatsValues>> facets = new HashMap<String, Map<String, StatsValues>>();

    protected AbstractStatsValues(SchemaField sf) {
        this.sf = sf;
        this.ft = sf.getType();
    }

    @Override
    public void accumulate(NamedList stv) {
        this.count += ((Long)stv.get("count")).longValue();
        this.missing += ((Long)stv.get("missing")).longValue();
        this.updateMinMax(stv.get("min"), stv.get("max"));
        this.updateTypeSpecificStats(stv);
        NamedList f = (NamedList)stv.get(FACETS);
        if (f == null) {
            return;
        }
        for (int i = 0; i < f.size(); ++i) {
            String field = f.getName(i);
            NamedList vals = (NamedList)f.getVal(i);
            Map<String, StatsValues> addTo = this.facets.get(field);
            if (addTo == null) {
                addTo = new HashMap<String, StatsValues>();
                this.facets.put(field, addTo);
            }
            for (int j = 0; j < vals.size(); ++j) {
                String val = vals.getName(j);
                StatsValues vvals = addTo.get(val);
                if (vvals == null) {
                    vvals = StatsValuesFactory.createStatsValues(this.sf);
                    addTo.put(val, vvals);
                }
                vvals.accumulate((NamedList)vals.getVal(j));
            }
        }
    }

    @Override
    public void accumulate(BytesRef value) {
        ++this.count;
        Object typedValue = this.ft.toObject(this.sf, value);
        this.updateMinMax(typedValue, typedValue);
        this.updateTypeSpecificStats(typedValue);
    }

    @Override
    public void accumulate(BytesRef value, int count) {
        this.count += (long)count;
        Object typedValue = this.ft.toObject(this.sf, value);
        this.updateMinMax(typedValue, typedValue);
        this.updateTypeSpecificStats(typedValue, count);
    }

    @Override
    public void missing() {
        ++this.missing;
    }

    @Override
    public void addMissing(int count) {
        this.missing += (long)count;
    }

    @Override
    public void addFacet(String facetName, Map<String, StatsValues> facetValues) {
        this.facets.put(facetName, facetValues);
    }

    @Override
    public NamedList<?> getStatsValues() {
        SimpleOrderedMap<Object> res = new SimpleOrderedMap<Object>();
        res.add("min", this.min);
        res.add("max", this.max);
        res.add("count", this.count);
        res.add("missing", this.missing);
        this.addTypeSpecificStats(res);
        SimpleOrderedMap nl = new SimpleOrderedMap();
        for (Map.Entry<String, Map<String, StatsValues>> entry : this.facets.entrySet()) {
            SimpleOrderedMap nl2 = new SimpleOrderedMap();
            nl.add(entry.getKey(), nl2);
            for (Map.Entry<String, StatsValues> e2 : entry.getValue().entrySet()) {
                nl2.add(e2.getKey(), e2.getValue().getStatsValues());
            }
            res.add(FACETS, nl);
        }
        return res;
    }

    protected abstract void updateMinMax(T var1, T var2);

    protected abstract void updateTypeSpecificStats(T var1);

    protected abstract void updateTypeSpecificStats(T var1, int var2);

    protected abstract void updateTypeSpecificStats(NamedList var1);

    protected abstract void addTypeSpecificStats(NamedList<Object> var1);
}

