/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.solr.cloud.ZkSolrResourceLoader;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.util.ContentStreamBase;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.SolrCore;
import org.apache.solr.core.SolrResourceLoader;
import org.apache.solr.handler.RequestHandlerBase;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.zookeeper.KeeperException;

public class ShowFileRequestHandler
extends RequestHandlerBase {
    public static final String HIDDEN = "hidden";
    public static final String USE_CONTENT_TYPE = "contentType";
    protected Set<String> hiddenFiles;

    @Override
    public void init(NamedList args) {
        String[] hidden;
        super.init(args);
        this.hiddenFiles = new HashSet<String>();
        if (this.invariants != null && (hidden = this.invariants.getParams(HIDDEN)) != null) {
            for (String s : hidden) {
                this.hiddenFiles.add(s.toUpperCase(Locale.ENGLISH));
            }
        }
    }

    public Set<String> getHiddenFiles() {
        return this.hiddenFiles;
    }

    @Override
    public void handleRequestBody(SolrQueryRequest req, SolrQueryResponse rsp) throws IOException, KeeperException, InterruptedException {
        CoreContainer coreContainer = req.getCore().getCoreDescriptor().getCoreContainer();
        if (coreContainer.isZooKeeperAware()) {
            this.showFromZooKeeper(req, rsp, coreContainer);
        } else {
            this.showFromFileSystem(req, rsp);
        }
    }

    private void showFromZooKeeper(SolrQueryRequest req, SolrQueryResponse rsp, CoreContainer coreContainer) throws KeeperException, InterruptedException, UnsupportedEncodingException {
        String adminFile = null;
        SolrCore core = req.getCore();
        SolrZkClient zkClient = coreContainer.getZkController().getZkClient();
        ZkSolrResourceLoader loader = (ZkSolrResourceLoader)core.getResourceLoader();
        String confPath = loader.getCollectionZkPath();
        String fname = req.getParams().get("file", null);
        if (fname == null) {
            adminFile = confPath;
        } else {
            if (this.hiddenFiles.contains((fname = fname.replace('\\', '/')).toUpperCase(Locale.ENGLISH))) {
                throw new SolrException(SolrException.ErrorCode.FORBIDDEN, "Can not access: " + fname);
            }
            if (fname.indexOf("..") >= 0) {
                throw new SolrException(SolrException.ErrorCode.FORBIDDEN, "Invalid path: " + fname);
            }
            adminFile = confPath + "/" + fname;
        }
        if (!zkClient.exists(adminFile, true).booleanValue()) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Can not find: " + adminFile);
        }
        List<String> children = zkClient.getChildren(adminFile, null, true);
        if (children.size() > 0) {
            SimpleOrderedMap files = new SimpleOrderedMap();
            for (String f : children) {
                if (this.hiddenFiles.contains(f.toUpperCase(Locale.ENGLISH)) || f.startsWith(".")) continue;
                SimpleOrderedMap<Comparable<Boolean>> fileInfo = new SimpleOrderedMap<Comparable<Boolean>>();
                files.add(f, fileInfo);
                List<String> fchildren = zkClient.getChildren(adminFile, null, true);
                if (fchildren.size() > 0) {
                    fileInfo.add("directory", Boolean.valueOf(true));
                    continue;
                }
                fileInfo.add("size", Integer.valueOf(f.length()));
            }
            rsp.add("files", files);
        } else {
            ModifiableSolrParams params = new ModifiableSolrParams(req.getParams());
            params.set("wt", "raw");
            req.setParams(params);
            ContentStreamBase.StringStream content = new ContentStreamBase.StringStream(new String(zkClient.getData(adminFile, null, null, true), "UTF-8"));
            content.setContentType(req.getParams().get(USE_CONTENT_TYPE));
            rsp.add("content", content);
        }
        rsp.setHttpCaching(false);
    }

    private void showFromFileSystem(SolrQueryRequest req, SolrQueryResponse rsp) throws IOException {
        String fname;
        File adminFile = null;
        SolrResourceLoader loader = req.getCore().getResourceLoader();
        File configdir = new File(loader.getConfigDir());
        if (!configdir.exists()) {
            try {
                configdir = new File(loader.getClassLoader().getResource(loader.getConfigDir()).toURI());
            }
            catch (URISyntaxException e) {
                throw new SolrException(SolrException.ErrorCode.FORBIDDEN, "Can not access configuration directory!");
            }
        }
        if ((fname = req.getParams().get("file", null)) == null) {
            adminFile = configdir;
        } else {
            if (this.hiddenFiles.contains((fname = fname.replace('\\', '/')).toUpperCase(Locale.ENGLISH))) {
                throw new SolrException(SolrException.ErrorCode.FORBIDDEN, "Can not access: " + fname);
            }
            if (fname.indexOf("..") >= 0) {
                throw new SolrException(SolrException.ErrorCode.FORBIDDEN, "Invalid path: " + fname);
            }
            adminFile = new File(configdir, fname);
        }
        if (!adminFile.exists()) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Can not find: " + adminFile.getName() + " [" + adminFile.getAbsolutePath() + "]");
        }
        if (!adminFile.canRead() || adminFile.isHidden()) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Can not show: " + adminFile.getName() + " [" + adminFile.getAbsolutePath() + "]");
        }
        if (adminFile.isDirectory()) {
            int basePath = configdir.getAbsolutePath().length() + 1;
            SimpleOrderedMap files = new SimpleOrderedMap();
            for (File f : adminFile.listFiles()) {
                String path = f.getAbsolutePath().substring(basePath);
                if (this.hiddenFiles.contains((path = path.replace('\\', '/')).toUpperCase(Locale.ENGLISH)) || f.isHidden() || f.getName().startsWith(".")) continue;
                SimpleOrderedMap<Comparable<Boolean>> fileInfo = new SimpleOrderedMap<Comparable<Boolean>>();
                files.add(path, fileInfo);
                if (f.isDirectory()) {
                    fileInfo.add("directory", Boolean.valueOf(true));
                } else {
                    fileInfo.add("size", Long.valueOf(f.length()));
                }
                fileInfo.add("modified", new Date(f.lastModified()));
            }
            rsp.add("files", files);
        } else {
            ModifiableSolrParams params = new ModifiableSolrParams(req.getParams());
            params.set("wt", "raw");
            req.setParams(params);
            ContentStreamBase.FileStream content = new ContentStreamBase.FileStream(adminFile);
            content.setContentType(req.getParams().get(USE_CONTENT_TYPE));
            rsp.add("content", content);
        }
        rsp.setHttpCaching(false);
    }

    @Override
    public String getDescription() {
        return "Admin Get File -- view config files directly";
    }

    @Override
    public String getSource() {
        return "$URL: https://svn.apache.org/repos/asf/lucene/dev/branches/branch_4x/solr/core/src/java/org/apache/solr/handler/admin/ShowFileRequestHandler.java $";
    }
}

