/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin;

import java.io.IOException;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.handler.RequestHandlerBase;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;

public class PropertiesRequestHandler
extends RequestHandlerBase {
    @Override
    public void handleRequestBody(SolrQueryRequest req, SolrQueryResponse rsp) throws IOException {
        Cloneable props = null;
        String name = req.getParams().get("name");
        if (name != null) {
            SimpleOrderedMap<String> p = new SimpleOrderedMap<String>();
            p.add(name, System.getProperty(name));
            props = p;
        } else {
            props = System.getProperties();
        }
        rsp.add("system.properties", props);
        rsp.setHttpCaching(false);
    }

    @Override
    public String getDescription() {
        return "Get System Properties";
    }

    @Override
    public String getSource() {
        return "$URL: https://svn.apache.org/repos/asf/lucene/dev/branches/branch_4x/solr/core/src/java/org/apache/solr/handler/admin/PropertiesRequestHandler.java $";
    }
}

