/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.MapSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.update.CommitUpdateCommand;
import org.apache.solr.update.RollbackUpdateCommand;
import org.apache.solr.update.processor.UpdateRequestProcessor;

public class RequestHandlerUtils {
    private static Set<String> commitParams = new HashSet<String>(Arrays.asList("openSearcher", "waitSearcher", "softCommit", "expungeDeletes", "maxSegments", "prepareCommit"));

    public static void addExperimentalFormatWarning(SolrQueryResponse rsp) {
        rsp.add("WARNING", "This response format is experimental.  It is likely to change in the future.");
    }

    public static boolean handleCommit(SolrQueryRequest req, UpdateRequestProcessor processor, SolrParams params, boolean force) throws IOException {
        if (params == null) {
            params = new MapSolrParams(new HashMap<String, String>());
        }
        boolean optimize = params.getBool("optimize", false);
        boolean commit = params.getBool("commit", false);
        boolean softCommit = params.getBool("softCommit", false);
        boolean prepareCommit = params.getBool("prepareCommit", false);
        if (optimize || commit || softCommit || prepareCommit || force) {
            CommitUpdateCommand cmd = new CommitUpdateCommand(req, optimize);
            RequestHandlerUtils.updateCommit(cmd, params);
            processor.processCommit(cmd);
            return true;
        }
        return false;
    }

    public static void validateCommitParams(SolrParams params) {
        Iterator<String> i = params.getParameterNamesIterator();
        while (i.hasNext()) {
            String key = i.next();
            if (commitParams.contains(key)) continue;
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unknown commit parameter '" + key + "'");
        }
    }

    public static void updateCommit(CommitUpdateCommand cmd, SolrParams params) throws IOException {
        if (params == null) {
            return;
        }
        cmd.openSearcher = params.getBool("openSearcher", cmd.openSearcher);
        cmd.waitSearcher = params.getBool("waitSearcher", cmd.waitSearcher);
        cmd.softCommit = params.getBool("softCommit", cmd.softCommit);
        cmd.expungeDeletes = params.getBool("expungeDeletes", cmd.expungeDeletes);
        cmd.maxOptimizeSegments = params.getInt("maxSegments", cmd.maxOptimizeSegments);
        cmd.prepareCommit = params.getBool("prepareCommit", cmd.prepareCommit);
    }

    public static boolean handleRollback(SolrQueryRequest req, UpdateRequestProcessor processor, SolrParams params, boolean force) throws IOException {
        boolean rollback;
        if (params == null) {
            params = new MapSolrParams(new HashMap<String, String>());
        }
        if ((rollback = params.getBool("rollback", false)) || force) {
            RollbackUpdateCommand cmd = new RollbackUpdateCommand(req);
            processor.processRollback(cmd);
            return true;
        }
        return false;
    }
}

