/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.core;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathConstants;
import org.apache.lucene.index.IndexDeletionPolicy;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.util.Version;
import org.apache.solr.common.SolrException;
import org.apache.solr.core.CodecFactory;
import org.apache.solr.core.Config;
import org.apache.solr.core.DirectoryFactory;
import org.apache.solr.core.IndexReaderFactory;
import org.apache.solr.core.PluginInfo;
import org.apache.solr.core.SolrEventListener;
import org.apache.solr.core.SolrResourceLoader;
import org.apache.solr.handler.component.SearchComponent;
import org.apache.solr.request.SolrRequestHandler;
import org.apache.solr.response.QueryResponseWriter;
import org.apache.solr.response.transform.TransformerFactory;
import org.apache.solr.search.CacheConfig;
import org.apache.solr.search.FastLRUCache;
import org.apache.solr.search.QParserPlugin;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.search.ValueSourceParser;
import org.apache.solr.spelling.QueryConverter;
import org.apache.solr.update.SolrIndexConfig;
import org.apache.solr.update.UpdateLog;
import org.apache.solr.update.processor.UpdateRequestProcessorChain;
import org.apache.solr.util.DOMUtil;
import org.apache.solr.util.RegexFileFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class SolrConfig
extends Config {
    public static final Logger log = LoggerFactory.getLogger(SolrConfig.class);
    public static final String DEFAULT_CONF_FILE = "solrconfig.xml";
    public final int booleanQueryMaxClauseCount;
    public final CacheConfig filterCacheConfig;
    public final CacheConfig queryResultCacheConfig;
    public final CacheConfig documentCacheConfig;
    public final CacheConfig fieldValueCacheConfig;
    public final CacheConfig[] userCacheConfigs;
    public final boolean useFilterForSortedQuery;
    public final int queryResultWindowSize;
    public final int queryResultMaxDocsCached;
    public final boolean enableLazyFieldLoading;
    public final boolean reopenReaders;
    public final float hashSetInverseLoadFactor;
    public final int hashDocSetMaxSize;
    @Deprecated
    public final SolrIndexConfig defaultIndexConfig;
    @Deprecated
    public final SolrIndexConfig mainIndexConfig;
    public final SolrIndexConfig indexConfig;
    protected UpdateHandlerInfo updateHandlerInfo;
    private Map<String, List<PluginInfo>> pluginStore = new LinkedHashMap<String, List<PluginInfo>>();
    public final int maxWarmingSearchers;
    public final boolean unlockOnStartup;
    public final boolean useColdSearcher;
    public final Version luceneMatchVersion;
    protected String dataDir;
    public final JmxConfiguration jmxConfig;
    private final HttpCachingConfig httpCachingConfig;

    public SolrConfig() throws ParserConfigurationException, IOException, SAXException {
        this((SolrResourceLoader)null, DEFAULT_CONF_FILE, (InputSource)null);
    }

    public SolrConfig(String name) throws ParserConfigurationException, IOException, SAXException {
        this((SolrResourceLoader)null, name, (InputSource)null);
    }

    public SolrConfig(String name, InputSource is) throws ParserConfigurationException, IOException, SAXException {
        this((SolrResourceLoader)null, name, is);
    }

    public SolrConfig(String instanceDir, String name, InputSource is) throws ParserConfigurationException, IOException, SAXException {
        this(new SolrResourceLoader(instanceDir), name, is);
    }

    SolrConfig(SolrResourceLoader loader, String name, InputSource is) throws ParserConfigurationException, IOException, SAXException {
        super(loader, name, is, "/config/");
        String indexConfigPrefix;
        boolean hasNewIndexConfig;
        this.initLibs();
        this.luceneMatchVersion = this.getLuceneVersion("luceneMatchVersion");
        boolean hasDeprecatedIndexConfig = this.get("indexDefaults/text()", null) != null || this.get("mainIndex/text()", null) != null;
        boolean bl = hasNewIndexConfig = this.get("indexConfig/text()", null) != null;
        if (hasDeprecatedIndexConfig) {
            if (this.luceneMatchVersion.onOrAfter(Version.LUCENE_40)) {
                throw new SolrException(SolrException.ErrorCode.FORBIDDEN, "<indexDefaults> and <mainIndex> configuration sections are discontinued. Use <indexConfig> instead.");
            }
            if (hasNewIndexConfig) {
                throw new SolrException(SolrException.ErrorCode.FORBIDDEN, "Cannot specify both <indexDefaults>, <mainIndex> and <indexConfig> at the same time. Please use <indexConfig> only.");
            }
            log.warn("<indexDefaults> and <mainIndex> configuration sections are deprecated and will fail for luceneMatchVersion=LUCENE_40 and later. Please use <indexConfig> instead.");
            this.defaultIndexConfig = new SolrIndexConfig(this, "indexDefaults", null);
            this.mainIndexConfig = new SolrIndexConfig(this, "mainIndex", this.defaultIndexConfig);
            indexConfigPrefix = "mainIndex";
        } else {
            this.mainIndexConfig = null;
            this.defaultIndexConfig = null;
            indexConfigPrefix = "indexConfig";
        }
        this.indexConfig = new SolrIndexConfig(this, "indexConfig", this.mainIndexConfig);
        this.reopenReaders = this.getBool(indexConfigPrefix + "/reopenReaders", true);
        this.booleanQueryMaxClauseCount = this.getInt("query/maxBooleanClauses", BooleanQuery.getMaxClauseCount());
        log.info("Using Lucene MatchVersion: " + (Object)((Object)this.luceneMatchVersion));
        if (this.get("query/boolTofilterOptimizer", null) != null) {
            log.warn("solrconfig.xml: <boolTofilterOptimizer> is currently not implemented and has no effect.");
        }
        if (this.get("query/HashDocSet", null) != null) {
            log.warn("solrconfig.xml: <HashDocSet> is deprecated and no longer recommended used.");
        }
        this.useFilterForSortedQuery = this.getBool("query/useFilterForSortedQuery", false);
        this.queryResultWindowSize = Math.max(1, this.getInt("query/queryResultWindowSize", 1));
        this.queryResultMaxDocsCached = this.getInt("query/queryResultMaxDocsCached", Integer.MAX_VALUE);
        this.enableLazyFieldLoading = this.getBool("query/enableLazyFieldLoading", false);
        this.filterCacheConfig = CacheConfig.getConfig(this, "query/filterCache");
        this.queryResultCacheConfig = CacheConfig.getConfig(this, "query/queryResultCache");
        this.documentCacheConfig = CacheConfig.getConfig(this, "query/documentCache");
        CacheConfig conf = CacheConfig.getConfig(this, "query/fieldValueCache");
        if (conf == null) {
            HashMap<String, String> args = new HashMap<String, String>();
            args.put("name", "fieldValueCache");
            args.put("size", "10000");
            args.put("initialSize", "10");
            args.put("showItems", "-1");
            conf = new CacheConfig(FastLRUCache.class, args, null);
        }
        this.fieldValueCacheConfig = conf;
        this.unlockOnStartup = this.getBool(indexConfigPrefix + "/unlockOnStartup", false);
        this.useColdSearcher = this.getBool("query/useColdSearcher", false);
        this.dataDir = this.get("dataDir", null);
        if (this.dataDir != null && this.dataDir.length() == 0) {
            this.dataDir = null;
        }
        this.userCacheConfigs = CacheConfig.getMultipleConfigs(this, "query/cache");
        SolrIndexSearcher.initRegenerators(this);
        this.hashSetInverseLoadFactor = 1.0f / this.getFloat("//HashDocSet/@loadFactor", 0.75f);
        this.hashDocSetMaxSize = this.getInt("//HashDocSet/@maxSize", 3000);
        this.httpCachingConfig = new HttpCachingConfig(this);
        Node jmx = this.getNode("jmx", false);
        this.jmxConfig = jmx != null ? new JmxConfiguration(true, this.get("jmx/@agentId", null), this.get("jmx/@serviceUrl", null), this.get("jmx/@rootName", null)) : new JmxConfiguration(false, null, null, null);
        this.maxWarmingSearchers = this.getInt("query/maxWarmingSearchers", Integer.MAX_VALUE);
        this.loadPluginInfo(SolrRequestHandler.class, "requestHandler", true, true);
        this.loadPluginInfo(QParserPlugin.class, "queryParser", true, true);
        this.loadPluginInfo(QueryResponseWriter.class, "queryResponseWriter", true, true);
        this.loadPluginInfo(ValueSourceParser.class, "valueSourceParser", true, true);
        this.loadPluginInfo(TransformerFactory.class, "transformer", true, true);
        this.loadPluginInfo(SearchComponent.class, "searchComponent", true, true);
        this.loadPluginInfo(QueryConverter.class, "queryConverter", true, true);
        this.loadPluginInfo(SolrEventListener.class, "//listener", false, true);
        this.loadPluginInfo(DirectoryFactory.class, "directoryFactory", false, true);
        this.loadPluginInfo(IndexDeletionPolicy.class, indexConfigPrefix + "/deletionPolicy", false, true);
        this.loadPluginInfo(CodecFactory.class, "mainIndex/codecFactory", false, false);
        this.loadPluginInfo(IndexReaderFactory.class, "indexReaderFactory", false, true);
        this.loadPluginInfo(UpdateRequestProcessorChain.class, "updateRequestProcessorChain", false, false);
        this.loadPluginInfo(UpdateLog.class, "updateHandler/updateLog", false, false);
        this.updateHandlerInfo = this.loadUpdatehandlerInfo();
        Config.log.info("Loaded SolrConfig: " + name);
    }

    protected UpdateHandlerInfo loadUpdatehandlerInfo() {
        return new UpdateHandlerInfo(this.get("updateHandler/@class", null), this.getInt("updateHandler/autoCommit/maxDocs", -1), this.getInt("updateHandler/autoCommit/maxTime", -1), this.getBool("updateHandler/autoCommit/openSearcher", true), this.getInt("updateHandler/commitIntervalLowerBound", -1), this.getInt("updateHandler/autoSoftCommit/maxDocs", -1), this.getInt("updateHandler/autoSoftCommit/maxTime", -1));
    }

    private void loadPluginInfo(Class clazz, String tag, boolean requireName, boolean requireClass) {
        List<PluginInfo> result = this.readPluginInfos(tag, requireName, requireClass);
        if (!result.isEmpty()) {
            this.pluginStore.put(clazz.getName(), result);
        }
    }

    public List<PluginInfo> readPluginInfos(String tag, boolean requireName, boolean requireClass) {
        ArrayList<PluginInfo> result = new ArrayList<PluginInfo>();
        NodeList nodes = (NodeList)this.evaluate(tag, XPathConstants.NODESET);
        for (int i = 0; i < nodes.getLength(); ++i) {
            PluginInfo pluginInfo = new PluginInfo(nodes.item(i), "[solrconfig.xml] " + tag, requireName, requireClass);
            if (!pluginInfo.isEnabled()) continue;
            result.add(pluginInfo);
        }
        return result;
    }

    public HttpCachingConfig getHttpCachingConfig() {
        return this.httpCachingConfig;
    }

    public UpdateHandlerInfo getUpdateHandlerInfo() {
        return this.updateHandlerInfo;
    }

    public String getDataDir() {
        return this.dataDir;
    }

    public List<PluginInfo> getPluginInfos(String type) {
        List<PluginInfo> result = this.pluginStore.get(type);
        return result == null ? Collections.EMPTY_LIST : result;
    }

    public PluginInfo getPluginInfo(String type) {
        List<PluginInfo> result = this.pluginStore.get(type);
        return result == null || result.isEmpty() ? null : result.get(0);
    }

    private void initLibs() {
        NodeList nodes = (NodeList)this.evaluate("lib", XPathConstants.NODESET);
        if (nodes == null || nodes.getLength() == 0) {
            return;
        }
        log.info("Adding specified lib dirs to ClassLoader");
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            String baseDir = DOMUtil.getAttr(node, "dir");
            String path = DOMUtil.getAttr(node, "path");
            if (null != baseDir) {
                String regex = DOMUtil.getAttr(node, "regex");
                RegexFileFilter filter = null == regex ? null : new RegexFileFilter(regex);
                this.getResourceLoader().addToClassLoader(baseDir, filter);
                continue;
            }
            if (null != path) {
                this.getResourceLoader().addToClassLoader(path);
                continue;
            }
            throw new RuntimeException("lib: missing mandatory attributes: 'dir' or 'path'");
        }
    }

    public static class UpdateHandlerInfo {
        public final String className;
        public final int autoCommmitMaxDocs;
        public final int autoCommmitMaxTime;
        public final int commitIntervalLowerBound;
        public final int autoSoftCommmitMaxDocs;
        public final int autoSoftCommmitMaxTime;
        public final boolean openSearcher;

        public UpdateHandlerInfo(String className, int autoCommmitMaxDocs, int autoCommmitMaxTime, boolean openSearcher, int commitIntervalLowerBound, int autoSoftCommmitMaxDocs, int autoSoftCommmitMaxTime) {
            this.className = className;
            this.autoCommmitMaxDocs = autoCommmitMaxDocs;
            this.autoCommmitMaxTime = autoCommmitMaxTime;
            this.openSearcher = openSearcher;
            this.commitIntervalLowerBound = commitIntervalLowerBound;
            this.autoSoftCommmitMaxDocs = autoSoftCommmitMaxDocs;
            this.autoSoftCommmitMaxTime = autoSoftCommmitMaxTime;
        }
    }

    public static class HttpCachingConfig {
        private static final String CACHE_PRE = "requestDispatcher/httpCaching/";
        private static final Pattern MAX_AGE = Pattern.compile("\\bmax-age=(\\d+)");
        private final boolean never304;
        private final String etagSeed;
        private final String cacheControlHeader;
        private final Long maxAge;
        private final LastModFrom lastModFrom;

        private HttpCachingConfig(SolrConfig conf) {
            this.never304 = conf.getBool("requestDispatcher/httpCaching/@never304", false);
            this.etagSeed = conf.get("requestDispatcher/httpCaching/@etagSeed", "Solr");
            this.lastModFrom = LastModFrom.parse(conf.get("requestDispatcher/httpCaching/@lastModFrom", "openTime"));
            this.cacheControlHeader = conf.get("requestDispatcher/httpCaching/cacheControl", null);
            Long tmp = null;
            if (null != this.cacheControlHeader) {
                try {
                    Matcher ttlMatcher = MAX_AGE.matcher(this.cacheControlHeader);
                    String ttlStr = ttlMatcher.find() ? ttlMatcher.group(1) : null;
                    tmp = null != ttlStr && !"".equals(ttlStr) ? Long.valueOf(ttlStr) : null;
                }
                catch (Exception e) {
                    log.warn("Ignoring exception while attempting to extract max-age from cacheControl config: " + this.cacheControlHeader, e);
                }
            }
            this.maxAge = tmp;
        }

        public boolean isNever304() {
            return this.never304;
        }

        public String getEtagSeed() {
            return this.etagSeed;
        }

        public String getCacheControlHeader() {
            return this.cacheControlHeader;
        }

        public Long getMaxAge() {
            return this.maxAge;
        }

        public LastModFrom getLastModFrom() {
            return this.lastModFrom;
        }

        public static enum LastModFrom {
            OPENTIME,
            DIRLASTMOD,
            BOGUS;


            public static LastModFrom parse(String s) {
                try {
                    return LastModFrom.valueOf(s.toUpperCase(Locale.ENGLISH));
                }
                catch (Exception e) {
                    log.warn("Unrecognized value for lastModFrom: " + s, e);
                    return BOGUS;
                }
            }
        }
    }

    public static class JmxConfiguration {
        public boolean enabled = false;
        public String agentId;
        public String serviceUrl;
        public String rootName;

        public JmxConfiguration(boolean enabled, String agentId, String serviceUrl, String rootName) {
            this.enabled = enabled;
            this.agentId = agentId;
            this.serviceUrl = serviceUrl;
            this.rootName = rootName;
            if (agentId != null && serviceUrl != null) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Incorrect JMX Configuration in solrconfig.xml, both agentId and serviceUrl cannot be specified at the same time");
            }
        }
    }
}

