/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.common.cloud;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.noggit.JSONWriter;
import org.apache.solr.common.cloud.ZkStateReader;

public class ZkNodeProps
implements JSONWriter.Writable {
    private final Map<String, String> propMap;

    public ZkNodeProps(Map<String, String> propMap) {
        this.propMap = new HashMap<String, String>();
        this.propMap.putAll(propMap);
    }

    public ZkNodeProps(ZkNodeProps zkNodeProps) {
        this.propMap = new HashMap<String, String>();
        this.propMap.putAll(zkNodeProps.propMap);
    }

    public ZkNodeProps(String ... keyVals) {
        if (keyVals.length % 2 != 0) {
            throw new IllegalArgumentException("arguments should be key,value");
        }
        this.propMap = new HashMap<String, String>();
        for (int i = 0; i < keyVals.length; i += 2) {
            this.propMap.put(keyVals[i], keyVals[i + 1]);
        }
    }

    public Set<String> keySet() {
        return Collections.unmodifiableSet(this.propMap.keySet());
    }

    public Map<String, String> getProperties() {
        return Collections.unmodifiableMap(this.propMap);
    }

    public static ZkNodeProps load(byte[] bytes) {
        Map props = (Map)ZkStateReader.fromJSON(bytes);
        return new ZkNodeProps(props);
    }

    @Override
    public void write(JSONWriter jsonWriter) {
        jsonWriter.write(this.propMap);
    }

    public String get(String key) {
        return this.propMap.get(key);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        Set<Map.Entry<String, String>> entries = this.propMap.entrySet();
        for (Map.Entry<String, String> entry : entries) {
            sb.append(entry.getKey() + "=" + entry.getValue() + "\n");
        }
        return sb.toString();
    }

    public boolean containsKey(String key) {
        return this.propMap.containsKey(key);
    }
}

