/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.xpath.XPathConstants;
import org.apache.solr.client.solrj.impl.HttpSolrServer;
import org.apache.solr.client.solrj.request.CoreAdminRequest;
import org.apache.solr.cloud.CloudDescriptor;
import org.apache.solr.cloud.CurrentCoreDescriptorProvider;
import org.apache.solr.cloud.DistributedQueue;
import org.apache.solr.cloud.ElectionContext;
import org.apache.solr.cloud.LeaderElector;
import org.apache.solr.cloud.Overseer;
import org.apache.solr.cloud.OverseerElectionContext;
import org.apache.solr.cloud.ShardLeaderElectionContext;
import org.apache.solr.cloud.SolrZkServer;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.CloudState;
import org.apache.solr.common.cloud.OnReconnect;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.common.cloud.ZkCmdExecutor;
import org.apache.solr.common.cloud.ZkCoreNodeProps;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.common.cloud.ZooKeeperException;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.core.Config;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.CoreDescriptor;
import org.apache.solr.core.SolrCore;
import org.apache.solr.core.SolrResourceLoader;
import org.apache.solr.util.DOMUtil;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public final class ZkController {
    private static Logger log = LoggerFactory.getLogger(ZkController.class);
    static final String NEWL = System.getProperty("line.separator");
    private static final Pattern URL_POST = Pattern.compile("https?://(.*)");
    private static final Pattern URL_PREFIX = Pattern.compile("(https?://).*");
    private final boolean SKIP_AUTO_RECOVERY = Boolean.getBoolean("solrcloud.skip.autorecovery");
    private final DistributedQueue overseerStatusQueue;
    static final String CONFIGS_ZKNODE = "/configs";
    public static final String COLLECTION_PARAM_PREFIX = "collection.";
    public static final String CONFIGNAME_PROP = "configName";
    private final Map<String, ElectionContext> electionContexts = Collections.synchronizedMap(new HashMap());
    private SolrZkClient zkClient;
    private ZkCmdExecutor cmdExecutor;
    private ZkStateReader zkStateReader;
    private LeaderElector leaderElector;
    private String zkServerAddress;
    private final String localHostPort;
    private final String localHostContext;
    private final String localHost;
    private final String hostName;
    private final String nodeName;
    private final String baseURL;
    private LeaderElector overseerElector;
    private CoreContainer cc;

    public static void main(String[] args) throws Exception {
        String zkServerAddress = args[0];
        String solrHome = args[1];
        String solrPort = null;
        if (args.length > 2) {
            solrPort = args[2];
        }
        SolrZkServer zkServer = null;
        if (solrPort != null) {
            zkServer = new SolrZkServer("true", null, solrHome + "/zoo_data", solrHome, solrPort);
            zkServer.parseConfig();
            zkServer.start();
        }
        SolrZkClient zkClient = new SolrZkClient(zkServerAddress, 15000, 5000, new OnReconnect(){

            @Override
            public void command() {
            }
        });
        SolrResourceLoader loader = new SolrResourceLoader(solrHome);
        solrHome = loader.getInstanceDir();
        InputSource cfgis = new InputSource(new File(solrHome, "solr.xml").toURI().toASCIIString());
        Config cfg = new Config(loader, null, cfgis, null, false);
        ZkController.bootstrapConf(zkClient, cfg, solrHome);
        if (solrPort != null) {
            zkServer.stop();
        }
    }

    public ZkController(CoreContainer cc, String zkServerAddress, int zkClientTimeout, int zkClientConnectTimeout, String localHost, String locaHostPort, String localHostContext, final CurrentCoreDescriptorProvider registerOnReconnect) throws InterruptedException, TimeoutException, IOException {
        this.cc = cc;
        if (localHostContext.contains("/")) {
            throw new IllegalArgumentException("localHostContext (" + localHostContext + ") should not contain a /");
        }
        this.zkServerAddress = zkServerAddress;
        this.localHostPort = locaHostPort;
        this.localHostContext = localHostContext;
        this.localHost = this.getHostAddress(localHost);
        this.hostName = this.getHostNameFromAddress(this.localHost);
        this.nodeName = this.hostName + ':' + this.localHostPort + '_' + this.localHostContext;
        this.baseURL = this.localHost + ":" + this.localHostPort + "/" + this.localHostContext;
        this.zkClient = new SolrZkClient(zkServerAddress, zkClientTimeout, zkClientConnectTimeout, new OnReconnect(){

            @Override
            public void command() {
                try {
                    OverseerElectionContext context = new OverseerElectionContext(ZkController.this.getNodeName(), ZkController.this.zkStateReader);
                    ZkController.this.overseerElector.joinElection(context);
                    ZkController.this.zkStateReader.createClusterStateWatchersAndUpdate();
                    List<CoreDescriptor> descriptors = registerOnReconnect.getCurrentDescriptors();
                    if (descriptors != null) {
                        for (CoreDescriptor descriptor : descriptors) {
                            String coreZkNodeName = ZkController.this.getNodeName() + "_" + descriptor.getName();
                            try {
                                ZkController.this.publish(descriptor, "down");
                                ZkController.this.waitForLeaderToSeeDownState(descriptor, coreZkNodeName);
                            }
                            catch (Exception e) {
                                SolrException.log(log, "", e);
                            }
                        }
                    }
                    ZkController.this.createEphemeralLiveNode();
                    if (descriptors != null) {
                        for (CoreDescriptor descriptor : descriptors) {
                            ZkController.this.register(descriptor.getName(), descriptor, true);
                        }
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "", e);
                }
                catch (Exception e) {
                    SolrException.log(log, "", e);
                    throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "", e);
                }
            }
        });
        this.overseerStatusQueue = Overseer.getInQueue(this.zkClient);
        this.cmdExecutor = new ZkCmdExecutor();
        this.leaderElector = new LeaderElector(this.zkClient);
        this.zkStateReader = new ZkStateReader(this.zkClient);
        this.init();
    }

    public void close() {
        try {
            this.zkClient.close();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            log.warn("", e);
            throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "", e);
        }
    }

    public boolean configFileExists(String collection, String fileName) throws KeeperException, InterruptedException {
        Stat stat = this.zkClient.exists("/configs/" + collection + "/" + fileName, null, true);
        return stat != null;
    }

    public CloudState getCloudState() {
        return this.zkStateReader.getCloudState();
    }

    public byte[] getConfigFileData(String zkConfigName, String fileName) throws KeeperException, InterruptedException {
        String zkPath = "/configs/" + zkConfigName + "/" + fileName;
        byte[] bytes = this.zkClient.getData(zkPath, null, null, true);
        if (bytes == null) {
            log.error("Config file contains no data:" + zkPath);
            throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "Config file contains no data:" + zkPath);
        }
        return bytes;
    }

    private String getHostAddress(String host) throws IOException {
        if (host == null) {
            host = "http://" + InetAddress.getLocalHost().getHostName();
        } else {
            Matcher m = URL_PREFIX.matcher(host);
            if (m.matches()) {
                String prefix = m.group(1);
                host = prefix + host;
            } else {
                host = "http://" + host;
            }
        }
        return host;
    }

    private String getHostNameFromAddress(String addr) {
        Matcher m = URL_POST.matcher(addr);
        if (m.matches()) {
            return m.group(1);
        }
        log.error("Unrecognized host:" + addr);
        throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "Unrecognized host:" + addr);
    }

    public String getHostName() {
        return this.hostName;
    }

    public String getHostPort() {
        return this.localHostPort;
    }

    public SolrZkClient getZkClient() {
        return this.zkClient;
    }

    public String getZkServerAddress() {
        return this.zkServerAddress;
    }

    private void init() {
        try {
            this.cmdExecutor.ensureExists("/live_nodes", this.zkClient);
            this.createEphemeralLiveNode();
            this.cmdExecutor.ensureExists("/collections", this.zkClient);
            this.overseerElector = new LeaderElector(this.zkClient);
            OverseerElectionContext context = new OverseerElectionContext(this.getNodeName(), this.zkStateReader);
            this.overseerElector.setup(context);
            this.overseerElector.joinElection(context);
            this.zkStateReader.createClusterStateWatchersAndUpdate();
        }
        catch (IOException e) {
            log.error("", e);
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Can't create ZooKeeperController", e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            log.error("", e);
            throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "", e);
        }
        catch (KeeperException e) {
            log.error("", e);
            throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "", e);
        }
    }

    public boolean isConnected() {
        return this.zkClient.isConnected();
    }

    private void createEphemeralLiveNode() throws KeeperException, InterruptedException {
        block5: {
            String nodeName = this.getNodeName();
            String nodePath = "/live_nodes/" + nodeName;
            log.info("Register node as live in ZooKeeper:" + nodePath);
            try {
                boolean nodeDeleted = true;
                try {
                    this.zkClient.delete(nodePath, -1, true);
                }
                catch (KeeperException.NoNodeException e) {
                    nodeDeleted = false;
                }
                if (nodeDeleted) {
                    log.info("Found a previous node that still exists while trying to register a new live node " + nodePath + " - removing existing node to create another.");
                }
                this.zkClient.makePath(nodePath, CreateMode.EPHEMERAL, true);
            }
            catch (KeeperException e) {
                if (e.code() == KeeperException.Code.NODEEXISTS) break block5;
                throw e;
            }
        }
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public boolean pathExists(String path) throws KeeperException, InterruptedException {
        return this.zkClient.exists(path, true);
    }

    public String readConfigName(String collection) throws KeeperException, InterruptedException, IOException {
        byte[] data;
        String configName = null;
        String path = "/collections/" + collection;
        if (log.isInfoEnabled()) {
            log.info("Load collection config from:" + path);
        }
        if ((data = this.zkClient.getData(path, null, null, true)) != null) {
            ZkNodeProps props = ZkNodeProps.load(data);
            configName = props.get(CONFIGNAME_PROP);
        }
        if (configName != null && !this.zkClient.exists("/configs/" + configName, true).booleanValue()) {
            log.error("Specified config does not exist in ZooKeeper:" + configName);
            throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "Specified config does not exist in ZooKeeper:" + configName);
        }
        return configName;
    }

    public String register(String coreName, CoreDescriptor desc) throws Exception {
        return this.register(coreName, desc, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public String register(String coreName, CoreDescriptor desc, boolean recoverReloadedCores) throws Exception {
        baseUrl = this.getBaseUrl();
        cloudDesc = desc.getCloudDescriptor();
        collection = cloudDesc.getCollectionName();
        coreZkNodeName = this.getNodeName() + "_" + coreName;
        shardId = cloudDesc.getShardId();
        props = new HashMap<String, String>();
        props.put("base_url", baseUrl);
        props.put("core", coreName);
        props.put("node_name", this.getNodeName());
        if (ZkController.log.isInfoEnabled()) {
            ZkController.log.info("Register shard - core:" + coreName + " address:" + baseUrl + " shardId:" + shardId);
        }
        leaderProps = new ZkNodeProps(props);
        try {
            this.joinElection(desc);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "", e);
        }
        catch (KeeperException e) {
            throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "", e);
        }
        catch (IOException e) {
            throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "", e);
        }
        leaderUrl = this.getLeaderProps(collection, cloudDesc.getShardId()).getCoreUrl();
        cloudStateLeader = this.zkStateReader.getLeaderUrl(collection, cloudDesc.getShardId(), 30000);
        tries = 0;
        while (!leaderUrl.equals(cloudStateLeader)) {
            if (tries == 60) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "There is conflicting information about the leader of shard: " + cloudDesc.getShardId());
            }
            Thread.sleep(1000L);
            ++tries;
            cloudStateLeader = this.zkStateReader.getLeaderUrl(collection, cloudDesc.getShardId(), 30000);
        }
        ourUrl = ZkCoreNodeProps.getCoreUrl(baseUrl, coreName);
        ZkController.log.info("We are " + ourUrl + " and leader is " + leaderUrl);
        isLeader = leaderUrl.equals(ourUrl);
        core = null;
        if (this.cc != null) {
            try {
                core = this.cc.getCore(desc.getName());
                ulog = core.getUpdateHandler().getUpdateLog();
                if (!core.isReloaded() && ulog != null) {
                    recoveryFuture = core.getUpdateHandler().getUpdateLog().recoverFromLog();
                    if (recoveryFuture != null) {
                        recoveryFuture.get();
                    } else {
                        ZkController.log.info("No LogReplay needed for core=" + core.getName() + " baseURL=" + baseUrl);
                    }
                }
                if (didRecovery = this.checkRecovery(coreName, desc, recoverReloadedCores, isLeader, cloudDesc, collection, coreZkNodeName, shardId, leaderProps, core, this.cc)) ** GOTO lbl59
                this.publish(desc, "active");
            }
            finally {
                if (core != null) {
                    core.close();
                }
            }
        } else {
            this.publish(desc, "active");
        }
lbl59:
        // 3 sources

        this.zkStateReader.updateCloudState(true);
        return shardId;
    }

    private ZkCoreNodeProps getLeaderProps(String collection, String slice) throws KeeperException, InterruptedException {
        int iterCount = 60;
        while (iterCount-- > 0) {
            try {
                byte[] data = this.zkClient.getData(ZkStateReader.getShardLeadersPath(collection, slice), null, null, true);
                ZkCoreNodeProps leaderProps = new ZkCoreNodeProps(ZkNodeProps.load(data));
                return leaderProps;
            }
            catch (KeeperException.NoNodeException e) {
                Thread.sleep(500L);
            }
        }
        throw new RuntimeException("Could not get leader props");
    }

    private void joinElection(CoreDescriptor cd) throws InterruptedException, KeeperException, IOException {
        String shardId = cd.getCloudDescriptor().getShardId();
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("base_url", this.getBaseUrl());
        props.put("core", cd.getName());
        props.put("node_name", this.getNodeName());
        String coreZkNodeName = this.getNodeName() + "_" + cd.getName();
        ZkNodeProps ourProps = new ZkNodeProps(props);
        String collection = cd.getCloudDescriptor().getCollectionName();
        ShardLeaderElectionContext context = new ShardLeaderElectionContext(this.leaderElector, shardId, collection, coreZkNodeName, ourProps, this, this.cc);
        this.leaderElector.setup(context);
        this.electionContexts.put(coreZkNodeName, context);
        this.leaderElector.joinElection(context);
    }

    private boolean checkRecovery(String coreName, CoreDescriptor desc, boolean recoverReloadedCores, boolean isLeader, CloudDescriptor cloudDesc, String collection, String shardZkNodeName, String shardId, ZkNodeProps leaderProps, SolrCore core, CoreContainer cc) throws InterruptedException, KeeperException, IOException, ExecutionException {
        if (this.SKIP_AUTO_RECOVERY) {
            log.warn("Skipping recovery according to sys prop solrcloud.skip.autorecovery");
            return false;
        }
        boolean doRecovery = true;
        if (!isLeader) {
            if (core.isReloaded() && !recoverReloadedCores) {
                doRecovery = false;
            }
            if (doRecovery) {
                log.info("Core needs to recover:" + core.getName());
                core.getUpdateHandler().getSolrCoreState().doRecovery(cc, coreName);
                return true;
            }
        } else {
            log.info("I am the leader, no recovery necessary");
        }
        return false;
    }

    public String getBaseUrl() {
        return this.baseURL;
    }

    public void publish(CoreDescriptor cd, String state) throws KeeperException, InterruptedException {
        Integer numShards = cd.getCloudDescriptor().getNumShards();
        if (numShards == null) {
            numShards = Integer.getInteger("numShards");
        }
        ZkNodeProps m = new ZkNodeProps("operation", "state", "state", state, "base_url", this.getBaseUrl(), "core", cd.getName(), "roles", cd.getCloudDescriptor().getRoles(), "node_name", this.getNodeName(), "shard", cd.getCloudDescriptor().getShardId(), "collection", cd.getCloudDescriptor().getCollectionName(), "state", state, "numShards", numShards != null ? numShards.toString() : null);
        this.overseerStatusQueue.offer(ZkStateReader.toJSON(m));
    }

    private boolean needsToBeAssignedShardId(CoreDescriptor desc, CloudState state, String shardZkNodeName) {
        CloudDescriptor cloudDesc = desc.getCloudDescriptor();
        String shardId = state.getShardId(shardZkNodeName);
        if (shardId != null) {
            cloudDesc.setShardId(shardId);
            return false;
        }
        return true;
    }

    public void unregister(String coreName, CloudDescriptor cloudDesc) throws InterruptedException, KeeperException {
        ZkNodeProps m = new ZkNodeProps("operation", "deletecore", "core", coreName, "node_name", this.getNodeName(), "collection", cloudDesc.getCollectionName());
        this.overseerStatusQueue.offer(ZkStateReader.toJSON(m));
        String zkNodeName = this.getNodeName() + "_" + coreName;
        ElectionContext context = this.electionContexts.remove(zkNodeName);
        if (context != null) {
            context.cancelElection();
        }
    }

    public void uploadToZK(File dir, String zkPath) throws IOException, KeeperException, InterruptedException {
        ZkController.uploadToZK(this.zkClient, dir, zkPath);
    }

    public void uploadConfigDir(File dir, String configName) throws IOException, KeeperException, InterruptedException {
        ZkController.uploadToZK(this.zkClient, dir, "/configs/" + configName);
    }

    void printLayoutToStdOut() throws KeeperException, InterruptedException {
        this.zkClient.printLayoutToStdOut();
    }

    public void createCollectionZkNode(CloudDescriptor cd) throws KeeperException, InterruptedException, IOException {
        block16: {
            String collection = cd.getCollectionName();
            log.info("Check for collection zkNode:" + collection);
            String collectionPath = "/collections/" + collection;
            try {
                if (!this.zkClient.exists(collectionPath, true).booleanValue()) {
                    log.info("Creating collection in ZooKeeper:" + collection);
                    SolrParams params = cd.getParams();
                    try {
                        HashMap<String, String> collectionProps = new HashMap<String, String>();
                        String defaultConfigName = System.getProperty("collection.configName", collection);
                        if (params != null) {
                            Iterator<String> iter = params.getParameterNamesIterator();
                            while (iter.hasNext()) {
                                String paramName = iter.next();
                                if (!paramName.startsWith(COLLECTION_PARAM_PREFIX)) continue;
                                collectionProps.put(paramName.substring(COLLECTION_PARAM_PREFIX.length()), params.get(paramName));
                            }
                            if (!collectionProps.containsKey(CONFIGNAME_PROP)) {
                                this.getConfName(collection, collectionPath, collectionProps);
                            }
                        } else if (System.getProperty("bootstrap_confdir") != null) {
                            log.info("Setting config for collection:" + collection + " to " + defaultConfigName);
                            Properties sysProps = System.getProperties();
                            for (String sprop : System.getProperties().stringPropertyNames()) {
                                if (!sprop.startsWith(COLLECTION_PARAM_PREFIX)) continue;
                                collectionProps.put(sprop.substring(COLLECTION_PARAM_PREFIX.length()), sysProps.getProperty(sprop));
                            }
                            if (!collectionProps.containsKey(CONFIGNAME_PROP)) {
                                collectionProps.put(CONFIGNAME_PROP, defaultConfigName);
                            }
                        } else if (Boolean.getBoolean("bootstrap_conf")) {
                            collectionProps.put(CONFIGNAME_PROP, cd.getCollectionName());
                        } else {
                            this.getConfName(collection, collectionPath, collectionProps);
                        }
                        ZkNodeProps zkProps = new ZkNodeProps(collectionProps);
                        this.zkClient.makePath(collectionPath, ZkStateReader.toJSON(zkProps), CreateMode.PERSISTENT, null, true);
                        this.zkClient.setData("/collections", (byte[])null, true);
                        break block16;
                    }
                    catch (KeeperException e) {
                        if (e.code() != KeeperException.Code.NODEEXISTS) {
                            throw e;
                        }
                        break block16;
                    }
                }
                log.info("Collection zkNode exists");
            }
            catch (KeeperException e) {
                if (e.code() == KeeperException.Code.NODEEXISTS) break block16;
                throw e;
            }
        }
    }

    private void getConfName(String collection, String collectionPath, Map<String, String> collectionProps) throws KeeperException, InterruptedException {
        ZkNodeProps cProps;
        int retry;
        log.info("Looking for collection configName");
        List<String> configNames = null;
        int retryLimt = 6;
        for (retry = 1; !(retry >= retryLimt || this.zkClient.exists(collectionPath, true).booleanValue() && (cProps = ZkNodeProps.load(this.zkClient.getData(collectionPath, null, null, true))).containsKey(CONFIGNAME_PROP)); ++retry) {
            try {
                configNames = this.zkClient.getChildren(CONFIGS_ZKNODE, null, true);
            }
            catch (KeeperException.NoNodeException e) {
                // empty catch block
            }
            if (configNames != null && configNames.size() == 1) {
                log.info("Only one config set found in zk - using it:" + configNames.get(0));
                collectionProps.put(CONFIGNAME_PROP, configNames.get(0));
                break;
            }
            if (configNames != null && configNames.contains(collection)) {
                log.info("Could not find explicit collection configName, but found config name matching collection name - using that set.");
                collectionProps.put(CONFIGNAME_PROP, collection);
                break;
            }
            log.info("Could not find collection configName - pausing for 3 seconds and trying again - try: " + retry);
            Thread.sleep(3000L);
        }
        if (retry == retryLimt) {
            log.error("Could not find configName for collection " + collection);
            throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "Could not find configName for collection " + collection + " found:" + configNames);
        }
    }

    public ZkStateReader getZkStateReader() {
        return this.zkStateReader;
    }

    private String doGetShardIdProcess(String coreName, CloudDescriptor descriptor) throws InterruptedException {
        String shardZkNodeName = this.getNodeName() + "_" + coreName;
        int retryCount = 120;
        while (retryCount-- > 0) {
            String shardId = this.zkStateReader.getCloudState().getShardId(shardZkNodeName);
            if (shardId != null) {
                return shardId;
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Could not get shard_id for core: " + coreName);
    }

    public static void uploadToZK(SolrZkClient zkClient, File dir, String zkPath) throws IOException, KeeperException, InterruptedException {
        File[] files = dir.listFiles();
        if (files == null) {
            throw new IllegalArgumentException("Illegal directory: " + dir);
        }
        for (File file : files) {
            if (file.getName().startsWith(".")) continue;
            if (!file.isDirectory()) {
                zkClient.makePath(zkPath + "/" + file.getName(), file, false, true);
                continue;
            }
            ZkController.uploadToZK(zkClient, file, zkPath + "/" + file.getName());
        }
    }

    private String getCoreNodeName(CoreDescriptor descriptor) {
        return this.getNodeName() + "_" + descriptor.getName();
    }

    public static void uploadConfigDir(SolrZkClient zkClient, File dir, String configName) throws IOException, KeeperException, InterruptedException {
        ZkController.uploadToZK(zkClient, dir, "/configs/" + configName);
    }

    public void preRegister(CoreDescriptor cd) throws KeeperException, InterruptedException {
        this.publish(cd, "down");
        String shardZkNodeName = this.getCoreNodeName(cd);
        if (cd.getCloudDescriptor().getShardId() == null && this.needsToBeAssignedShardId(cd, this.zkStateReader.getCloudState(), shardZkNodeName)) {
            String shardId;
            try {
                shardId = this.doGetShardIdProcess(cd.getName(), cd.getCloudDescriptor());
            }
            catch (InterruptedException e) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Interrupted");
            }
            cd.getCloudDescriptor().setShardId(shardId);
        }
    }

    private ZkCoreNodeProps waitForLeaderToSeeDownState(CoreDescriptor descriptor, String coreZkNodeName) {
        CloudDescriptor cloudDesc = descriptor.getCloudDescriptor();
        String collection = cloudDesc.getCollectionName();
        String shard = cloudDesc.getShardId();
        ZkCoreNodeProps leaderProps = null;
        int retries = 6;
        for (int i = 0; i < retries; ++i) {
            try {
                leaderProps = this.getLeaderProps(collection, shard);
                break;
            }
            catch (Exception e) {
                SolrException.log(log, "There was a problem finding the leader in zk", e);
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException e1) {
                    Thread.currentThread().interrupt();
                }
                if (i != retries - 1) continue;
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "There was a problem finding the leader in zk");
            }
        }
        String leaderBaseUrl = leaderProps.getBaseUrl();
        String leaderCoreName = leaderProps.getCoreName();
        String ourUrl = ZkCoreNodeProps.getCoreUrl(this.getBaseUrl(), descriptor.getName());
        boolean isLeader = leaderProps.getCoreUrl().equals(ourUrl);
        if (!isLeader && !this.SKIP_AUTO_RECOVERY) {
            HttpSolrServer server = null;
            server = new HttpSolrServer(leaderBaseUrl);
            server.setConnectionTimeout(45000);
            server.setSoTimeout(45000);
            CoreAdminRequest.WaitForState prepCmd = new CoreAdminRequest.WaitForState();
            prepCmd.setCoreName(leaderCoreName);
            prepCmd.setNodeName(this.getNodeName());
            prepCmd.setCoreNodeName(coreZkNodeName);
            prepCmd.setState("down");
            prepCmd.setPauseFor(0);
            retries = 6;
            for (int i = 0; i < retries; ++i) {
                try {
                    server.request(prepCmd);
                    break;
                }
                catch (Exception e) {
                    SolrException.log(log, "There was a problem making a request to the leader", e);
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException e1) {
                        Thread.currentThread().interrupt();
                    }
                    if (i != retries - 1) continue;
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "There was a problem making a request to the leader");
                }
            }
            server.shutdown();
        }
        return leaderProps;
    }

    public static void bootstrapConf(SolrZkClient zkClient, Config cfg, String solrHome) throws IOException, KeeperException, InterruptedException {
        NodeList nodes = (NodeList)cfg.evaluate("solr/cores/core", XPathConstants.NODESET);
        for (int i = 0; i < nodes.getLength(); ++i) {
            String confName;
            Node node = nodes.item(i);
            String rawName = DOMUtil.getAttr(node, "name", null);
            String instanceDir = DOMUtil.getAttr(node, "instanceDir", null);
            File idir = new File(instanceDir);
            if (!idir.isAbsolute()) {
                idir = new File(solrHome, instanceDir);
            }
            if ((confName = DOMUtil.getAttr(node, "collection", null)) == null) {
                confName = rawName;
            }
            ZkController.uploadConfigDir(zkClient, new File(idir, "conf"), confName);
        }
    }
}

