/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud;

import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.http.client.HttpClient;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.HttpClientUtil;
import org.apache.solr.client.solrj.impl.HttpSolrServer;
import org.apache.solr.client.solrj.request.CoreAdminRequest;
import org.apache.solr.cloud.CloudDescriptor;
import org.apache.solr.cloud.ZkController;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.CloudState;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.cloud.ZkCoreNodeProps;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.params.CoreAdminParams;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.SolrCore;
import org.apache.solr.handler.component.HttpShardHandlerFactory;
import org.apache.solr.handler.component.ShardHandler;
import org.apache.solr.handler.component.ShardRequest;
import org.apache.solr.handler.component.ShardResponse;
import org.apache.solr.update.PeerSync;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyncStrategy {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private final ShardHandler shardHandler = new HttpShardHandlerFactory().getShardHandler(client);
    private static final HttpClient client;

    public boolean sync(ZkController zkController, SolrCore core, ZkNodeProps leaderProps) {
        if (core.getUpdateHandler().getUpdateLog() == null) {
            this.log.error("No UpdateLog found - cannot sync");
            return false;
        }
        boolean success = this.syncReplicas(zkController, core, leaderProps);
        return success;
    }

    private boolean syncReplicas(ZkController zkController, SolrCore core, ZkNodeProps leaderProps) {
        boolean success = false;
        CloudDescriptor cloudDesc = core.getCoreDescriptor().getCloudDescriptor();
        String collection = cloudDesc.getCollectionName();
        String shardId = cloudDesc.getShardId();
        try {
            success = this.syncWithReplicas(zkController, core, leaderProps, collection, shardId);
        }
        catch (Exception e) {
            SolrException.log(this.log, "Sync Failed", e);
        }
        try {
            if (!success && !this.areAnyOtherReplicasActive(zkController, leaderProps, collection, shardId)) {
                success = true;
            }
            if (success) {
                this.syncToMe(zkController, collection, shardId, leaderProps);
            }
        }
        catch (Exception e) {
            SolrException.log(this.log, "Sync Failed", e);
        }
        return success;
    }

    private boolean areAnyOtherReplicasActive(ZkController zkController, ZkNodeProps leaderProps, String collection, String shardId) {
        CloudState cloudState = zkController.getZkStateReader().getCloudState();
        Map<String, Slice> slices = cloudState.getSlices(collection);
        Slice slice = slices.get(shardId);
        Map<String, ZkNodeProps> shards = slice.getShards();
        for (Map.Entry<String, ZkNodeProps> shard : shards.entrySet()) {
            String state = shard.getValue().get("state");
            if (!state.equals("active") || !cloudState.liveNodesContain(shard.getValue().get("node_name")) || new ZkCoreNodeProps(shard.getValue()).getCoreUrl().equals(new ZkCoreNodeProps(leaderProps).getCoreUrl())) continue;
            return true;
        }
        return false;
    }

    private boolean syncWithReplicas(ZkController zkController, SolrCore core, ZkNodeProps props, String collection, String shardId) throws MalformedURLException, SolrServerException, IOException {
        List<ZkCoreNodeProps> nodes = zkController.getZkStateReader().getReplicaProps(collection, shardId, props.get("node_name"), props.get("core"), "active");
        if (nodes == null) {
            return true;
        }
        ArrayList<String> syncWith = new ArrayList<String>();
        for (ZkCoreNodeProps node : nodes) {
            if (node.getNodeProps().keySet().contains("leader")) continue;
            syncWith.add(node.getCoreUrl());
        }
        PeerSync peerSync = new PeerSync(core, syncWith, core.getUpdateHandler().getUpdateLog().numRecordsToKeep);
        return peerSync.sync();
    }

    private void syncToMe(ZkController zkController, String collection, String shardId, ZkNodeProps leaderProps) throws MalformedURLException, SolrServerException, IOException {
        ShardResponse srsp;
        List<ZkCoreNodeProps> nodes = zkController.getZkStateReader().getReplicaProps(collection, shardId, leaderProps.get("node_name"), leaderProps.get("core"), "active");
        if (nodes == null) {
            return;
        }
        ZkCoreNodeProps zkLeader = new ZkCoreNodeProps(leaderProps);
        for (ZkCoreNodeProps node : nodes) {
            try {
                this.log.info("try and ask " + node.getCoreUrl() + " to sync");
                this.requestSync(zkLeader.getCoreUrl(), node.getCoreName());
            }
            catch (Exception e) {
                SolrException.log(this.log, "Error syncing replica to leader", e);
            }
        }
        while ((srsp = this.shardHandler.takeCompletedOrError()) != null) {
            boolean success = this.handleResponse(srsp);
            if (success) continue;
            try {
                this.log.info("Sync failed - asking replica to recover.");
                CoreAdminRequest.RequestRecovery recoverRequestCmd = new CoreAdminRequest.RequestRecovery();
                recoverRequestCmd.setAction(CoreAdminParams.CoreAdminAction.REQUESTRECOVERY);
                recoverRequestCmd.setCoreName(((SyncShardRequest)srsp.getShardRequest()).coreName);
                HttpSolrServer server = new HttpSolrServer(zkLeader.getBaseUrl());
                server.request(recoverRequestCmd);
            }
            catch (Exception e) {
                this.log.info("Could not tell a replica to recover", e);
            }
            this.shardHandler.cancelAll();
            break;
        }
    }

    private boolean handleResponse(ShardResponse srsp) {
        NamedList<Object> response = srsp.getSolrResponse().getResponse();
        if (response == null) {
            return false;
        }
        boolean success = (Boolean)response.get("sync");
        return success;
    }

    private void requestSync(String replica, String coreName) {
        SyncShardRequest sreq = new SyncShardRequest();
        sreq.coreName = coreName;
        sreq.purpose = 1;
        if (replica.startsWith("http://")) {
            replica = replica.substring(7);
        }
        sreq.shards = new String[]{replica};
        sreq.actualShards = sreq.shards;
        sreq.params = new ModifiableSolrParams();
        sreq.params.set("qt", "/get");
        sreq.params.set("distrib", false);
        sreq.params.set("getVersions", Integer.toString(100));
        sreq.params.set("sync", replica);
        this.shardHandler.submit(sreq, replica, sreq.params);
    }

    public static ModifiableSolrParams params(String ... params) {
        ModifiableSolrParams msp = new ModifiableSolrParams();
        for (int i = 0; i < params.length; i += 2) {
            msp.add(params[i], params[i + 1]);
        }
        return msp;
    }

    static {
        ModifiableSolrParams params = new ModifiableSolrParams();
        params.set("maxConnections", 10000);
        params.set("maxConnectionsPerHost", 20);
        params.set("connTimeout", 30000);
        params.set("socketTimeout", 30000);
        params.set("retry", false);
        client = HttpClientUtil.createClient(params);
    }

    private static class SyncShardRequest
    extends ShardRequest {
        String coreName;

        private SyncShardRequest() {
        }
    }
}

