/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud;

import java.io.IOException;
import org.apache.solr.cloud.ElectionContext;
import org.apache.solr.cloud.LeaderElector;
import org.apache.solr.cloud.Overseer;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;

class ShardLeaderElectionContextBase
extends ElectionContext {
    protected final SolrZkClient zkClient;
    protected String shardId;
    protected String collection;
    protected LeaderElector leaderElector;

    public ShardLeaderElectionContextBase(LeaderElector leaderElector, String shardId, String collection, String shardZkNodeName, ZkNodeProps props, ZkStateReader zkStateReader) {
        super(shardZkNodeName, "/collections/" + collection + "/leader_elect/" + shardId, ZkStateReader.getShardLeadersPath(collection, shardId), props, zkStateReader.getZkClient());
        this.leaderElector = leaderElector;
        this.zkClient = zkStateReader.getZkClient();
        this.shardId = shardId;
        this.collection = collection;
    }

    @Override
    void runLeaderProcess(boolean weAreReplacement) throws KeeperException, InterruptedException, IOException {
        try {
            this.zkClient.makePath(this.leaderPath, this.leaderProps == null ? null : ZkStateReader.toJSON(this.leaderProps), CreateMode.EPHEMERAL, true);
        }
        catch (KeeperException.NodeExistsException e) {
            this.zkClient.delete(this.leaderPath, -1, true);
            this.zkClient.makePath(this.leaderPath, this.leaderProps == null ? null : ZkStateReader.toJSON(this.leaderProps), CreateMode.EPHEMERAL, true);
        }
        ZkNodeProps m = new ZkNodeProps("operation", "leader", "shard", this.shardId, "collection", this.collection, "base_url", this.leaderProps.getProperties().get("base_url"), "core", this.leaderProps.getProperties().get("core"));
        Overseer.getInQueue(this.zkClient).offer(ZkStateReader.toJSON(m));
    }
}

