/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analysis;

import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.core.TypeTokenFilter;
import org.apache.lucene.analysis.util.InitializationException;
import org.apache.lucene.analysis.util.ResourceLoader;
import org.apache.lucene.analysis.util.ResourceLoaderAware;
import org.apache.lucene.analysis.util.TokenFilterFactory;
import org.apache.solr.common.util.StrUtils;

public class TypeTokenFilterFactory
extends TokenFilterFactory
implements ResourceLoaderAware {
    private boolean useWhitelist;
    private Set<String> stopTypes;
    private boolean enablePositionIncrements;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void inform(ResourceLoader loader) {
        String stopTypesFiles = (String)this.args.get("types");
        this.enablePositionIncrements = this.getBoolean("enablePositionIncrements", false);
        this.useWhitelist = this.getBoolean("useWhitelist", false);
        if (stopTypesFiles == null) throw new InitializationException("Missing required parameter: types.");
        try {
            List<String> files = StrUtils.splitFileNames(stopTypesFiles);
            if (files.size() <= 0) return;
            this.stopTypes = new HashSet<String>();
            for (String file : files) {
                List<String> typesLines = loader.getLines(file.trim());
                this.stopTypes.addAll(typesLines);
            }
            return;
        }
        catch (IOException e) {
            throw new InitializationException("IOException thrown while loading types", e);
        }
    }

    public boolean isEnablePositionIncrements() {
        return this.enablePositionIncrements;
    }

    public Set<String> getStopTypes() {
        return this.stopTypes;
    }

    @Override
    public TokenStream create(TokenStream input) {
        return new TypeTokenFilter(this.enablePositionIncrements, input, this.stopTypes, this.useWhitelist);
    }
}

