/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analysis;

import java.io.IOException;
import java.io.Reader;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.CharReader;
import org.apache.lucene.analysis.CharStream;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.util.AbstractAnalysisFactory;
import org.apache.lucene.analysis.util.CharFilterFactory;
import org.apache.lucene.analysis.util.TokenFilterFactory;
import org.apache.lucene.analysis.util.TokenizerFactory;
import org.apache.solr.analysis.SolrAnalyzer;

public final class TokenizerChain
extends SolrAnalyzer {
    private final CharFilterFactory[] charFilters;
    private final TokenizerFactory tokenizer;
    private final TokenFilterFactory[] filters;

    public TokenizerChain(TokenizerFactory tokenizer, TokenFilterFactory[] filters) {
        this(null, tokenizer, filters);
    }

    public TokenizerChain(CharFilterFactory[] charFilters, TokenizerFactory tokenizer, TokenFilterFactory[] filters) {
        this.charFilters = charFilters;
        this.tokenizer = tokenizer;
        this.filters = filters;
    }

    public CharFilterFactory[] getCharFilterFactories() {
        return this.charFilters;
    }

    public TokenizerFactory getTokenizerFactory() {
        return this.tokenizer;
    }

    public TokenFilterFactory[] getTokenFilterFactories() {
        return this.filters;
    }

    @Override
    public Reader initReader(String fieldName, Reader reader) {
        if (this.charFilters != null && this.charFilters.length > 0) {
            CharStream cs = CharReader.get(reader);
            for (CharFilterFactory charFilter : this.charFilters) {
                cs = charFilter.create(cs);
            }
            reader = cs;
        }
        return reader;
    }

    @Override
    protected Analyzer.TokenStreamComponents createComponents(String fieldName, Reader aReader) {
        Tokenizer tk;
        TokenStream ts = tk = this.tokenizer.create(this.initReader(fieldName, aReader));
        for (TokenFilterFactory filter : this.filters) {
            ts = filter.create(ts);
        }
        return new SolrTokenStreamComponents(tk, ts);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("TokenizerChain(");
        for (CharFilterFactory charFilterFactory : this.charFilters) {
            sb.append(charFilterFactory);
            sb.append(", ");
        }
        sb.append(this.tokenizer);
        for (AbstractAnalysisFactory abstractAnalysisFactory : this.filters) {
            sb.append(", ");
            sb.append(abstractAnalysisFactory);
        }
        sb.append(')');
        return sb.toString();
    }

    class SolrTokenStreamComponents
    extends Analyzer.TokenStreamComponents {
        public SolrTokenStreamComponents(Tokenizer source, TokenStream result) {
            super(source, result);
        }

        @Override
        protected void reset(Reader reader) throws IOException {
            Reader r = TokenizerChain.this.initReader(null, reader);
            super.reset(r);
        }
    }
}

