/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analysis;

import java.util.Map;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.util.InitializationException;
import org.apache.lucene.analysis.util.ResourceLoader;
import org.apache.lucene.analysis.util.ResourceLoaderAware;
import org.apache.lucene.analysis.util.TokenFilterFactory;
import org.apache.lucene.util.Version;
import org.apache.solr.analysis.FSTSynonymFilterFactory;
import org.apache.solr.analysis.SlowSynonymFilterFactory;

public class SynonymFilterFactory
extends TokenFilterFactory
implements ResourceLoaderAware {
    private TokenFilterFactory delegator;

    @Override
    public void init(Map<String, String> args) {
        super.init(args);
        this.assureMatchVersion();
        if (this.luceneMatchVersion.onOrAfter(Version.LUCENE_34)) {
            this.delegator = new FSTSynonymFilterFactory();
        } else {
            if (args.containsKey("format") && !args.get("format").equals("solr")) {
                throw new InitializationException("You must specify luceneMatchVersion >= 3.4 to use alternate synonyms formats");
            }
            this.delegator = new SlowSynonymFilterFactory();
        }
        this.delegator.init(args);
    }

    @Override
    public TokenStream create(TokenStream input) {
        assert (this.delegator != null) : "init() was not called!";
        return this.delegator.create(input);
    }

    @Override
    public void inform(ResourceLoader loader) {
        assert (this.delegator != null) : "init() was not called!";
        ((ResourceLoaderAware)((Object)this.delegator)).inform(loader);
    }
}

