/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analysis;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.util.InitializationException;
import org.apache.lucene.analysis.util.ResourceLoader;
import org.apache.lucene.analysis.util.ResourceLoaderAware;
import org.apache.lucene.analysis.util.TokenFilterFactory;
import org.apache.lucene.analysis.util.TokenizerFactory;
import org.apache.solr.analysis.SlowSynonymFilter;
import org.apache.solr.analysis.SlowSynonymMap;
import org.apache.solr.common.util.StrUtils;

@Deprecated
final class SlowSynonymFilterFactory
extends TokenFilterFactory
implements ResourceLoaderAware {
    private SlowSynonymMap synMap;

    SlowSynonymFilterFactory() {
    }

    @Override
    public void inform(ResourceLoader loader) {
        String synonyms = (String)this.args.get("synonyms");
        if (synonyms == null) {
            throw new InitializationException("Missing required argument 'synonyms'.");
        }
        boolean ignoreCase = this.getBoolean("ignoreCase", false);
        boolean expand = this.getBoolean("expand", true);
        String tf = (String)this.args.get("tokenizerFactory");
        TokenizerFactory tokFactory = null;
        if (tf != null) {
            tokFactory = this.loadTokenizerFactory(loader, tf);
        }
        Iterable<String> wlist = this.loadRules(synonyms, loader);
        this.synMap = new SlowSynonymMap(ignoreCase);
        SlowSynonymFilterFactory.parseRules(wlist, this.synMap, "=>", ",", expand, tokFactory);
    }

    protected Iterable<String> loadRules(String synonyms, ResourceLoader loader) {
        List<String> wlist = null;
        try {
            File synonymFile = new File(synonyms);
            if (synonymFile.exists()) {
                wlist = loader.getLines(synonyms);
            } else {
                List<String> files = StrUtils.splitFileNames(synonyms);
                wlist = new ArrayList<String>();
                for (String file : files) {
                    List<String> lines = loader.getLines(file.trim());
                    wlist.addAll(lines);
                }
            }
        }
        catch (IOException e) {
            throw new InitializationException("IOException thrown while loading synonym rules", e);
        }
        return wlist;
    }

    static void parseRules(Iterable<String> rules, SlowSynonymMap map, String mappingSep, String synSep, boolean expansion, TokenizerFactory tokFactory) {
        int count = 0;
        for (String rule : rules) {
            List<List<String>> target;
            List<List<String>> source;
            List<String> mapping = StrUtils.splitSmart(rule, mappingSep, false);
            if (mapping.size() > 2) {
                throw new InitializationException("Invalid Synonym Rule:" + rule);
            }
            if (mapping.size() == 2) {
                source = SlowSynonymFilterFactory.getSynList(mapping.get(0), synSep, tokFactory);
                target = SlowSynonymFilterFactory.getSynList(mapping.get(1), synSep, tokFactory);
            } else {
                source = SlowSynonymFilterFactory.getSynList(mapping.get(0), synSep, tokFactory);
                if (expansion) {
                    target = source;
                } else {
                    target = new ArrayList<List<String>>(1);
                    target.add(source.get(0));
                }
            }
            boolean includeOrig = false;
            for (List<String> fromToks : source) {
                ++count;
                for (List<String> toToks : target) {
                    map.add(fromToks, SlowSynonymMap.makeTokens(toToks), includeOrig, true);
                }
            }
        }
    }

    private static List<List<String>> getSynList(String str, String separator, TokenizerFactory tokFactory) {
        List<String> strList = StrUtils.splitSmart(str, separator, false);
        ArrayList<List<String>> synList = new ArrayList<List<String>>();
        for (String toks : strList) {
            List<String> tokList = tokFactory == null ? StrUtils.splitWS(toks, true) : SlowSynonymFilterFactory.splitByTokenizer(toks, tokFactory);
            synList.add(tokList);
        }
        return synList;
    }

    private static List<String> splitByTokenizer(String source, TokenizerFactory tokFactory) {
        StringReader reader = new StringReader(source);
        TokenStream ts = SlowSynonymFilterFactory.loadTokenizer(tokFactory, reader);
        ArrayList<String> tokList = new ArrayList<String>();
        try {
            CharTermAttribute termAtt = ts.addAttribute(CharTermAttribute.class);
            while (ts.incrementToken()) {
                if (termAtt.length() <= 0) continue;
                tokList.add(termAtt.toString());
            }
        }
        catch (IOException e) {
            throw new InitializationException("IOException thrown while tokenizing source", e);
        }
        finally {
            reader.close();
        }
        return tokList;
    }

    private TokenizerFactory loadTokenizerFactory(ResourceLoader loader, String cname) {
        TokenizerFactory tokFactory = loader.newInstance(cname, TokenizerFactory.class, new String[0]);
        tokFactory.setLuceneMatchVersion(this.luceneMatchVersion);
        tokFactory.init(this.args);
        if (tokFactory instanceof ResourceLoaderAware) {
            ((ResourceLoaderAware)((Object)tokFactory)).inform(loader);
        }
        return tokFactory;
    }

    private static TokenStream loadTokenizer(TokenizerFactory tokFactory, Reader reader) {
        return tokFactory.create(reader);
    }

    public SlowSynonymMap getSynonymMap() {
        return this.synMap;
    }

    @Override
    public SlowSynonymFilter create(TokenStream input) {
        return new SlowSynonymFilter(input, this.synMap);
    }
}

