/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analysis;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.compound.DictionaryCompoundWordTokenFilter;
import org.apache.lucene.analysis.util.CharArraySet;
import org.apache.lucene.analysis.util.InitializationException;
import org.apache.lucene.analysis.util.ResourceLoader;
import org.apache.lucene.analysis.util.ResourceLoaderAware;
import org.apache.lucene.analysis.util.TokenFilterFactory;

public class DictionaryCompoundWordTokenFilterFactory
extends TokenFilterFactory
implements ResourceLoaderAware {
    private CharArraySet dictionary;
    private String dictFile;
    private int minWordSize;
    private int minSubwordSize;
    private int maxSubwordSize;
    private boolean onlyLongestMatch;

    @Override
    public void init(Map<String, String> args) {
        super.init(args);
        this.assureMatchVersion();
        this.dictFile = args.get("dictionary");
        if (null == this.dictFile) {
            throw new InitializationException("Missing required parameter: dictionary");
        }
        this.minWordSize = this.getInt("minWordSize", 5);
        this.minSubwordSize = this.getInt("minSubwordSize", 2);
        this.maxSubwordSize = this.getInt("maxSubwordSize", 15);
        this.onlyLongestMatch = this.getBoolean("onlyLongestMatch", true);
    }

    @Override
    public void inform(ResourceLoader loader) {
        try {
            this.dictionary = super.getWordSet(loader, this.dictFile, false);
        }
        catch (IOException e) {
            throw new InitializationException("IOException thrown while loading dictionary", e);
        }
    }

    @Override
    public DictionaryCompoundWordTokenFilter create(TokenStream input) {
        return new DictionaryCompoundWordTokenFilter(this.luceneMatchVersion, input, this.dictionary, this.minWordSize, this.minSubwordSize, this.maxSubwordSize, this.onlyLongestMatch);
    }
}

