/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analysis;

import java.io.IOException;
import java.io.InputStream;
import java.text.Collator;
import java.text.ParseException;
import java.text.RuleBasedCollator;
import java.util.Locale;
import org.apache.commons.io.IOUtils;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.util.AbstractAnalysisFactory;
import org.apache.lucene.analysis.util.InitializationException;
import org.apache.lucene.analysis.util.MultiTermAwareComponent;
import org.apache.lucene.analysis.util.ResourceLoader;
import org.apache.lucene.analysis.util.ResourceLoaderAware;
import org.apache.lucene.analysis.util.TokenFilterFactory;
import org.apache.lucene.collation.CollationKeyFilter;

@Deprecated
public class CollationKeyFilterFactory
extends TokenFilterFactory
implements MultiTermAwareComponent,
ResourceLoaderAware {
    private Collator collator;

    @Override
    public void inform(ResourceLoader loader) {
        String custom = (String)this.args.get("custom");
        String language = (String)this.args.get("language");
        String country = (String)this.args.get("country");
        String variant = (String)this.args.get("variant");
        String strength = (String)this.args.get("strength");
        String decomposition = (String)this.args.get("decomposition");
        if (custom == null && language == null) {
            throw new InitializationException("Either custom or language is required.");
        }
        if (custom != null && (language != null || country != null || variant != null)) {
            throw new InitializationException("Cannot specify both language and custom. To tailor rules for a built-in language, see the javadocs for RuleBasedCollator. Then save the entire customized ruleset to a file, and use with the custom parameter");
        }
        this.collator = language != null ? this.createFromLocale(language, country, variant) : this.createFromRules(custom, loader);
        if (strength != null) {
            if (strength.equalsIgnoreCase("primary")) {
                this.collator.setStrength(0);
            } else if (strength.equalsIgnoreCase("secondary")) {
                this.collator.setStrength(1);
            } else if (strength.equalsIgnoreCase("tertiary")) {
                this.collator.setStrength(2);
            } else if (strength.equalsIgnoreCase("identical")) {
                this.collator.setStrength(3);
            } else {
                throw new InitializationException("Invalid strength: " + strength);
            }
        }
        if (decomposition != null) {
            if (decomposition.equalsIgnoreCase("no")) {
                this.collator.setDecomposition(0);
            } else if (decomposition.equalsIgnoreCase("canonical")) {
                this.collator.setDecomposition(1);
            } else if (decomposition.equalsIgnoreCase("full")) {
                this.collator.setDecomposition(2);
            } else {
                throw new InitializationException("Invalid decomposition: " + decomposition);
            }
        }
    }

    @Override
    public TokenStream create(TokenStream input) {
        return new CollationKeyFilter(input, this.collator);
    }

    private Collator createFromLocale(String language, String country, String variant) {
        if (language != null && country == null && variant != null) {
            throw new InitializationException("To specify variant, country is required");
        }
        Locale locale = language != null && country != null && variant != null ? new Locale(language, country, variant) : (language != null && country != null ? new Locale(language, country) : new Locale(language));
        return Collator.getInstance(locale);
    }

    private Collator createFromRules(String fileName, ResourceLoader loader) {
        InputStream input = null;
        try {
            input = loader.openResource(fileName);
            String rules = IOUtils.toString((InputStream)input, (String)"UTF-8");
            RuleBasedCollator ruleBasedCollator = new RuleBasedCollator(rules);
            return ruleBasedCollator;
        }
        catch (IOException e) {
            throw new InitializationException("IOException thrown while loading rules", e);
        }
        catch (ParseException e) {
            throw new InitializationException("ParseException thrown while parsing rules", e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)input);
        }
    }

    @Override
    public AbstractAnalysisFactory getMultiTermComponent() {
        return this;
    }
}

