/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.packed;

import java.io.Closeable;
import java.io.IOException;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.packed.Direct16;
import org.apache.lucene.util.packed.Direct32;
import org.apache.lucene.util.packed.Direct64;
import org.apache.lucene.util.packed.Direct8;
import org.apache.lucene.util.packed.DirectPacked64SingleBlockReader;
import org.apache.lucene.util.packed.DirectPackedReader;
import org.apache.lucene.util.packed.Packed16ThreeBlocks;
import org.apache.lucene.util.packed.Packed64;
import org.apache.lucene.util.packed.Packed64SingleBlock;
import org.apache.lucene.util.packed.Packed64SingleBlockReaderIterator;
import org.apache.lucene.util.packed.Packed64SingleBlockWriter;
import org.apache.lucene.util.packed.Packed8ThreeBlocks;
import org.apache.lucene.util.packed.PackedReaderIterator;
import org.apache.lucene.util.packed.PackedWriter;

public class PackedInts {
    public static final float FASTEST = 7.0f;
    public static final float FAST = 0.5f;
    public static final float DEFAULT = 0.2f;
    public static final float COMPACT = 0.0f;
    public static final int DEFAULT_BUFFER_SIZE = 1024;
    private static final String CODEC_NAME = "PackedInts";
    private static final int VERSION_START = 0;
    private static final int VERSION_CURRENT = 0;
    static final int PACKED = 0;
    static final int PACKED_SINGLE_BLOCK = 1;

    public static Reader getReader(DataInput in) throws IOException {
        CodecUtil.checkHeader(in, CODEC_NAME, 0, 0);
        int bitsPerValue = in.readVInt();
        assert (bitsPerValue > 0 && bitsPerValue <= 64) : "bitsPerValue=" + bitsPerValue;
        int valueCount = in.readVInt();
        int format = in.readVInt();
        switch (format) {
            case 0: {
                switch (bitsPerValue) {
                    case 8: {
                        return new Direct8(in, valueCount);
                    }
                    case 16: {
                        return new Direct16(in, valueCount);
                    }
                    case 24: {
                        return new Packed8ThreeBlocks(in, valueCount);
                    }
                    case 32: {
                        return new Direct32(in, valueCount);
                    }
                    case 48: {
                        return new Packed16ThreeBlocks(in, valueCount);
                    }
                    case 64: {
                        return new Direct64(in, valueCount);
                    }
                }
                return new Packed64(in, valueCount, bitsPerValue);
            }
            case 1: {
                return Packed64SingleBlock.create(in, valueCount, bitsPerValue);
            }
        }
        throw new AssertionError((Object)("Unknwown Writer format: " + format));
    }

    public static ReaderIterator getReaderIterator(IndexInput in) throws IOException {
        CodecUtil.checkHeader(in, CODEC_NAME, 0, 0);
        int bitsPerValue = in.readVInt();
        assert (bitsPerValue > 0 && bitsPerValue <= 64) : "bitsPerValue=" + bitsPerValue;
        int valueCount = in.readVInt();
        int format = in.readVInt();
        switch (format) {
            case 0: {
                return new PackedReaderIterator(valueCount, bitsPerValue, in);
            }
            case 1: {
                return new Packed64SingleBlockReaderIterator(valueCount, bitsPerValue, in);
            }
        }
        throw new AssertionError((Object)("Unknwown Writer format: " + format));
    }

    public static Reader getDirectReader(IndexInput in) throws IOException {
        CodecUtil.checkHeader(in, CODEC_NAME, 0, 0);
        int bitsPerValue = in.readVInt();
        assert (bitsPerValue > 0 && bitsPerValue <= 64) : "bitsPerValue=" + bitsPerValue;
        int valueCount = in.readVInt();
        int format = in.readVInt();
        switch (format) {
            case 0: {
                return new DirectPackedReader(bitsPerValue, valueCount, in);
            }
            case 1: {
                return new DirectPacked64SingleBlockReader(bitsPerValue, valueCount, in);
            }
        }
        throw new AssertionError((Object)("Unknwown Writer format: " + format));
    }

    public static Mutable getMutable(int valueCount, int bitsPerValue, float acceptableOverheadRatio) {
        acceptableOverheadRatio = Math.max(0.0f, acceptableOverheadRatio);
        acceptableOverheadRatio = Math.min(7.0f, acceptableOverheadRatio);
        float acceptableOverheadPerValue = acceptableOverheadRatio * (float)bitsPerValue;
        int maxBitsPerValue = bitsPerValue + (int)acceptableOverheadPerValue;
        if (bitsPerValue <= 8 && maxBitsPerValue >= 8) {
            return new Direct8(valueCount);
        }
        if (bitsPerValue <= 16 && maxBitsPerValue >= 16) {
            return new Direct16(valueCount);
        }
        if (bitsPerValue <= 32 && maxBitsPerValue >= 32) {
            return new Direct32(valueCount);
        }
        if (bitsPerValue <= 64 && maxBitsPerValue >= 64) {
            return new Direct64(valueCount);
        }
        if (valueCount <= 0x2AAAAAAA && bitsPerValue <= 24 && maxBitsPerValue >= 24) {
            return new Packed8ThreeBlocks(valueCount);
        }
        if (valueCount <= 0x2AAAAAAA && bitsPerValue <= 48 && maxBitsPerValue >= 48) {
            return new Packed16ThreeBlocks(valueCount);
        }
        for (int bpv = bitsPerValue; bpv <= maxBitsPerValue; ++bpv) {
            float acceptableOverhead;
            float overhead;
            if (!Packed64SingleBlock.isSupported(bpv) || !((overhead = Packed64SingleBlock.overheadPerValue(bpv)) <= (acceptableOverhead = acceptableOverheadPerValue + (float)bitsPerValue - (float)bpv))) continue;
            return Packed64SingleBlock.create(valueCount, bpv);
        }
        return new Packed64(valueCount, bitsPerValue);
    }

    public static Writer getWriter(DataOutput out, int valueCount, int bitsPerValue, float acceptableOverheadRatio) throws IOException {
        acceptableOverheadRatio = Math.max(0.0f, acceptableOverheadRatio);
        acceptableOverheadRatio = Math.min(7.0f, acceptableOverheadRatio);
        float acceptableOverheadPerValue = acceptableOverheadRatio * (float)bitsPerValue;
        int maxBitsPerValue = bitsPerValue + (int)acceptableOverheadPerValue;
        if (bitsPerValue <= 8 && maxBitsPerValue >= 8) {
            return PackedInts.getWriterByFormat(out, valueCount, 8, 0);
        }
        if (bitsPerValue <= 16 && maxBitsPerValue >= 16) {
            return PackedInts.getWriterByFormat(out, valueCount, 16, 0);
        }
        if (bitsPerValue <= 32 && maxBitsPerValue >= 32) {
            return PackedInts.getWriterByFormat(out, valueCount, 32, 0);
        }
        if (bitsPerValue <= 64 && maxBitsPerValue >= 64) {
            return PackedInts.getWriterByFormat(out, valueCount, 64, 0);
        }
        if (valueCount <= 0x2AAAAAAA && bitsPerValue <= 24 && maxBitsPerValue >= 24) {
            return PackedInts.getWriterByFormat(out, valueCount, 24, 0);
        }
        if (valueCount <= 0x2AAAAAAA && bitsPerValue <= 48 && maxBitsPerValue >= 48) {
            return PackedInts.getWriterByFormat(out, valueCount, 48, 0);
        }
        for (int bpv = bitsPerValue; bpv <= maxBitsPerValue; ++bpv) {
            float acceptableOverhead;
            float overhead;
            if (!Packed64SingleBlock.isSupported(bpv) || !((overhead = Packed64SingleBlock.overheadPerValue(bpv)) <= (acceptableOverhead = acceptableOverheadPerValue + (float)bitsPerValue - (float)bpv))) continue;
            return PackedInts.getWriterByFormat(out, valueCount, bpv, 1);
        }
        return PackedInts.getWriterByFormat(out, valueCount, bitsPerValue, 0);
    }

    private static Writer getWriterByFormat(DataOutput out, int valueCount, int bitsPerValue, int format) throws IOException {
        switch (format) {
            case 0: {
                return new PackedWriter(out, valueCount, bitsPerValue);
            }
            case 1: {
                return new Packed64SingleBlockWriter(out, valueCount, bitsPerValue);
            }
        }
        throw new IllegalArgumentException("Unknown format " + format);
    }

    public static int bitsRequired(long maxValue) {
        if (maxValue < 0L) {
            throw new IllegalArgumentException("maxValue must be non-negative (got: " + maxValue + ")");
        }
        return Math.max(1, 64 - Long.numberOfLeadingZeros(maxValue));
    }

    public static long maxValue(int bitsPerValue) {
        return bitsPerValue == 64 ? Long.MAX_VALUE : -1L << bitsPerValue ^ 0xFFFFFFFFFFFFFFFFL;
    }

    public static void copy(Reader src, int srcPos, Mutable dest, int destPos, int len, int mem) {
        assert (srcPos + len <= src.size());
        assert (destPos + len <= dest.size());
        int capacity = mem >>> 3;
        if (capacity == 0) {
            for (int i = 0; i < len; ++i) {
                dest.set(destPos++, src.get(srcPos++));
            }
        } else {
            long[] buf = new long[Math.min(capacity, len)];
            int remaining = 0;
            while (len > 0) {
                int read = src.get(srcPos, buf, remaining, Math.min(len, buf.length - remaining));
                assert (read > 0);
                srcPos += read;
                len -= read;
                int written = dest.set(destPos, buf, 0, remaining += read);
                assert (written > 0);
                destPos += written;
                if (written < remaining) {
                    System.arraycopy(buf, written, buf, 0, remaining - written);
                }
                remaining -= written;
            }
            while (remaining > 0) {
                int written = dest.set(destPos, buf, 0, remaining);
                remaining -= written;
            }
        }
    }

    public static abstract class Writer {
        protected final DataOutput out;
        protected final int bitsPerValue;
        protected final int valueCount;

        protected Writer(DataOutput out, int valueCount, int bitsPerValue) throws IOException {
            assert (bitsPerValue <= 64);
            this.out = out;
            this.valueCount = valueCount;
            this.bitsPerValue = bitsPerValue;
            CodecUtil.writeHeader(out, PackedInts.CODEC_NAME, 0);
            out.writeVInt(bitsPerValue);
            out.writeVInt(valueCount);
            out.writeVInt(this.getFormat());
        }

        protected abstract int getFormat();

        public abstract void add(long var1) throws IOException;

        public abstract void finish() throws IOException;
    }

    public static abstract class MutableImpl
    extends ReaderImpl
    implements Mutable {
        protected MutableImpl(int valueCount, int bitsPerValue) {
            super(valueCount, bitsPerValue);
        }

        @Override
        public int set(int index, long[] arr, int off, int len) {
            assert (len > 0) : "len must be > 0 (got " + len + ")";
            assert (index >= 0 && index < this.valueCount);
            len = Math.min(len, this.valueCount - index);
            assert (off + len <= arr.length);
            int i = index;
            int o = off;
            int end = index + len;
            while (i < end) {
                this.set(i, arr[o]);
                ++i;
                ++o;
            }
            return len;
        }

        @Override
        public void fill(int fromIndex, int toIndex, long val) {
            assert (val <= PackedInts.maxValue(this.bitsPerValue));
            assert (fromIndex <= toIndex);
            for (int i = fromIndex; i < toIndex; ++i) {
                this.set(i, val);
            }
        }

        protected int getFormat() {
            return 0;
        }

        @Override
        public void save(DataOutput out) throws IOException {
            Writer writer = PackedInts.getWriterByFormat(out, this.valueCount, this.bitsPerValue, this.getFormat());
            for (int i = 0; i < this.valueCount; ++i) {
                writer.add(this.get(i));
            }
            writer.finish();
        }
    }

    public static abstract class ReaderImpl
    implements Reader {
        protected final int bitsPerValue;
        protected final int valueCount;

        protected ReaderImpl(int valueCount, int bitsPerValue) {
            this.bitsPerValue = bitsPerValue;
            assert (bitsPerValue > 0 && bitsPerValue <= 64) : "bitsPerValue=" + bitsPerValue;
            this.valueCount = valueCount;
        }

        @Override
        public int getBitsPerValue() {
            return this.bitsPerValue;
        }

        @Override
        public int size() {
            return this.valueCount;
        }

        @Override
        public Object getArray() {
            return null;
        }

        @Override
        public boolean hasArray() {
            return false;
        }

        @Override
        public int get(int index, long[] arr, int off, int len) {
            assert (len > 0) : "len must be > 0 (got " + len + ")";
            assert (index >= 0 && index < this.valueCount);
            assert (off + len <= arr.length);
            int gets = Math.min(this.valueCount - index, len);
            int i = index;
            int o = off;
            int end = index + gets;
            while (i < end) {
                arr[o] = this.get(i);
                ++i;
                ++o;
            }
            return gets;
        }
    }

    public static interface Mutable
    extends Reader {
        public void set(int var1, long var2);

        public int set(int var1, long[] var2, int var3, int var4);

        public void fill(int var1, int var2, long var3);

        public void clear();

        public void save(DataOutput var1) throws IOException;
    }

    static abstract class ReaderIteratorImpl
    implements ReaderIterator {
        protected final IndexInput in;
        protected final int bitsPerValue;
        protected final int valueCount;

        protected ReaderIteratorImpl(int valueCount, int bitsPerValue, IndexInput in) {
            this.in = in;
            this.bitsPerValue = bitsPerValue;
            this.valueCount = valueCount;
        }

        @Override
        public int getBitsPerValue() {
            return this.bitsPerValue;
        }

        @Override
        public int size() {
            return this.valueCount;
        }

        @Override
        public void close() throws IOException {
            this.in.close();
        }
    }

    public static interface ReaderIterator
    extends Closeable {
        public long next() throws IOException;

        public int getBitsPerValue();

        public int size();

        public int ord();

        public long advance(int var1) throws IOException;
    }

    public static interface Reader {
        public long get(int var1);

        public int get(int var1, long[] var2, int var3, int var4);

        public int getBitsPerValue();

        public int size();

        public long ramBytesUsed();

        public Object getArray();

        public boolean hasArray();
    }
}

