/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.packed;

import java.io.IOException;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.util.packed.Packed64SingleBlock;
import org.apache.lucene.util.packed.PackedInts;

final class Packed64SingleBlockWriter
extends PackedInts.Writer {
    private long pending;
    private int shift;
    private int written;

    Packed64SingleBlockWriter(DataOutput out, int valueCount, int bitsPerValue) throws IOException {
        super(out, valueCount, bitsPerValue);
        assert (Packed64SingleBlock.isSupported(bitsPerValue)) : bitsPerValue + " is not supported";
        this.pending = 0L;
        this.shift = 0;
        this.written = 0;
    }

    @Override
    protected int getFormat() {
        return 1;
    }

    @Override
    public void add(long v) throws IOException {
        assert (v <= PackedInts.maxValue(this.bitsPerValue)) : "v=" + v + " maxValue=" + PackedInts.maxValue(this.bitsPerValue);
        assert (v >= 0L);
        if (this.shift + this.bitsPerValue > 64) {
            this.out.writeLong(this.pending);
            this.pending = 0L;
            this.shift = 0;
        }
        this.pending |= v << this.shift;
        this.shift += this.bitsPerValue;
        ++this.written;
    }

    @Override
    public void finish() throws IOException {
        while (this.written < this.valueCount) {
            this.add(0L);
        }
        if (this.shift > 0) {
            this.out.writeLong(this.pending);
        }
    }

    public String toString() {
        return "Packed64SingleBlockWriter(written " + this.written + "/" + this.valueCount + " with " + this.bitsPerValue + " bits/value)";
    }
}

