/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.packed;

import java.io.IOException;
import java.util.Arrays;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.packed.PackedInts;

final class Packed16ThreeBlocks
extends PackedInts.MutableImpl {
    public static final int MAX_SIZE = 0x2AAAAAAA;
    private final short[] blocks;

    Packed16ThreeBlocks(int valueCount) {
        super(valueCount, 48);
        if (valueCount > 0x2AAAAAAA) {
            throw new ArrayIndexOutOfBoundsException("MAX_SIZE exceeded");
        }
        this.blocks = new short[3 * valueCount];
    }

    Packed16ThreeBlocks(DataInput in, int valueCount) throws IOException {
        this(valueCount);
        for (int i = 0; i < this.blocks.length; ++i) {
            this.blocks[i] = in.readShort();
        }
        int mod = this.blocks.length % 4;
        if (mod != 0) {
            int pad = 4 - mod;
            for (int i = 0; i < pad; ++i) {
                in.readShort();
            }
        }
    }

    @Override
    public long get(int index) {
        int o = index * 3;
        return ((long)this.blocks[o] & 0xFFFFL) << 32 | ((long)this.blocks[o + 1] & 0xFFFFL) << 16 | (long)this.blocks[o + 2] & 0xFFFFL;
    }

    @Override
    public void set(int index, long value) {
        int o = index * 3;
        this.blocks[o] = (short)(value >> 32);
        this.blocks[o + 1] = (short)(value >> 16);
        this.blocks[o + 2] = (short)value;
    }

    @Override
    public void fill(int fromIndex, int toIndex, long val) {
        short block1 = (short)(val >> 32);
        short block2 = (short)(val >> 16);
        short block3 = (short)val;
        int i = fromIndex * 3;
        int end = toIndex * 3;
        while (i < end) {
            this.blocks[i++] = block1;
            this.blocks[i++] = block2;
            this.blocks[i++] = block3;
        }
    }

    @Override
    public void clear() {
        Arrays.fill(this.blocks, (short)0);
    }

    @Override
    public long ramBytesUsed() {
        return RamUsageEstimator.sizeOf(this.blocks);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(bitsPerValue=" + this.bitsPerValue + ", size=" + this.size() + ", elements.length=" + this.blocks.length + ")";
    }
}

