/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.reflect.Method;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Iterator;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.LockFactory;
import org.apache.lucene.util.Constants;
import org.apache.lucene.util.WeakIdentityMap;

public class MMapDirectory
extends FSDirectory {
    private boolean useUnmapHack = UNMAP_SUPPORTED;
    public static final int DEFAULT_MAX_BUFF;
    private int chunkSizePower;
    public static final boolean UNMAP_SUPPORTED;

    public MMapDirectory(File path, LockFactory lockFactory) throws IOException {
        super(path, lockFactory);
        this.setMaxChunkSize(DEFAULT_MAX_BUFF);
    }

    public MMapDirectory(File path) throws IOException {
        super(path, null);
        this.setMaxChunkSize(DEFAULT_MAX_BUFF);
    }

    public void setUseUnmap(boolean useUnmapHack) {
        if (useUnmapHack && !UNMAP_SUPPORTED) {
            throw new IllegalArgumentException("Unmap hack not supported on this platform!");
        }
        this.useUnmapHack = useUnmapHack;
    }

    public boolean getUseUnmap() {
        return this.useUnmapHack;
    }

    final void cleanMapping(final ByteBuffer buffer) throws IOException {
        if (this.useUnmapHack) {
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                    @Override
                    public Object run() throws Exception {
                        Method getCleanerMethod = buffer.getClass().getMethod("cleaner", new Class[0]);
                        getCleanerMethod.setAccessible(true);
                        Object cleaner = getCleanerMethod.invoke((Object)buffer, new Object[0]);
                        if (cleaner != null) {
                            cleaner.getClass().getMethod("clean", new Class[0]).invoke(cleaner, new Object[0]);
                        }
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException e) {
                IOException ioe = new IOException("unable to unmap the mapped buffer");
                ioe.initCause(e.getCause());
                throw ioe;
            }
        }
    }

    public final void setMaxChunkSize(int maxChunkSize) {
        if (maxChunkSize <= 0) {
            throw new IllegalArgumentException("Maximum chunk size for mmap must be >0");
        }
        this.chunkSizePower = 31 - Integer.numberOfLeadingZeros(maxChunkSize);
        assert (this.chunkSizePower >= 0 && this.chunkSizePower <= 30);
    }

    public final int getMaxChunkSize() {
        return 1 << this.chunkSizePower;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IndexInput openInput(String name, IOContext context) throws IOException {
        this.ensureOpen();
        File f = new File(this.getDirectory(), name);
        RandomAccessFile raf = new RandomAccessFile(f, "r");
        try {
            MMapIndexInput mMapIndexInput = new MMapIndexInput("MMapIndexInput(path=\"" + f + "\")", raf, 0L, raf.length(), this.chunkSizePower);
            return mMapIndexInput;
        }
        finally {
            raf.close();
        }
    }

    @Override
    public Directory.IndexInputSlicer createSlicer(String name, IOContext context) throws IOException {
        this.ensureOpen();
        final File f = new File(this.getDirectory(), name);
        final RandomAccessFile raf = new RandomAccessFile(f, "r");
        return new Directory.IndexInputSlicer(){

            @Override
            public void close() throws IOException {
                raf.close();
            }

            @Override
            public IndexInput openSlice(String sliceDescription, long offset, long length) throws IOException {
                return new MMapIndexInput("MMapIndexInput(" + sliceDescription + " in path=\"" + f + "\" slice=" + offset + ":" + (offset + length) + ")", raf, offset, length, MMapDirectory.this.chunkSizePower);
            }

            @Override
            public IndexInput openFullSlice() throws IOException {
                return this.openSlice("full-slice", 0L, raf.length());
            }
        };
    }

    static {
        boolean v;
        DEFAULT_MAX_BUFF = Constants.JRE_IS_64BIT ? 0x40000000 : 0x10000000;
        try {
            Class.forName("sun.misc.Cleaner");
            Class.forName("java.nio.DirectByteBuffer").getMethod("cleaner", new Class[0]);
            v = true;
        }
        catch (Exception e) {
            v = false;
        }
        UNMAP_SUPPORTED = v;
    }

    private final class MMapIndexInput
    extends IndexInput {
        private ByteBuffer[] buffers;
        private final long length;
        private final long chunkSizeMask;
        private final long chunkSize;
        private final int chunkSizePower;
        private int curBufIndex;
        private ByteBuffer curBuf;
        private boolean isClone;
        private final WeakIdentityMap<MMapIndexInput, Boolean> clones;

        MMapIndexInput(String resourceDescription, RandomAccessFile raf, long offset, long length, int chunkSizePower) throws IOException {
            super(resourceDescription);
            this.isClone = false;
            this.clones = WeakIdentityMap.newConcurrentHashMap();
            this.length = length;
            this.chunkSizePower = chunkSizePower;
            this.chunkSize = 1L << chunkSizePower;
            this.chunkSizeMask = this.chunkSize - 1L;
            if (chunkSizePower < 0 || chunkSizePower > 30) {
                throw new IllegalArgumentException("Invalid chunkSizePower used for ByteBuffer size: " + chunkSizePower);
            }
            if (length >>> chunkSizePower >= Integer.MAX_VALUE) {
                throw new IllegalArgumentException("RandomAccessFile too big for chunk size: " + raf.toString());
            }
            int nrBuffers = (int)(length >>> chunkSizePower) + 1;
            this.buffers = new ByteBuffer[nrBuffers];
            long bufferStart = 0L;
            FileChannel rafc = raf.getChannel();
            for (int bufNr = 0; bufNr < nrBuffers; ++bufNr) {
                int bufSize = (int)(length > bufferStart + this.chunkSize ? this.chunkSize : length - bufferStart);
                this.buffers[bufNr] = rafc.map(FileChannel.MapMode.READ_ONLY, offset + bufferStart, bufSize);
                bufferStart += (long)bufSize;
            }
            this.seek(0L);
        }

        @Override
        public byte readByte() throws IOException {
            try {
                return this.curBuf.get();
            }
            catch (BufferUnderflowException e) {
                do {
                    ++this.curBufIndex;
                    if (this.curBufIndex >= this.buffers.length) {
                        throw new EOFException("read past EOF: " + this);
                    }
                    this.curBuf = this.buffers[this.curBufIndex];
                    this.curBuf.position(0);
                } while (!this.curBuf.hasRemaining());
                return this.curBuf.get();
            }
            catch (NullPointerException npe) {
                throw new AlreadyClosedException("MMapIndexInput already closed: " + this);
            }
        }

        @Override
        public void readBytes(byte[] b, int offset, int len) throws IOException {
            try {
                this.curBuf.get(b, offset, len);
            }
            catch (BufferUnderflowException e) {
                int curAvail = this.curBuf.remaining();
                while (len > curAvail) {
                    this.curBuf.get(b, offset, curAvail);
                    len -= curAvail;
                    offset += curAvail;
                    ++this.curBufIndex;
                    if (this.curBufIndex >= this.buffers.length) {
                        throw new EOFException("read past EOF: " + this);
                    }
                    this.curBuf = this.buffers[this.curBufIndex];
                    this.curBuf.position(0);
                    curAvail = this.curBuf.remaining();
                }
                this.curBuf.get(b, offset, len);
            }
            catch (NullPointerException npe) {
                throw new AlreadyClosedException("MMapIndexInput already closed: " + this);
            }
        }

        @Override
        public short readShort() throws IOException {
            try {
                return this.curBuf.getShort();
            }
            catch (BufferUnderflowException e) {
                return super.readShort();
            }
            catch (NullPointerException npe) {
                throw new AlreadyClosedException("MMapIndexInput already closed: " + this);
            }
        }

        @Override
        public int readInt() throws IOException {
            try {
                return this.curBuf.getInt();
            }
            catch (BufferUnderflowException e) {
                return super.readInt();
            }
            catch (NullPointerException npe) {
                throw new AlreadyClosedException("MMapIndexInput already closed: " + this);
            }
        }

        @Override
        public long readLong() throws IOException {
            try {
                return this.curBuf.getLong();
            }
            catch (BufferUnderflowException e) {
                return super.readLong();
            }
            catch (NullPointerException npe) {
                throw new AlreadyClosedException("MMapIndexInput already closed: " + this);
            }
        }

        @Override
        public long getFilePointer() {
            try {
                return ((long)this.curBufIndex << this.chunkSizePower) + (long)this.curBuf.position();
            }
            catch (NullPointerException npe) {
                throw new AlreadyClosedException("MMapIndexInput already closed: " + this);
            }
        }

        @Override
        public void seek(long pos) throws IOException {
            int bi = (int)(pos >> this.chunkSizePower);
            try {
                ByteBuffer b = this.buffers[bi];
                b.position((int)(pos & this.chunkSizeMask));
                this.curBufIndex = bi;
                this.curBuf = b;
            }
            catch (ArrayIndexOutOfBoundsException aioobe) {
                if (pos < 0L) {
                    throw new IllegalArgumentException("Seeking to negative position: " + this);
                }
                throw new EOFException("seek past EOF: " + this);
            }
            catch (IllegalArgumentException iae) {
                if (pos < 0L) {
                    throw new IllegalArgumentException("Seeking to negative position: " + this);
                }
                throw new EOFException("seek past EOF: " + this);
            }
            catch (NullPointerException npe) {
                throw new AlreadyClosedException("MMapIndexInput already closed: " + this);
            }
        }

        @Override
        public long length() {
            return this.length;
        }

        @Override
        public MMapIndexInput clone() {
            if (this.buffers == null) {
                throw new AlreadyClosedException("MMapIndexInput already closed: " + this);
            }
            MMapIndexInput clone = (MMapIndexInput)super.clone();
            clone.isClone = true;
            assert (clone.clones == this.clones);
            clone.buffers = new ByteBuffer[this.buffers.length];
            for (int bufNr = 0; bufNr < this.buffers.length; ++bufNr) {
                clone.buffers[bufNr] = this.buffers[bufNr].duplicate();
            }
            try {
                clone.seek(this.getFilePointer());
            }
            catch (IOException ioe) {
                throw new RuntimeException("Should never happen: " + this, ioe);
            }
            this.clones.put(clone, Boolean.TRUE);
            return clone;
        }

        private void unsetBuffers() {
            this.buffers = null;
            this.curBuf = null;
            this.curBufIndex = 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            try {
                if (this.isClone || this.buffers == null) {
                    return;
                }
                ByteBuffer[] bufs = this.buffers;
                this.unsetBuffers();
                Iterator<MMapIndexInput> it = this.clones.keyIterator();
                while (it.hasNext()) {
                    MMapIndexInput clone = it.next();
                    assert (clone.isClone);
                    clone.unsetBuffers();
                }
                this.clones.clear();
                for (ByteBuffer b : bufs) {
                    MMapDirectory.this.cleanMapping(b);
                }
            }
            finally {
                this.unsetBuffers();
            }
        }
    }
}

