/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import org.apache.lucene.index.AtomicReader;
import org.apache.lucene.index.DocTermOrds;
import org.apache.lucene.index.DocsAndPositionsEnum;
import org.apache.lucene.index.DocsEnum;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.OrdTermState;
import org.apache.lucene.index.SegmentReader;
import org.apache.lucene.index.TermState;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.FieldCache;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.FieldCacheSanityChecker;
import org.apache.lucene.util.FixedBitSet;
import org.apache.lucene.util.PagedBytes;
import org.apache.lucene.util.packed.GrowableWriter;
import org.apache.lucene.util.packed.PackedInts;

class FieldCacheImpl
implements FieldCache {
    private Map<Class<?>, Cache> caches;
    final SegmentReader.CoreClosedListener purgeCore = new SegmentReader.CoreClosedListener(){

        @Override
        public void onClose(SegmentReader owner) {
            FieldCacheImpl.this.purge(owner);
        }
    };
    final IndexReader.ReaderClosedListener purgeReader = new IndexReader.ReaderClosedListener(){

        @Override
        public void onClose(IndexReader owner) {
            assert (owner instanceof AtomicReader);
            FieldCacheImpl.this.purge((AtomicReader)owner);
        }
    };
    private volatile PrintStream infoStream;

    FieldCacheImpl() {
        this.init();
    }

    private synchronized void init() {
        this.caches = new HashMap(9);
        this.caches.put(Byte.TYPE, new ByteCache(this));
        this.caches.put(Short.TYPE, new ShortCache(this));
        this.caches.put(Integer.TYPE, new IntCache(this));
        this.caches.put(Float.TYPE, new FloatCache(this));
        this.caches.put(Long.TYPE, new LongCache(this));
        this.caches.put(Double.TYPE, new DoubleCache(this));
        this.caches.put(FieldCache.DocTerms.class, new DocTermsCache(this));
        this.caches.put(FieldCache.DocTermsIndex.class, new DocTermsIndexCache(this));
        this.caches.put(DocTermOrds.class, new DocTermOrdsCache(this));
        this.caches.put(DocsWithFieldCache.class, new DocsWithFieldCache(this));
    }

    @Override
    public synchronized void purgeAllCaches() {
        this.init();
    }

    @Override
    public synchronized void purge(AtomicReader r) {
        for (Cache c : this.caches.values()) {
            c.purge(r);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized FieldCache.CacheEntry[] getCacheEntries() {
        ArrayList<CacheEntryImpl> result = new ArrayList<CacheEntryImpl>(17);
        for (Map.Entry<Class<?>, Cache> cacheEntry : this.caches.entrySet()) {
            Cache cache = cacheEntry.getValue();
            Class<?> cacheType = cacheEntry.getKey();
            Map<Object, Map<Entry, Object>> map = cache.readerCache;
            synchronized (map) {
                for (Map.Entry<Object, Map<Entry, Object>> readerCacheEntry : cache.readerCache.entrySet()) {
                    Object readerKey = readerCacheEntry.getKey();
                    if (readerKey == null) continue;
                    Map<Entry, Object> innerCache = readerCacheEntry.getValue();
                    for (Map.Entry<Entry, Object> mapEntry : innerCache.entrySet()) {
                        Entry entry = mapEntry.getKey();
                        result.add(new CacheEntryImpl(readerKey, entry.field, cacheType, entry.custom, mapEntry.getValue()));
                    }
                }
            }
        }
        return result.toArray(new FieldCache.CacheEntry[result.size()]);
    }

    private void initReader(AtomicReader reader) {
        if (reader instanceof SegmentReader) {
            ((SegmentReader)reader).addCoreClosedListener(this.purgeCore);
        } else {
            Object key = reader.getCoreCacheKey();
            if (key instanceof AtomicReader) {
                ((AtomicReader)key).addReaderClosedListener(this.purgeReader);
            } else {
                reader.addReaderClosedListener(this.purgeReader);
            }
        }
    }

    @Override
    public byte[] getBytes(AtomicReader reader, String field, boolean setDocsWithField) throws IOException {
        return this.getBytes(reader, field, null, setDocsWithField);
    }

    @Override
    public byte[] getBytes(AtomicReader reader, String field, FieldCache.ByteParser parser, boolean setDocsWithField) throws IOException {
        return (byte[])this.caches.get(Byte.TYPE).get(reader, new Entry(field, parser), setDocsWithField);
    }

    @Override
    public short[] getShorts(AtomicReader reader, String field, boolean setDocsWithField) throws IOException {
        return this.getShorts(reader, field, null, setDocsWithField);
    }

    @Override
    public short[] getShorts(AtomicReader reader, String field, FieldCache.ShortParser parser, boolean setDocsWithField) throws IOException {
        return (short[])this.caches.get(Short.TYPE).get(reader, new Entry(field, parser), setDocsWithField);
    }

    void setDocsWithField(AtomicReader reader, String field, Bits docsWithField) {
        Bits bits;
        int maxDoc = reader.maxDoc();
        if (docsWithField == null) {
            bits = new Bits.MatchNoBits(maxDoc);
        } else if (docsWithField instanceof FixedBitSet) {
            int numSet = ((FixedBitSet)docsWithField).cardinality();
            if (numSet >= maxDoc) {
                assert (numSet == maxDoc);
                bits = new Bits.MatchAllBits(maxDoc);
            } else {
                bits = docsWithField;
            }
        } else {
            bits = docsWithField;
        }
        this.caches.get(DocsWithFieldCache.class).put(reader, new Entry(field, null), bits);
    }

    @Override
    public int[] getInts(AtomicReader reader, String field, boolean setDocsWithField) throws IOException {
        return this.getInts(reader, field, null, setDocsWithField);
    }

    @Override
    public int[] getInts(AtomicReader reader, String field, FieldCache.IntParser parser, boolean setDocsWithField) throws IOException {
        return (int[])this.caches.get(Integer.TYPE).get(reader, new Entry(field, parser), setDocsWithField);
    }

    @Override
    public Bits getDocsWithField(AtomicReader reader, String field) throws IOException {
        return (Bits)this.caches.get(DocsWithFieldCache.class).get(reader, new Entry(field, null), false);
    }

    @Override
    public float[] getFloats(AtomicReader reader, String field, boolean setDocsWithField) throws IOException {
        return this.getFloats(reader, field, null, setDocsWithField);
    }

    @Override
    public float[] getFloats(AtomicReader reader, String field, FieldCache.FloatParser parser, boolean setDocsWithField) throws IOException {
        return (float[])this.caches.get(Float.TYPE).get(reader, new Entry(field, parser), setDocsWithField);
    }

    @Override
    public long[] getLongs(AtomicReader reader, String field, boolean setDocsWithField) throws IOException {
        return this.getLongs(reader, field, null, setDocsWithField);
    }

    @Override
    public long[] getLongs(AtomicReader reader, String field, FieldCache.LongParser parser, boolean setDocsWithField) throws IOException {
        return (long[])this.caches.get(Long.TYPE).get(reader, new Entry(field, parser), setDocsWithField);
    }

    @Override
    public double[] getDoubles(AtomicReader reader, String field, boolean setDocsWithField) throws IOException {
        return this.getDoubles(reader, field, null, setDocsWithField);
    }

    @Override
    public double[] getDoubles(AtomicReader reader, String field, FieldCache.DoubleParser parser, boolean setDocsWithField) throws IOException {
        return (double[])this.caches.get(Double.TYPE).get(reader, new Entry(field, parser), setDocsWithField);
    }

    @Override
    public FieldCache.DocTermsIndex getTermsIndex(AtomicReader reader, String field) throws IOException {
        return this.getTermsIndex(reader, field, 0.5f);
    }

    @Override
    public FieldCache.DocTermsIndex getTermsIndex(AtomicReader reader, String field, float acceptableOverheadRatio) throws IOException {
        return (FieldCache.DocTermsIndex)this.caches.get(FieldCache.DocTermsIndex.class).get(reader, new Entry(field, Float.valueOf(acceptableOverheadRatio)), false);
    }

    @Override
    public FieldCache.DocTerms getTerms(AtomicReader reader, String field) throws IOException {
        return this.getTerms(reader, field, 0.5f);
    }

    @Override
    public FieldCache.DocTerms getTerms(AtomicReader reader, String field, float acceptableOverheadRatio) throws IOException {
        return (FieldCache.DocTerms)this.caches.get(FieldCache.DocTerms.class).get(reader, new Entry(field, Float.valueOf(acceptableOverheadRatio)), false);
    }

    @Override
    public DocTermOrds getDocTermOrds(AtomicReader reader, String field) throws IOException {
        return (DocTermOrds)this.caches.get(DocTermOrds.class).get(reader, new Entry(field, null), false);
    }

    @Override
    public void setInfoStream(PrintStream stream) {
        this.infoStream = stream;
    }

    @Override
    public PrintStream getInfoStream() {
        return this.infoStream;
    }

    static final class DocTermOrdsCache
    extends Cache {
        DocTermOrdsCache(FieldCacheImpl wrapper) {
            super(wrapper);
        }

        @Override
        protected Object createValue(AtomicReader reader, Entry entryKey, boolean setDocsWithField) throws IOException {
            return new DocTermOrds(reader, entryKey.field);
        }
    }

    static final class DocTermsCache
    extends Cache {
        DocTermsCache(FieldCacheImpl wrapper) {
            super(wrapper);
        }

        @Override
        protected Object createValue(AtomicReader reader, Entry entryKey, boolean setDocsWithField) throws IOException {
            int startBPV;
            Terms terms = reader.terms(entryKey.field);
            float acceptableOverheadRatio = ((Float)entryKey.custom).floatValue();
            int termCountHardLimit = reader.maxDoc();
            PagedBytes bytes = new PagedBytes(15);
            if (terms != null) {
                long numUniqueTerms = 0L;
                try {
                    numUniqueTerms = terms.size();
                }
                catch (UnsupportedOperationException uoe) {
                    numUniqueTerms = -1L;
                }
                if (numUniqueTerms != -1L) {
                    if (numUniqueTerms > (long)termCountHardLimit) {
                        numUniqueTerms = termCountHardLimit;
                    }
                    startBPV = PackedInts.bitsRequired(numUniqueTerms * 4L);
                } else {
                    startBPV = 1;
                }
            } else {
                startBPV = 1;
            }
            GrowableWriter docToOffset = new GrowableWriter(startBPV, reader.maxDoc(), acceptableOverheadRatio);
            bytes.copyUsingLengthPrefix(new BytesRef());
            if (terms != null) {
                BytesRef term;
                int termCount = 0;
                TermsEnum termsEnum = terms.iterator(null);
                DocsEnum docs = null;
                while (termCount++ != termCountHardLimit && (term = termsEnum.next()) != null) {
                    int docID;
                    long pointer = bytes.copyUsingLengthPrefix(term);
                    docs = termsEnum.docs(null, docs, false);
                    while ((docID = docs.nextDoc()) != Integer.MAX_VALUE) {
                        docToOffset.set(docID, pointer);
                    }
                }
            }
            return new DocTermsImpl(bytes.freeze(true), docToOffset.getMutable());
        }
    }

    private static class DocTermsImpl
    extends FieldCache.DocTerms {
        private final PagedBytes.Reader bytes;
        private final PackedInts.Reader docToOffset;

        public DocTermsImpl(PagedBytes.Reader bytes, PackedInts.Reader docToOffset) {
            this.bytes = bytes;
            this.docToOffset = docToOffset;
        }

        @Override
        public int size() {
            return this.docToOffset.size();
        }

        @Override
        public boolean exists(int docID) {
            return this.docToOffset.get(docID) == 0L;
        }

        @Override
        public BytesRef getTerm(int docID, BytesRef ret) {
            int pointer = (int)this.docToOffset.get(docID);
            return this.bytes.fill(ret, pointer);
        }
    }

    static class DocTermsIndexCache
    extends Cache {
        DocTermsIndexCache(FieldCacheImpl wrapper) {
            super(wrapper);
        }

        @Override
        protected Object createValue(AtomicReader reader, Entry entryKey, boolean setDocsWithField) throws IOException {
            int termOrd;
            int startNumUniqueTerms;
            int startTermsBPV;
            int startBytesBPV;
            Terms terms = reader.terms(entryKey.field);
            float acceptableOverheadRatio = ((Float)entryKey.custom).floatValue();
            PagedBytes bytes = new PagedBytes(15);
            int maxDoc = reader.maxDoc();
            int termCountHardLimit = maxDoc == Integer.MAX_VALUE ? Integer.MAX_VALUE : maxDoc + 1;
            if (terms != null) {
                long numUniqueTerms = 0L;
                try {
                    numUniqueTerms = terms.size();
                }
                catch (UnsupportedOperationException uoe) {
                    numUniqueTerms = -1L;
                }
                if (numUniqueTerms != -1L) {
                    if (numUniqueTerms > (long)termCountHardLimit) {
                        numUniqueTerms = termCountHardLimit;
                    }
                    startBytesBPV = PackedInts.bitsRequired(numUniqueTerms * 4L);
                    startTermsBPV = PackedInts.bitsRequired(numUniqueTerms);
                    startNumUniqueTerms = (int)numUniqueTerms;
                } else {
                    startBytesBPV = 1;
                    startTermsBPV = 1;
                    startNumUniqueTerms = 1;
                }
            } else {
                startBytesBPV = 1;
                startTermsBPV = 1;
                startNumUniqueTerms = 1;
            }
            GrowableWriter termOrdToBytesOffset = new GrowableWriter(startBytesBPV, 1 + startNumUniqueTerms, acceptableOverheadRatio);
            GrowableWriter docToTermOrd = new GrowableWriter(startTermsBPV, maxDoc, acceptableOverheadRatio);
            bytes.copyUsingLengthPrefix(new BytesRef());
            if (terms != null) {
                BytesRef term;
                TermsEnum termsEnum = terms.iterator(null);
                DocsEnum docs = null;
                for (termOrd = 1; (term = termsEnum.next()) != null && termOrd < termCountHardLimit; ++termOrd) {
                    int docID;
                    if (termOrd == termOrdToBytesOffset.size()) {
                        termOrdToBytesOffset = termOrdToBytesOffset.resize(ArrayUtil.oversize(1 + termOrd, 1));
                    }
                    termOrdToBytesOffset.set(termOrd, bytes.copyUsingLengthPrefix(term));
                    docs = termsEnum.docs(null, docs, false);
                    while ((docID = docs.nextDoc()) != Integer.MAX_VALUE) {
                        docToTermOrd.set(docID, termOrd);
                    }
                }
                if (termOrdToBytesOffset.size() > termOrd) {
                    termOrdToBytesOffset = termOrdToBytesOffset.resize(termOrd);
                }
            }
            return new DocTermsIndexImpl(bytes.freeze(true), termOrdToBytesOffset.getMutable(), docToTermOrd.getMutable(), termOrd);
        }
    }

    public static class DocTermsIndexImpl
    extends FieldCache.DocTermsIndex {
        private final PagedBytes.Reader bytes;
        private final PackedInts.Reader termOrdToBytesOffset;
        private final PackedInts.Reader docToTermOrd;
        private final int numOrd;

        public DocTermsIndexImpl(PagedBytes.Reader bytes, PackedInts.Reader termOrdToBytesOffset, PackedInts.Reader docToTermOrd, int numOrd) {
            this.bytes = bytes;
            this.docToTermOrd = docToTermOrd;
            this.termOrdToBytesOffset = termOrdToBytesOffset;
            this.numOrd = numOrd;
        }

        @Override
        public PackedInts.Reader getDocToOrd() {
            return this.docToTermOrd;
        }

        @Override
        public int numOrd() {
            return this.numOrd;
        }

        @Override
        public int getOrd(int docID) {
            return (int)this.docToTermOrd.get(docID);
        }

        @Override
        public int size() {
            return this.docToTermOrd.size();
        }

        @Override
        public BytesRef lookup(int ord, BytesRef ret) {
            return this.bytes.fill(ret, this.termOrdToBytesOffset.get(ord));
        }

        @Override
        public TermsEnum getTermsEnum() {
            return new DocTermsIndexEnum();
        }

        class DocTermsIndexEnum
        extends TermsEnum {
            int currentOrd = 0;
            int currentBlockNumber = 0;
            int end;
            final byte[][] blocks;
            final int[] blockEnds;
            final BytesRef term = new BytesRef();

            public DocTermsIndexEnum() {
                this.blocks = DocTermsIndexImpl.this.bytes.getBlocks();
                this.blockEnds = DocTermsIndexImpl.this.bytes.getBlockEnds();
                this.currentBlockNumber = DocTermsIndexImpl.this.bytes.fillAndGetIndex(this.term, DocTermsIndexImpl.this.termOrdToBytesOffset.get(0));
                this.end = this.blockEnds[this.currentBlockNumber];
            }

            @Override
            public TermsEnum.SeekStatus seekCeil(BytesRef text, boolean useCache) throws IOException {
                int low = 1;
                int high = DocTermsIndexImpl.this.numOrd - 1;
                while (low <= high) {
                    int mid = low + high >>> 1;
                    this.seekExact(mid);
                    int cmp = this.term.compareTo(text);
                    if (cmp < 0) {
                        low = mid + 1;
                        continue;
                    }
                    if (cmp > 0) {
                        high = mid - 1;
                        continue;
                    }
                    return TermsEnum.SeekStatus.FOUND;
                }
                if (low == DocTermsIndexImpl.this.numOrd) {
                    return TermsEnum.SeekStatus.END;
                }
                this.seekExact(low);
                return TermsEnum.SeekStatus.NOT_FOUND;
            }

            @Override
            public void seekExact(long ord) throws IOException {
                assert (ord >= 0L && ord <= (long)DocTermsIndexImpl.this.numOrd);
                this.currentBlockNumber = DocTermsIndexImpl.this.bytes.fillAndGetIndex(this.term, DocTermsIndexImpl.this.termOrdToBytesOffset.get((int)ord));
                this.end = this.blockEnds[this.currentBlockNumber];
                this.currentOrd = (int)ord;
            }

            @Override
            public BytesRef next() throws IOException {
                int start = this.term.offset + this.term.length;
                if (start >= this.end) {
                    if (this.currentBlockNumber + 1 >= this.blocks.length) {
                        return null;
                    }
                    ++this.currentBlockNumber;
                    this.term.bytes = this.blocks[this.currentBlockNumber];
                    this.end = this.blockEnds[this.currentBlockNumber];
                    start = 0;
                    if (this.end <= 0) {
                        return null;
                    }
                }
                ++this.currentOrd;
                byte[] block = this.term.bytes;
                if ((block[start] & 0x80) == 0) {
                    this.term.length = block[start];
                    this.term.offset = start + 1;
                } else {
                    this.term.length = (block[start] & 0x7F) << 8 | block[1 + start] & 0xFF;
                    this.term.offset = start + 2;
                }
                return this.term;
            }

            @Override
            public BytesRef term() throws IOException {
                return this.term;
            }

            @Override
            public long ord() throws IOException {
                return this.currentOrd;
            }

            @Override
            public int docFreq() {
                throw new UnsupportedOperationException();
            }

            @Override
            public long totalTermFreq() {
                return -1L;
            }

            @Override
            public DocsEnum docs(Bits liveDocs, DocsEnum reuse, boolean needsFreqs) throws IOException {
                throw new UnsupportedOperationException();
            }

            @Override
            public DocsAndPositionsEnum docsAndPositions(Bits liveDocs, DocsAndPositionsEnum reuse, boolean needsOffsets) throws IOException {
                throw new UnsupportedOperationException();
            }

            @Override
            public Comparator<BytesRef> getComparator() {
                return BytesRef.getUTF8SortedAsUnicodeComparator();
            }

            @Override
            public void seekExact(BytesRef term, TermState state) throws IOException {
                assert (state != null && state instanceof OrdTermState);
                this.seekExact(((OrdTermState)state).ord);
            }

            @Override
            public TermState termState() throws IOException {
                OrdTermState state = new OrdTermState();
                state.ord = this.currentOrd;
                return state;
            }
        }
    }

    static final class DoubleCache
    extends Cache {
        DoubleCache(FieldCacheImpl wrapper) {
            super(wrapper);
        }

        @Override
        protected Object createValue(AtomicReader reader, Entry entryKey, boolean setDocsWithField) throws IOException {
            String field = entryKey.field;
            FieldCache.DoubleParser parser = (FieldCache.DoubleParser)entryKey.custom;
            if (parser == null) {
                try {
                    return this.wrapper.getDoubles(reader, field, FieldCache.DEFAULT_DOUBLE_PARSER, setDocsWithField);
                }
                catch (NumberFormatException ne) {
                    return this.wrapper.getDoubles(reader, field, FieldCache.NUMERIC_UTILS_DOUBLE_PARSER, setDocsWithField);
                }
            }
            int maxDoc = reader.maxDoc();
            double[] retArray = null;
            Terms terms = reader.terms(field);
            FixedBitSet docsWithField = null;
            if (terms != null) {
                if (setDocsWithField) {
                    int termsDocCount = terms.getDocCount();
                    assert (termsDocCount <= maxDoc);
                    if (termsDocCount == maxDoc) {
                        this.wrapper.setDocsWithField(reader, field, new Bits.MatchAllBits(maxDoc));
                        setDocsWithField = false;
                    }
                }
                TermsEnum termsEnum = terms.iterator(null);
                DocsEnum docs = null;
                try {
                    BytesRef term;
                    while ((term = termsEnum.next()) != null) {
                        int docID;
                        double termval = parser.parseDouble(term);
                        if (retArray == null) {
                            retArray = new double[maxDoc];
                        }
                        docs = termsEnum.docs(null, docs, false);
                        while ((docID = docs.nextDoc()) != Integer.MAX_VALUE) {
                            retArray[docID] = termval;
                            if (!setDocsWithField) continue;
                            if (docsWithField == null) {
                                docsWithField = new FixedBitSet(maxDoc);
                            }
                            docsWithField.set(docID);
                        }
                    }
                }
                catch (FieldCache.StopFillCacheException stop) {
                    // empty catch block
                }
            }
            if (retArray == null) {
                retArray = new double[maxDoc];
            }
            if (setDocsWithField) {
                this.wrapper.setDocsWithField(reader, field, docsWithField);
            }
            return retArray;
        }
    }

    static final class LongCache
    extends Cache {
        LongCache(FieldCacheImpl wrapper) {
            super(wrapper);
        }

        @Override
        protected Object createValue(AtomicReader reader, Entry entryKey, boolean setDocsWithField) throws IOException {
            String field = entryKey.field;
            FieldCache.LongParser parser = (FieldCache.LongParser)entryKey.custom;
            if (parser == null) {
                try {
                    return this.wrapper.getLongs(reader, field, FieldCache.DEFAULT_LONG_PARSER, setDocsWithField);
                }
                catch (NumberFormatException ne) {
                    return this.wrapper.getLongs(reader, field, FieldCache.NUMERIC_UTILS_LONG_PARSER, setDocsWithField);
                }
            }
            int maxDoc = reader.maxDoc();
            long[] retArray = null;
            Terms terms = reader.terms(field);
            FixedBitSet docsWithField = null;
            if (terms != null) {
                if (setDocsWithField) {
                    int termsDocCount = terms.getDocCount();
                    assert (termsDocCount <= maxDoc);
                    if (termsDocCount == maxDoc) {
                        this.wrapper.setDocsWithField(reader, field, new Bits.MatchAllBits(maxDoc));
                        setDocsWithField = false;
                    }
                }
                TermsEnum termsEnum = terms.iterator(null);
                DocsEnum docs = null;
                try {
                    BytesRef term;
                    while ((term = termsEnum.next()) != null) {
                        int docID;
                        long termval = parser.parseLong(term);
                        if (retArray == null) {
                            retArray = new long[maxDoc];
                        }
                        docs = termsEnum.docs(null, docs, false);
                        while ((docID = docs.nextDoc()) != Integer.MAX_VALUE) {
                            retArray[docID] = termval;
                            if (!setDocsWithField) continue;
                            if (docsWithField == null) {
                                docsWithField = new FixedBitSet(maxDoc);
                            }
                            docsWithField.set(docID);
                        }
                    }
                }
                catch (FieldCache.StopFillCacheException stop) {
                    // empty catch block
                }
            }
            if (retArray == null) {
                retArray = new long[maxDoc];
            }
            if (setDocsWithField) {
                this.wrapper.setDocsWithField(reader, field, docsWithField);
            }
            return retArray;
        }
    }

    static final class FloatCache
    extends Cache {
        FloatCache(FieldCacheImpl wrapper) {
            super(wrapper);
        }

        @Override
        protected Object createValue(AtomicReader reader, Entry entryKey, boolean setDocsWithField) throws IOException {
            String field = entryKey.field;
            FieldCache.FloatParser parser = (FieldCache.FloatParser)entryKey.custom;
            if (parser == null) {
                try {
                    return this.wrapper.getFloats(reader, field, FieldCache.DEFAULT_FLOAT_PARSER, setDocsWithField);
                }
                catch (NumberFormatException ne) {
                    return this.wrapper.getFloats(reader, field, FieldCache.NUMERIC_UTILS_FLOAT_PARSER, setDocsWithField);
                }
            }
            int maxDoc = reader.maxDoc();
            float[] retArray = null;
            Terms terms = reader.terms(field);
            FixedBitSet docsWithField = null;
            if (terms != null) {
                if (setDocsWithField) {
                    int termsDocCount = terms.getDocCount();
                    assert (termsDocCount <= maxDoc);
                    if (termsDocCount == maxDoc) {
                        this.wrapper.setDocsWithField(reader, field, new Bits.MatchAllBits(maxDoc));
                        setDocsWithField = false;
                    }
                }
                TermsEnum termsEnum = terms.iterator(null);
                DocsEnum docs = null;
                try {
                    BytesRef term;
                    while ((term = termsEnum.next()) != null) {
                        int docID;
                        float termval = parser.parseFloat(term);
                        if (retArray == null) {
                            retArray = new float[maxDoc];
                        }
                        docs = termsEnum.docs(null, docs, false);
                        while ((docID = docs.nextDoc()) != Integer.MAX_VALUE) {
                            retArray[docID] = termval;
                            if (!setDocsWithField) continue;
                            if (docsWithField == null) {
                                docsWithField = new FixedBitSet(maxDoc);
                            }
                            docsWithField.set(docID);
                        }
                    }
                }
                catch (FieldCache.StopFillCacheException stop) {
                    // empty catch block
                }
            }
            if (retArray == null) {
                retArray = new float[maxDoc];
            }
            if (setDocsWithField) {
                this.wrapper.setDocsWithField(reader, field, docsWithField);
            }
            return retArray;
        }
    }

    static final class DocsWithFieldCache
    extends Cache {
        DocsWithFieldCache(FieldCacheImpl wrapper) {
            super(wrapper);
        }

        @Override
        protected Object createValue(AtomicReader reader, Entry entryKey, boolean setDocsWithField) throws IOException {
            String field = entryKey.field;
            FixedBitSet res = null;
            Terms terms = reader.terms(field);
            int maxDoc = reader.maxDoc();
            if (terms != null) {
                BytesRef term;
                int termsDocCount = terms.getDocCount();
                assert (termsDocCount <= maxDoc);
                if (termsDocCount == maxDoc) {
                    return new Bits.MatchAllBits(maxDoc);
                }
                TermsEnum termsEnum = terms.iterator(null);
                DocsEnum docs = null;
                while ((term = termsEnum.next()) != null) {
                    int docID;
                    if (res == null) {
                        res = new FixedBitSet(maxDoc);
                    }
                    docs = termsEnum.docs(null, docs, false);
                    while ((docID = docs.nextDoc()) != Integer.MAX_VALUE) {
                        res.set(docID);
                    }
                }
            }
            if (res == null) {
                return new Bits.MatchNoBits(maxDoc);
            }
            int numSet = res.cardinality();
            if (numSet >= maxDoc) {
                assert (numSet == maxDoc);
                return new Bits.MatchAllBits(maxDoc);
            }
            return res;
        }
    }

    static final class IntCache
    extends Cache {
        IntCache(FieldCacheImpl wrapper) {
            super(wrapper);
        }

        @Override
        protected Object createValue(AtomicReader reader, Entry entryKey, boolean setDocsWithField) throws IOException {
            String field = entryKey.field;
            FieldCache.IntParser parser = (FieldCache.IntParser)entryKey.custom;
            if (parser == null) {
                try {
                    return this.wrapper.getInts(reader, field, FieldCache.DEFAULT_INT_PARSER, setDocsWithField);
                }
                catch (NumberFormatException ne) {
                    return this.wrapper.getInts(reader, field, FieldCache.NUMERIC_UTILS_INT_PARSER, setDocsWithField);
                }
            }
            int maxDoc = reader.maxDoc();
            int[] retArray = null;
            Terms terms = reader.terms(field);
            FixedBitSet docsWithField = null;
            if (terms != null) {
                if (setDocsWithField) {
                    int termsDocCount = terms.getDocCount();
                    assert (termsDocCount <= maxDoc);
                    if (termsDocCount == maxDoc) {
                        this.wrapper.setDocsWithField(reader, field, new Bits.MatchAllBits(maxDoc));
                        setDocsWithField = false;
                    }
                }
                TermsEnum termsEnum = terms.iterator(null);
                DocsEnum docs = null;
                try {
                    BytesRef term;
                    while ((term = termsEnum.next()) != null) {
                        int docID;
                        int termval = parser.parseInt(term);
                        if (retArray == null) {
                            retArray = new int[maxDoc];
                        }
                        docs = termsEnum.docs(null, docs, false);
                        while ((docID = docs.nextDoc()) != Integer.MAX_VALUE) {
                            retArray[docID] = termval;
                            if (!setDocsWithField) continue;
                            if (docsWithField == null) {
                                docsWithField = new FixedBitSet(maxDoc);
                            }
                            docsWithField.set(docID);
                        }
                    }
                }
                catch (FieldCache.StopFillCacheException stop) {
                    // empty catch block
                }
            }
            if (retArray == null) {
                retArray = new int[maxDoc];
            }
            if (setDocsWithField) {
                this.wrapper.setDocsWithField(reader, field, docsWithField);
            }
            return retArray;
        }
    }

    static final class ShortCache
    extends Cache {
        ShortCache(FieldCacheImpl wrapper) {
            super(wrapper);
        }

        @Override
        protected Object createValue(AtomicReader reader, Entry entryKey, boolean setDocsWithField) throws IOException {
            String field = entryKey.field;
            FieldCache.ShortParser parser = (FieldCache.ShortParser)entryKey.custom;
            if (parser == null) {
                return this.wrapper.getShorts(reader, field, FieldCache.DEFAULT_SHORT_PARSER, setDocsWithField);
            }
            int maxDoc = reader.maxDoc();
            short[] retArray = new short[maxDoc];
            Terms terms = reader.terms(field);
            FixedBitSet docsWithField = null;
            if (terms != null) {
                if (setDocsWithField) {
                    int termsDocCount = terms.getDocCount();
                    assert (termsDocCount <= maxDoc);
                    if (termsDocCount == maxDoc) {
                        this.wrapper.setDocsWithField(reader, field, new Bits.MatchAllBits(maxDoc));
                        setDocsWithField = false;
                    }
                }
                TermsEnum termsEnum = terms.iterator(null);
                DocsEnum docs = null;
                try {
                    BytesRef term;
                    while ((term = termsEnum.next()) != null) {
                        int docID;
                        short termval = parser.parseShort(term);
                        docs = termsEnum.docs(null, docs, false);
                        while ((docID = docs.nextDoc()) != Integer.MAX_VALUE) {
                            retArray[docID] = termval;
                            if (!setDocsWithField) continue;
                            if (docsWithField == null) {
                                docsWithField = new FixedBitSet(maxDoc);
                            }
                            docsWithField.set(docID);
                        }
                    }
                }
                catch (FieldCache.StopFillCacheException stop) {
                    // empty catch block
                }
            }
            if (setDocsWithField) {
                this.wrapper.setDocsWithField(reader, field, docsWithField);
            }
            return retArray;
        }
    }

    static final class ByteCache
    extends Cache {
        ByteCache(FieldCacheImpl wrapper) {
            super(wrapper);
        }

        @Override
        protected Object createValue(AtomicReader reader, Entry entryKey, boolean setDocsWithField) throws IOException {
            String field = entryKey.field;
            FieldCache.ByteParser parser = (FieldCache.ByteParser)entryKey.custom;
            if (parser == null) {
                return this.wrapper.getBytes(reader, field, FieldCache.DEFAULT_BYTE_PARSER, setDocsWithField);
            }
            int maxDoc = reader.maxDoc();
            byte[] retArray = new byte[maxDoc];
            Terms terms = reader.terms(field);
            FixedBitSet docsWithField = null;
            if (terms != null) {
                if (setDocsWithField) {
                    int termsDocCount = terms.getDocCount();
                    assert (termsDocCount <= maxDoc);
                    if (termsDocCount == maxDoc) {
                        this.wrapper.setDocsWithField(reader, field, new Bits.MatchAllBits(maxDoc));
                        setDocsWithField = false;
                    }
                }
                TermsEnum termsEnum = terms.iterator(null);
                DocsEnum docs = null;
                try {
                    BytesRef term;
                    while ((term = termsEnum.next()) != null) {
                        int docID;
                        byte termval = parser.parseByte(term);
                        docs = termsEnum.docs(null, docs, false);
                        while ((docID = docs.nextDoc()) != Integer.MAX_VALUE) {
                            retArray[docID] = termval;
                            if (!setDocsWithField) continue;
                            if (docsWithField == null) {
                                docsWithField = new FixedBitSet(maxDoc);
                            }
                            docsWithField.set(docID);
                        }
                    }
                }
                catch (FieldCache.StopFillCacheException stop) {
                    // empty catch block
                }
            }
            if (setDocsWithField) {
                this.wrapper.setDocsWithField(reader, field, docsWithField);
            }
            return retArray;
        }
    }

    static class Entry {
        final String field;
        final Object custom;

        Entry(String field, Object custom) {
            this.field = field;
            this.custom = custom;
        }

        public boolean equals(Object o) {
            if (o instanceof Entry) {
                Entry other = (Entry)o;
                if (other.field.equals(this.field) && (other.custom == null ? this.custom == null : other.custom.equals(this.custom))) {
                    return true;
                }
            }
            return false;
        }

        public int hashCode() {
            return this.field.hashCode() ^ (this.custom == null ? 0 : this.custom.hashCode());
        }
    }

    static abstract class Cache {
        final FieldCacheImpl wrapper;
        final Map<Object, Map<Entry, Object>> readerCache = new WeakHashMap<Object, Map<Entry, Object>>();

        Cache(FieldCacheImpl wrapper) {
            this.wrapper = wrapper;
        }

        protected abstract Object createValue(AtomicReader var1, Entry var2, boolean var3) throws IOException;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void purge(AtomicReader r) {
            Object readerKey = r.getCoreCacheKey();
            Map<Object, Map<Entry, Object>> map = this.readerCache;
            synchronized (map) {
                this.readerCache.remove(readerKey);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void put(AtomicReader reader, Entry key, Object value) {
            Object readerKey = reader.getCoreCacheKey();
            Map<Object, Map<Entry, Object>> map = this.readerCache;
            synchronized (map) {
                Map<Entry, Object> innerCache = this.readerCache.get(readerKey);
                if (innerCache == null) {
                    innerCache = new HashMap<Entry, Object>();
                    this.readerCache.put(readerKey, innerCache);
                    this.wrapper.initReader(reader);
                }
                if (innerCache.get(key) == null) {
                    innerCache.put(key, value);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object get(AtomicReader reader, Entry key, boolean setDocsWithField) throws IOException {
            Object value;
            Map<Entry, Object> innerCache;
            Object readerKey = reader.getCoreCacheKey();
            Object object = this.readerCache;
            synchronized (object) {
                innerCache = this.readerCache.get(readerKey);
                if (innerCache == null) {
                    innerCache = new HashMap<Entry, Object>();
                    this.readerCache.put(readerKey, innerCache);
                    this.wrapper.initReader(reader);
                    value = null;
                } else {
                    value = innerCache.get(key);
                }
                if (value == null) {
                    value = new FieldCache.CreationPlaceholder();
                    innerCache.put(key, value);
                }
            }
            if (value instanceof FieldCache.CreationPlaceholder) {
                object = value;
                synchronized (object) {
                    FieldCache.CreationPlaceholder progress = (FieldCache.CreationPlaceholder)value;
                    if (progress.value == null) {
                        PrintStream infoStream;
                        progress.value = this.createValue(reader, key, setDocsWithField);
                        Map<Object, Map<Entry, Object>> map = this.readerCache;
                        synchronized (map) {
                            innerCache.put(key, progress.value);
                        }
                        if (key.custom != null && this.wrapper != null && (infoStream = this.wrapper.getInfoStream()) != null) {
                            this.printNewInsanity(infoStream, progress.value);
                        }
                    }
                    return progress.value;
                }
            }
            return value;
        }

        private void printNewInsanity(PrintStream infoStream, Object value) {
            FieldCacheSanityChecker.Insanity[] insanities = FieldCacheSanityChecker.checkSanity(this.wrapper);
            block0: for (int i = 0; i < insanities.length; ++i) {
                FieldCacheSanityChecker.Insanity insanity = insanities[i];
                FieldCache.CacheEntry[] entries = insanity.getCacheEntries();
                for (int j = 0; j < entries.length; ++j) {
                    if (entries[j].getValue() != value) continue;
                    infoStream.println("WARNING: new FieldCache insanity created\nDetails: " + insanity.toString());
                    infoStream.println("\nStack:\n");
                    new Throwable().printStackTrace(infoStream);
                    continue block0;
                }
            }
        }
    }

    static final class StopFillCacheException
    extends RuntimeException {
        StopFillCacheException() {
        }
    }

    private static final class CacheEntryImpl
    extends FieldCache.CacheEntry {
        private final Object readerKey;
        private final String fieldName;
        private final Class<?> cacheType;
        private final Object custom;
        private final Object value;

        CacheEntryImpl(Object readerKey, String fieldName, Class<?> cacheType, Object custom, Object value) {
            this.readerKey = readerKey;
            this.fieldName = fieldName;
            this.cacheType = cacheType;
            this.custom = custom;
            this.value = value;
        }

        @Override
        public Object getReaderKey() {
            return this.readerKey;
        }

        @Override
        public String getFieldName() {
            return this.fieldName;
        }

        @Override
        public Class<?> getCacheType() {
            return this.cacheType;
        }

        @Override
        public Object getCustom() {
            return this.custom;
        }

        @Override
        public Object getValue() {
            return this.value;
        }
    }
}

