/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.MergeState;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.PriorityQueue;
import org.apache.lucene.util.packed.PackedInts;

public final class SortedBytesMergeUtils {
    private SortedBytesMergeUtils() {
    }

    public static MergeContext init(DocValues.Type type, DocValues[] docValues, Comparator<BytesRef> comp, int mergeDocCount) {
        int size = -1;
        if (type == DocValues.Type.BYTES_FIXED_SORTED) {
            for (DocValues indexDocValues : docValues) {
                if (indexDocValues == null) continue;
                size = indexDocValues.getValueSize();
                break;
            }
            assert (size >= 0);
        }
        return new MergeContext(comp, mergeDocCount, size, type);
    }

    public static List<SortedSourceSlice> buildSlices(int[] docBases, MergeState.DocMap[] docMaps, DocValues[] docValues, MergeContext ctx) throws IOException {
        ArrayList<SortedSourceSlice> slices = new ArrayList<SortedSourceSlice>();
        for (int i = 0; i < docValues.length; ++i) {
            SortedSourceSlice slice;
            DocValues.Source directSource;
            SortedSourceSlice nextSlice = docValues[i] != null && (directSource = docValues[i].getDirectSource()) != null ? (slice = new SortedSourceSlice(i, directSource.asSortedSource(), docBases, ctx.getMergeDocCount(), ctx.docToEntry)) : new SortedSourceSlice(i, new MissingValueSource(ctx), docBases, ctx.getMergeDocCount(), ctx.docToEntry);
            SortedBytesMergeUtils.createOrdMapping(docBases, docMaps, nextSlice);
            slices.add(nextSlice);
        }
        return Collections.unmodifiableList(slices);
    }

    private static void createOrdMapping(int[] docBases, MergeState.DocMap[] docMaps, SortedSourceSlice currentSlice) {
        int readerIdx = currentSlice.readerIdx;
        MergeState.DocMap currentDocMap = docMaps[readerIdx];
        int docBase = currentSlice.docToOrdStart;
        assert (docBase == docBases[readerIdx]);
        if (currentDocMap != null && currentDocMap.hasDeletions()) {
            for (int i = 0; i < currentDocMap.maxDoc(); ++i) {
                int ord;
                int doc = currentDocMap.get(i);
                if (doc == -1) continue;
                currentSlice.docIDToRelativeOrd[docBase + doc] = ord = currentSlice.source.ord(i);
                currentSlice.ordMapping[ord] = ord + 1;
            }
        } else {
            int numDocs = currentSlice.docToOrdEnd - currentSlice.docToOrdStart;
            for (int doc = 0; doc < numDocs; ++doc) {
                int ord;
                currentSlice.docIDToRelativeOrd[docBase + doc] = ord = currentSlice.source.ord(doc);
                currentSlice.ordMapping[ord] = ord + 1;
            }
        }
    }

    public static int mergeRecords(MergeContext ctx, BytesRefConsumer consumer, List<SortedSourceSlice> slices) throws IOException {
        RecordMerger merger = new RecordMerger(new MergeQueue(slices.size(), ctx.comp), slices.toArray(new SortedSourceSlice[0]));
        long[] offsets = ctx.offsets;
        boolean recordOffsets = offsets != null;
        long offset = 0L;
        merger.pushTop();
        while (merger.queue.size() > 0) {
            merger.pullTop();
            BytesRef currentMergedBytes = merger.current;
            assert (ctx.sizePerValues == -1 || ctx.sizePerValues == currentMergedBytes.length) : "size: " + ctx.sizePerValues + " spare: " + currentMergedBytes.length;
            offset += (long)currentMergedBytes.length;
            if (recordOffsets) {
                if (merger.currentOrd >= offsets.length) {
                    offsets = ArrayUtil.grow(offsets, merger.currentOrd + 1);
                }
                offsets[merger.currentOrd] = offset;
            }
            consumer.consume(currentMergedBytes, merger.currentOrd, offset);
            merger.pushTop();
        }
        ctx.offsets = offsets;
        assert (offsets == null || offsets[merger.currentOrd - 1] == offset);
        return merger.currentOrd;
    }

    private static final class MergeQueue
    extends PriorityQueue<SortedSourceSlice> {
        final Comparator<BytesRef> comp;

        public MergeQueue(int maxSize, Comparator<BytesRef> comp) {
            super(maxSize);
            this.comp = comp;
        }

        @Override
        protected boolean lessThan(SortedSourceSlice a, SortedSourceSlice b) {
            int cmp = this.comp.compare(a.current, b.current);
            if (cmp != 0) {
                return cmp < 0;
            }
            return a.docToOrdStart < b.docToOrdStart;
        }
    }

    private static final class MissingValueSource
    extends DocValues.SortedSource {
        private BytesRef missingValue;

        public MissingValueSource(MergeContext ctx) {
            super(ctx.type, ctx.comp);
            this.missingValue = ctx.missingValue;
        }

        @Override
        public int ord(int docID) {
            return 0;
        }

        @Override
        public BytesRef getByOrd(int ord, BytesRef bytesRef) {
            bytesRef.copyBytes(this.missingValue);
            return bytesRef;
        }

        @Override
        public PackedInts.Reader getDocToOrd() {
            return null;
        }

        @Override
        public int getValueCount() {
            return 1;
        }
    }

    public static class SortedSourceSlice {
        final DocValues.SortedSource source;
        final int readerIdx;
        final int[] docIDToRelativeOrd;
        final int[] ordMapping;
        final int docToOrdStart;
        final int docToOrdEnd;
        BytesRef current = new BytesRef();
        int relativeOrd = -1;

        SortedSourceSlice(int readerIdx, DocValues.SortedSource source, int[] docBase, int mergeDocCount, int[] docToOrd) {
            this.readerIdx = readerIdx;
            this.source = source;
            this.docIDToRelativeOrd = docToOrd;
            this.ordMapping = new int[source.getValueCount()];
            this.docToOrdStart = docBase[readerIdx];
            this.docToOrdEnd = this.docToOrdStart + SortedSourceSlice.numDocs(docBase, mergeDocCount, readerIdx);
        }

        private static int numDocs(int[] docBase, int mergedDocCount, int readerIndex) {
            if (readerIndex == docBase.length - 1) {
                return mergedDocCount - docBase[readerIndex];
            }
            return docBase[readerIndex + 1] - docBase[readerIndex];
        }

        BytesRef next() {
            for (int i = this.relativeOrd + 1; i < this.ordMapping.length; ++i) {
                if (this.ordMapping[i] == 0) continue;
                this.source.getByOrd(i, this.current);
                this.relativeOrd = i;
                return this.current;
            }
            return null;
        }

        public int[] toAbsolutOrds(int[] docToOrd) {
            for (int i = this.docToOrdStart; i < this.docToOrdEnd; ++i) {
                int mappedOrd = this.docIDToRelativeOrd[i];
                assert (mappedOrd < this.ordMapping.length);
                assert (this.ordMapping[mappedOrd] > 0) : "illegal mapping ord maps to an unreferenced value";
                docToOrd[i] = this.ordMapping[mappedOrd] - 1;
            }
            return docToOrd;
        }

        public void writeOrds(PackedInts.Writer writer) throws IOException {
            for (int i = this.docToOrdStart; i < this.docToOrdEnd; ++i) {
                int mappedOrd = this.docIDToRelativeOrd[i];
                assert (mappedOrd < this.ordMapping.length);
                assert (this.ordMapping[mappedOrd] > 0) : "illegal mapping ord maps to an unreferenced value";
                writer.add(this.ordMapping[mappedOrd] - 1);
            }
        }
    }

    private static final class RecordMerger {
        private final MergeQueue queue;
        private final SortedSourceSlice[] top;
        private int numTop;
        BytesRef current;
        int currentOrd = -1;

        RecordMerger(MergeQueue queue, SortedSourceSlice[] top) {
            this.queue = queue;
            this.top = top;
            this.numTop = top.length;
        }

        private void pullTop() {
            assert (this.numTop == 0);
            assert (this.currentOrd >= 0);
            do {
                SortedSourceSlice sortedSourceSlice = (SortedSourceSlice)this.queue.pop();
                this.top[this.numTop++] = sortedSourceSlice;
                SortedSourceSlice popped = sortedSourceSlice;
                popped.ordMapping[popped.relativeOrd] = this.currentOrd + 1;
            } while (this.queue.size() != 0 && ((SortedSourceSlice)this.queue.top()).current.bytesEquals(this.top[0].current));
            this.current = this.top[0].current;
        }

        private void pushTop() throws IOException {
            for (int i = 0; i < this.numTop; ++i) {
                this.top[i].current = this.top[i].next();
                if (this.top[i].current == null) continue;
                this.queue.add(this.top[i]);
            }
            ++this.currentOrd;
            this.numTop = 0;
        }
    }

    public static final class IndexOutputBytesRefConsumer
    implements BytesRefConsumer {
        private final IndexOutput datOut;

        public IndexOutputBytesRefConsumer(IndexOutput datOut) {
            this.datOut = datOut;
        }

        @Override
        public void consume(BytesRef currentMergedBytes, int ord, long offset) throws IOException {
            this.datOut.writeBytes(currentMergedBytes.bytes, currentMergedBytes.offset, currentMergedBytes.length);
        }
    }

    public static interface BytesRefConsumer {
        public void consume(BytesRef var1, int var2, long var3) throws IOException;
    }

    public static final class MergeContext {
        private final Comparator<BytesRef> comp;
        private final BytesRef missingValue = new BytesRef();
        public final int sizePerValues;
        final DocValues.Type type;
        public final int[] docToEntry;
        public long[] offsets;

        public MergeContext(Comparator<BytesRef> comp, int mergeDocCount, int size, DocValues.Type type) {
            assert (type == DocValues.Type.BYTES_FIXED_SORTED || type == DocValues.Type.BYTES_VAR_SORTED);
            this.comp = comp;
            this.sizePerValues = size;
            this.type = type;
            if (size > 0) {
                this.missingValue.grow(size);
                this.missingValue.length = size;
            }
            this.docToEntry = new int[mergeDocCount];
        }

        public int getMergeDocCount() {
            return this.docToEntry.length;
        }
    }
}

