/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import org.apache.lucene.index.DocsAndPositionsEnum;
import org.apache.lucene.index.MultiTermsEnum;
import org.apache.lucene.index.ReaderSlice;
import org.apache.lucene.util.BytesRef;

public final class MultiDocsAndPositionsEnum
extends DocsAndPositionsEnum {
    private final MultiTermsEnum parent;
    final DocsAndPositionsEnum[] subDocsAndPositionsEnum;
    private EnumWithSlice[] subs;
    int numSubs;
    int upto;
    DocsAndPositionsEnum current;
    int currentBase;
    int doc = -1;

    public MultiDocsAndPositionsEnum(MultiTermsEnum parent, int subReaderCount) {
        this.parent = parent;
        this.subDocsAndPositionsEnum = new DocsAndPositionsEnum[subReaderCount];
    }

    public boolean canReuse(MultiTermsEnum parent) {
        return this.parent == parent;
    }

    public MultiDocsAndPositionsEnum reset(EnumWithSlice[] subs, int numSubs) throws IOException {
        this.numSubs = numSubs;
        this.subs = new EnumWithSlice[subs.length];
        for (int i = 0; i < subs.length; ++i) {
            this.subs[i] = new EnumWithSlice();
            this.subs[i].docsAndPositionsEnum = subs[i].docsAndPositionsEnum;
            this.subs[i].slice = subs[i].slice;
        }
        this.upto = -1;
        this.current = null;
        return this;
    }

    public int getNumSubs() {
        return this.numSubs;
    }

    public EnumWithSlice[] getSubs() {
        return this.subs;
    }

    @Override
    public int freq() throws IOException {
        return this.current.freq();
    }

    @Override
    public int docID() {
        return this.doc;
    }

    @Override
    public int advance(int target) throws IOException {
        while (true) {
            if (this.current != null) {
                int doc = this.current.advance(target - this.currentBase);
                if (doc == Integer.MAX_VALUE) {
                    this.current = null;
                    continue;
                }
                this.doc = doc + this.currentBase;
                return this.doc;
            }
            if (this.upto == this.numSubs - 1) {
                this.doc = Integer.MAX_VALUE;
                return Integer.MAX_VALUE;
            }
            ++this.upto;
            this.current = this.subs[this.upto].docsAndPositionsEnum;
            this.currentBase = this.subs[this.upto].slice.start;
        }
    }

    @Override
    public int nextDoc() throws IOException {
        while (true) {
            int doc;
            if (this.current == null) {
                if (this.upto == this.numSubs - 1) {
                    this.doc = Integer.MAX_VALUE;
                    return Integer.MAX_VALUE;
                }
                ++this.upto;
                this.current = this.subs[this.upto].docsAndPositionsEnum;
                this.currentBase = this.subs[this.upto].slice.start;
            }
            if ((doc = this.current.nextDoc()) != Integer.MAX_VALUE) {
                this.doc = this.currentBase + doc;
                return this.doc;
            }
            this.current = null;
        }
    }

    @Override
    public int nextPosition() throws IOException {
        return this.current.nextPosition();
    }

    @Override
    public int startOffset() throws IOException {
        return this.current.startOffset();
    }

    @Override
    public int endOffset() throws IOException {
        return this.current.endOffset();
    }

    @Override
    public boolean hasPayload() {
        return this.current.hasPayload();
    }

    @Override
    public BytesRef getPayload() throws IOException {
        return this.current.getPayload();
    }

    public static final class EnumWithSlice {
        public DocsAndPositionsEnum docsAndPositionsEnum;
        public ReaderSlice slice;
    }
}

