/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.simpletext;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import org.apache.lucene.codecs.SegmentInfoReader;
import org.apache.lucene.codecs.simpletext.SimpleTextSegmentInfoWriter;
import org.apache.lucene.codecs.simpletext.SimpleTextUtil;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.StringHelper;

public class SimpleTextSegmentInfoReader
extends SegmentInfoReader {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SegmentInfo read(Directory directory, String segmentName, IOContext context) throws IOException {
        SegmentInfo segmentInfo;
        block19: {
            IndexInput input;
            block18: {
                BytesRef scratch = new BytesRef();
                String segFileName = IndexFileNames.segmentFileName(segmentName, "", "si");
                input = directory.openInput(segFileName, context);
                boolean success = false;
                try {
                    SimpleTextUtil.readLine(input, scratch);
                    assert (StringHelper.startsWith(scratch, SimpleTextSegmentInfoWriter.SI_VERSION));
                    String version = this.readString(SimpleTextSegmentInfoWriter.SI_VERSION.length, scratch);
                    SimpleTextUtil.readLine(input, scratch);
                    assert (StringHelper.startsWith(scratch, SimpleTextSegmentInfoWriter.SI_DOCCOUNT));
                    int docCount = Integer.parseInt(this.readString(SimpleTextSegmentInfoWriter.SI_DOCCOUNT.length, scratch));
                    SimpleTextUtil.readLine(input, scratch);
                    assert (StringHelper.startsWith(scratch, SimpleTextSegmentInfoWriter.SI_USECOMPOUND));
                    boolean isCompoundFile = Boolean.parseBoolean(this.readString(SimpleTextSegmentInfoWriter.SI_USECOMPOUND.length, scratch));
                    SimpleTextUtil.readLine(input, scratch);
                    assert (StringHelper.startsWith(scratch, SimpleTextSegmentInfoWriter.SI_NUM_DIAG));
                    int numDiag = Integer.parseInt(this.readString(SimpleTextSegmentInfoWriter.SI_NUM_DIAG.length, scratch));
                    HashMap<String, String> diagnostics = new HashMap<String, String>();
                    for (int i = 0; i < numDiag; ++i) {
                        SimpleTextUtil.readLine(input, scratch);
                        assert (StringHelper.startsWith(scratch, SimpleTextSegmentInfoWriter.SI_DIAG_KEY));
                        String key = this.readString(SimpleTextSegmentInfoWriter.SI_DIAG_KEY.length, scratch);
                        SimpleTextUtil.readLine(input, scratch);
                        assert (StringHelper.startsWith(scratch, SimpleTextSegmentInfoWriter.SI_DIAG_VALUE));
                        String value = this.readString(SimpleTextSegmentInfoWriter.SI_DIAG_VALUE.length, scratch);
                        diagnostics.put(key, value);
                    }
                    SimpleTextUtil.readLine(input, scratch);
                    assert (StringHelper.startsWith(scratch, SimpleTextSegmentInfoWriter.SI_NUM_ATTS));
                    int numAtts = Integer.parseInt(this.readString(SimpleTextSegmentInfoWriter.SI_NUM_ATTS.length, scratch));
                    HashMap<String, String> attributes = new HashMap<String, String>();
                    for (int i = 0; i < numAtts; ++i) {
                        SimpleTextUtil.readLine(input, scratch);
                        assert (StringHelper.startsWith(scratch, SimpleTextSegmentInfoWriter.SI_ATT_KEY));
                        String key = this.readString(SimpleTextSegmentInfoWriter.SI_ATT_KEY.length, scratch);
                        SimpleTextUtil.readLine(input, scratch);
                        assert (StringHelper.startsWith(scratch, SimpleTextSegmentInfoWriter.SI_ATT_VALUE));
                        String value = this.readString(SimpleTextSegmentInfoWriter.SI_ATT_VALUE.length, scratch);
                        attributes.put(key, value);
                    }
                    SimpleTextUtil.readLine(input, scratch);
                    assert (StringHelper.startsWith(scratch, SimpleTextSegmentInfoWriter.SI_NUM_FILES));
                    int numFiles = Integer.parseInt(this.readString(SimpleTextSegmentInfoWriter.SI_NUM_FILES.length, scratch));
                    HashSet<String> files = new HashSet<String>();
                    for (int i = 0; i < numFiles; ++i) {
                        SimpleTextUtil.readLine(input, scratch);
                        assert (StringHelper.startsWith(scratch, SimpleTextSegmentInfoWriter.SI_FILE));
                        String fileName = this.readString(SimpleTextSegmentInfoWriter.SI_FILE.length, scratch);
                        files.add(fileName);
                    }
                    SegmentInfo info = new SegmentInfo(directory, version, segmentName, docCount, isCompoundFile, null, diagnostics, Collections.unmodifiableMap(attributes));
                    info.setFiles(files);
                    success = true;
                    segmentInfo = info;
                    if (success) break block18;
                }
                catch (Throwable throwable) {
                    if (!success) {
                        IOUtils.closeWhileHandlingException(input);
                    } else {
                        input.close();
                    }
                    throw throwable;
                }
                IOUtils.closeWhileHandlingException(input);
                break block19;
            }
            input.close();
        }
        return segmentInfo;
    }

    private String readString(int offset, BytesRef scratch) {
        return new String(scratch.bytes, scratch.offset + offset, scratch.length - offset, IOUtils.CHARSET_UTF_8);
    }
}

