/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.simpletext;

import java.io.IOException;
import java.util.Comparator;
import org.apache.lucene.codecs.NormsFormat;
import org.apache.lucene.codecs.PerDocConsumer;
import org.apache.lucene.codecs.PerDocProducer;
import org.apache.lucene.codecs.simpletext.SimpleTextPerDocConsumer;
import org.apache.lucene.codecs.simpletext.SimpleTextPerDocProducer;
import org.apache.lucene.index.AtomicReader;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.PerDocWriteState;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.util.BytesRef;

public class SimpleTextNormsFormat
extends NormsFormat {
    private static final String NORMS_SEG_SUFFIX = "len";

    @Override
    public PerDocConsumer docsConsumer(PerDocWriteState state) throws IOException {
        return new SimpleTextNormsPerDocConsumer(state);
    }

    @Override
    public PerDocProducer docsProducer(SegmentReadState state) throws IOException {
        return new SimpleTextNormsPerDocProducer(state, BytesRef.getUTF8SortedAsUnicodeComparator());
    }

    public static class SimpleTextNormsPerDocConsumer
    extends SimpleTextPerDocConsumer {
        public SimpleTextNormsPerDocConsumer(PerDocWriteState state) throws IOException {
            super(state, SimpleTextNormsFormat.NORMS_SEG_SUFFIX);
        }

        @Override
        protected DocValues getDocValuesForMerge(AtomicReader reader, FieldInfo info) throws IOException {
            return reader.normValues(info.name);
        }

        @Override
        protected boolean canMerge(FieldInfo info) {
            return info.hasNorms();
        }

        @Override
        protected DocValues.Type getDocValuesType(FieldInfo info) {
            return info.getNormType();
        }

        @Override
        public void abort() {
        }
    }

    public static class SimpleTextNormsPerDocProducer
    extends SimpleTextPerDocProducer {
        public SimpleTextNormsPerDocProducer(SegmentReadState state, Comparator<BytesRef> comp) throws IOException {
            super(state, comp, SimpleTextNormsFormat.NORMS_SEG_SUFFIX);
        }

        @Override
        protected boolean canLoad(FieldInfo info) {
            return info.hasNorms();
        }

        @Override
        protected DocValues.Type getDocValuesType(FieldInfo info) {
            return info.getNormType();
        }

        @Override
        protected boolean anyDocValuesFields(FieldInfos infos) {
            return infos.hasNorms();
        }
    }
}

