/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.simpletext;

import java.io.IOException;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.codecs.FieldsProducer;
import org.apache.lucene.codecs.simpletext.SimpleTextFieldsWriter;
import org.apache.lucene.codecs.simpletext.SimpleTextPostingsFormat;
import org.apache.lucene.codecs.simpletext.SimpleTextUtil;
import org.apache.lucene.index.DocsAndPositionsEnum;
import org.apache.lucene.index.DocsEnum;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.FieldsEnum;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.CharsRef;
import org.apache.lucene.util.IntsRef;
import org.apache.lucene.util.OpenBitSet;
import org.apache.lucene.util.StringHelper;
import org.apache.lucene.util.UnicodeUtil;
import org.apache.lucene.util.fst.Builder;
import org.apache.lucene.util.fst.BytesRefFSTEnum;
import org.apache.lucene.util.fst.FST;
import org.apache.lucene.util.fst.PairOutputs;
import org.apache.lucene.util.fst.PositiveIntOutputs;
import org.apache.lucene.util.fst.Util;

class SimpleTextFieldsReader
extends FieldsProducer {
    private final IndexInput in;
    private final FieldInfos fieldInfos;
    static final BytesRef END = SimpleTextFieldsWriter.END;
    static final BytesRef FIELD = SimpleTextFieldsWriter.FIELD;
    static final BytesRef TERM = SimpleTextFieldsWriter.TERM;
    static final BytesRef DOC = SimpleTextFieldsWriter.DOC;
    static final BytesRef FREQ = SimpleTextFieldsWriter.FREQ;
    static final BytesRef POS = SimpleTextFieldsWriter.POS;
    static final BytesRef START_OFFSET = SimpleTextFieldsWriter.START_OFFSET;
    static final BytesRef END_OFFSET = SimpleTextFieldsWriter.END_OFFSET;
    static final BytesRef PAYLOAD = SimpleTextFieldsWriter.PAYLOAD;
    private final Map<String, Terms> termsCache = new HashMap<String, Terms>();

    public SimpleTextFieldsReader(SegmentReadState state) throws IOException {
        this.in = state.dir.openInput(SimpleTextPostingsFormat.getPostingsFileName(state.segmentInfo.name, state.segmentSuffix), state.context);
        this.fieldInfos = state.fieldInfos;
    }

    @Override
    public FieldsEnum iterator() throws IOException {
        return new SimpleTextFieldsEnum();
    }

    @Override
    public synchronized Terms terms(String field) throws IOException {
        Terms terms = this.termsCache.get(field);
        if (terms == null) {
            String fieldUpto;
            SimpleTextFieldsEnum fe = (SimpleTextFieldsEnum)this.iterator();
            while ((fieldUpto = fe.next()) != null) {
                if (!fieldUpto.equals(field)) continue;
                terms = new SimpleTextTerms(field, fe.in.getFilePointer());
                break;
            }
            this.termsCache.put(field, terms);
        }
        return terms;
    }

    @Override
    public int size() {
        return -1;
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }

    private class SimpleTextTerms
    extends Terms {
        private final long termsStart;
        private final FieldInfo.IndexOptions indexOptions;
        private long sumTotalTermFreq;
        private long sumDocFreq;
        private int docCount;
        private FST<PairOutputs.Pair<Long, PairOutputs.Pair<Long, Long>>> fst;
        private int termCount;
        private final BytesRef scratch = new BytesRef(10);
        private final CharsRef scratchUTF16 = new CharsRef(10);

        public SimpleTextTerms(String field, long termsStart) throws IOException {
            this.termsStart = termsStart;
            this.indexOptions = SimpleTextFieldsReader.this.fieldInfos.fieldInfo(field).getIndexOptions();
            this.loadTerms();
        }

        private void loadTerms() throws IOException {
            PositiveIntOutputs posIntOutputs = PositiveIntOutputs.getSingleton(false);
            PairOutputs<Long, Long> outputsInner = new PairOutputs<Long, Long>(posIntOutputs, posIntOutputs);
            PairOutputs<Long, PairOutputs.Pair<Long, Long>> outputs = new PairOutputs<Long, PairOutputs.Pair<Long, Long>>(posIntOutputs, outputsInner);
            Builder<PairOutputs.Pair<Long, PairOutputs.Pair<Long, Long>>> b = new Builder<PairOutputs.Pair<Long, PairOutputs.Pair<Long, Long>>>(FST.INPUT_TYPE.BYTE1, outputs);
            IndexInput in = (IndexInput)SimpleTextFieldsReader.this.in.clone();
            in.seek(this.termsStart);
            BytesRef lastTerm = new BytesRef(10);
            long lastDocsStart = -1L;
            int docFreq = 0;
            long totalTermFreq = 0L;
            OpenBitSet visitedDocs = new OpenBitSet();
            IntsRef scratchIntsRef = new IntsRef();
            while (true) {
                SimpleTextUtil.readLine(in, this.scratch);
                if (this.scratch.equals(END) || StringHelper.startsWith(this.scratch, FIELD)) {
                    if (lastDocsStart == -1L) break;
                    b.add(Util.toIntsRef(lastTerm, scratchIntsRef), outputs.newPair(lastDocsStart, outputsInner.newPair(Long.valueOf(docFreq), totalTermFreq)));
                    this.sumTotalTermFreq += totalTermFreq;
                    break;
                }
                if (StringHelper.startsWith(this.scratch, DOC)) {
                    ++docFreq;
                    ++this.sumDocFreq;
                    UnicodeUtil.UTF8toUTF16(this.scratch.bytes, this.scratch.offset + SimpleTextFieldsReader.DOC.length, this.scratch.length - SimpleTextFieldsReader.DOC.length, this.scratchUTF16);
                    int docID = ArrayUtil.parseInt(this.scratchUTF16.chars, 0, this.scratchUTF16.length);
                    visitedDocs.set(docID);
                    continue;
                }
                if (StringHelper.startsWith(this.scratch, FREQ)) {
                    UnicodeUtil.UTF8toUTF16(this.scratch.bytes, this.scratch.offset + SimpleTextFieldsReader.FREQ.length, this.scratch.length - SimpleTextFieldsReader.FREQ.length, this.scratchUTF16);
                    totalTermFreq += (long)ArrayUtil.parseInt(this.scratchUTF16.chars, 0, this.scratchUTF16.length);
                    continue;
                }
                if (!StringHelper.startsWith(this.scratch, TERM)) continue;
                if (lastDocsStart != -1L) {
                    b.add(Util.toIntsRef(lastTerm, scratchIntsRef), outputs.newPair(lastDocsStart, outputsInner.newPair(Long.valueOf(docFreq), totalTermFreq)));
                }
                lastDocsStart = in.getFilePointer();
                int len = this.scratch.length - SimpleTextFieldsReader.TERM.length;
                if (len > lastTerm.length) {
                    lastTerm.grow(len);
                }
                System.arraycopy(this.scratch.bytes, SimpleTextFieldsReader.TERM.length, lastTerm.bytes, 0, len);
                lastTerm.length = len;
                docFreq = 0;
                this.sumTotalTermFreq += totalTermFreq;
                totalTermFreq = 0L;
                ++this.termCount;
            }
            this.docCount = (int)visitedDocs.cardinality();
            this.fst = b.finish();
        }

        @Override
        public TermsEnum iterator(TermsEnum reuse) throws IOException {
            if (this.fst != null) {
                return new SimpleTextTermsEnum(this.fst, this.indexOptions);
            }
            return TermsEnum.EMPTY;
        }

        @Override
        public Comparator<BytesRef> getComparator() {
            return BytesRef.getUTF8SortedAsUnicodeComparator();
        }

        @Override
        public long size() {
            return this.termCount;
        }

        @Override
        public long getSumTotalTermFreq() {
            return this.indexOptions == FieldInfo.IndexOptions.DOCS_ONLY ? -1L : this.sumTotalTermFreq;
        }

        @Override
        public long getSumDocFreq() throws IOException {
            return this.sumDocFreq;
        }

        @Override
        public int getDocCount() throws IOException {
            return this.docCount;
        }
    }

    static class TermData {
        public long docsStart;
        public int docFreq;

        public TermData(long docsStart, int docFreq) {
            this.docsStart = docsStart;
            this.docFreq = docFreq;
        }
    }

    private class SimpleTextDocsAndPositionsEnum
    extends DocsAndPositionsEnum {
        private final IndexInput inStart;
        private final IndexInput in;
        private int docID = -1;
        private int tf;
        private Bits liveDocs;
        private final BytesRef scratch = new BytesRef(10);
        private final BytesRef scratch2 = new BytesRef(10);
        private final CharsRef scratchUTF16 = new CharsRef(10);
        private final CharsRef scratchUTF16_2 = new CharsRef(10);
        private BytesRef payload;
        private long nextDocStart;
        private boolean readOffsets;
        private boolean readPositions;
        private int startOffset = -1;
        private int endOffset = -1;

        public SimpleTextDocsAndPositionsEnum() {
            this.inStart = SimpleTextFieldsReader.this.in;
            this.in = (IndexInput)this.inStart.clone();
        }

        public boolean canReuse(IndexInput in) {
            return in == this.inStart;
        }

        public SimpleTextDocsAndPositionsEnum reset(long fp, Bits liveDocs, FieldInfo.IndexOptions indexOptions) {
            this.liveDocs = liveDocs;
            this.nextDocStart = fp;
            this.docID = -1;
            this.readPositions = indexOptions.compareTo(FieldInfo.IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) >= 0;
            this.readOffsets = indexOptions.compareTo(FieldInfo.IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS) >= 0;
            return this;
        }

        @Override
        public int docID() {
            return this.docID;
        }

        @Override
        public int freq() throws IOException {
            return this.tf;
        }

        @Override
        public int nextDoc() throws IOException {
            long lineStart;
            boolean first = true;
            this.in.seek(this.nextDocStart);
            long posStart = 0L;
            while (true) {
                lineStart = this.in.getFilePointer();
                SimpleTextUtil.readLine(this.in, this.scratch);
                if (StringHelper.startsWith(this.scratch, DOC)) {
                    if (!first && (this.liveDocs == null || this.liveDocs.get(this.docID))) {
                        this.nextDocStart = lineStart;
                        this.in.seek(posStart);
                        return this.docID;
                    }
                    UnicodeUtil.UTF8toUTF16(this.scratch.bytes, this.scratch.offset + SimpleTextFieldsReader.DOC.length, this.scratch.length - SimpleTextFieldsReader.DOC.length, this.scratchUTF16);
                    this.docID = ArrayUtil.parseInt(this.scratchUTF16.chars, 0, this.scratchUTF16.length);
                    this.tf = 0;
                    first = false;
                    continue;
                }
                if (StringHelper.startsWith(this.scratch, FREQ)) {
                    UnicodeUtil.UTF8toUTF16(this.scratch.bytes, this.scratch.offset + SimpleTextFieldsReader.FREQ.length, this.scratch.length - SimpleTextFieldsReader.FREQ.length, this.scratchUTF16);
                    this.tf = ArrayUtil.parseInt(this.scratchUTF16.chars, 0, this.scratchUTF16.length);
                    posStart = this.in.getFilePointer();
                    continue;
                }
                if (!(StringHelper.startsWith(this.scratch, POS) || StringHelper.startsWith(this.scratch, START_OFFSET) || StringHelper.startsWith(this.scratch, END_OFFSET) || StringHelper.startsWith(this.scratch, PAYLOAD))) break;
            }
            assert (StringHelper.startsWith(this.scratch, TERM) || StringHelper.startsWith(this.scratch, FIELD) || StringHelper.startsWith(this.scratch, END));
            if (!first && (this.liveDocs == null || this.liveDocs.get(this.docID))) {
                this.nextDocStart = lineStart;
                this.in.seek(posStart);
                return this.docID;
            }
            this.docID = Integer.MAX_VALUE;
            return Integer.MAX_VALUE;
        }

        @Override
        public int advance(int target) throws IOException {
            while (this.nextDoc() < target) {
            }
            return this.docID;
        }

        @Override
        public int nextPosition() throws IOException {
            int pos;
            if (this.readPositions) {
                SimpleTextUtil.readLine(this.in, this.scratch);
                assert (StringHelper.startsWith(this.scratch, POS)) : "got line=" + this.scratch.utf8ToString();
                UnicodeUtil.UTF8toUTF16(this.scratch.bytes, this.scratch.offset + SimpleTextFieldsReader.POS.length, this.scratch.length - SimpleTextFieldsReader.POS.length, this.scratchUTF16_2);
                pos = ArrayUtil.parseInt(this.scratchUTF16_2.chars, 0, this.scratchUTF16_2.length);
            } else {
                pos = -1;
            }
            if (this.readOffsets) {
                SimpleTextUtil.readLine(this.in, this.scratch);
                assert (StringHelper.startsWith(this.scratch, START_OFFSET)) : "got line=" + this.scratch.utf8ToString();
                UnicodeUtil.UTF8toUTF16(this.scratch.bytes, this.scratch.offset + SimpleTextFieldsReader.START_OFFSET.length, this.scratch.length - SimpleTextFieldsReader.START_OFFSET.length, this.scratchUTF16_2);
                this.startOffset = ArrayUtil.parseInt(this.scratchUTF16_2.chars, 0, this.scratchUTF16_2.length);
                SimpleTextUtil.readLine(this.in, this.scratch);
                assert (StringHelper.startsWith(this.scratch, END_OFFSET)) : "got line=" + this.scratch.utf8ToString();
                UnicodeUtil.UTF8toUTF16(this.scratch.bytes, this.scratch.offset + SimpleTextFieldsReader.END_OFFSET.length, this.scratch.length - SimpleTextFieldsReader.END_OFFSET.length, this.scratchUTF16_2);
                this.endOffset = ArrayUtil.parseInt(this.scratchUTF16_2.chars, 0, this.scratchUTF16_2.length);
            }
            long fp = this.in.getFilePointer();
            SimpleTextUtil.readLine(this.in, this.scratch);
            if (StringHelper.startsWith(this.scratch, PAYLOAD)) {
                int len = this.scratch.length - SimpleTextFieldsReader.PAYLOAD.length;
                if (this.scratch2.bytes.length < len) {
                    this.scratch2.grow(len);
                }
                System.arraycopy(this.scratch.bytes, SimpleTextFieldsReader.PAYLOAD.length, this.scratch2.bytes, 0, len);
                this.scratch2.length = len;
                this.payload = this.scratch2;
            } else {
                this.payload = null;
                this.in.seek(fp);
            }
            return pos;
        }

        @Override
        public int startOffset() throws IOException {
            return this.startOffset;
        }

        @Override
        public int endOffset() throws IOException {
            return this.endOffset;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public BytesRef getPayload() {
            try {
                BytesRef bytesRef = this.payload;
                return bytesRef;
            }
            finally {
                this.payload = null;
            }
        }

        @Override
        public boolean hasPayload() {
            return this.payload != null;
        }
    }

    private class SimpleTextDocsEnum
    extends DocsEnum {
        private final IndexInput inStart;
        private final IndexInput in;
        private boolean omitTF;
        private int docID = -1;
        private int tf;
        private Bits liveDocs;
        private final BytesRef scratch = new BytesRef(10);
        private final CharsRef scratchUTF16 = new CharsRef(10);

        public SimpleTextDocsEnum() {
            this.inStart = SimpleTextFieldsReader.this.in;
            this.in = (IndexInput)this.inStart.clone();
        }

        public boolean canReuse(IndexInput in) {
            return in == this.inStart;
        }

        public SimpleTextDocsEnum reset(long fp, Bits liveDocs, boolean omitTF) throws IOException {
            this.liveDocs = liveDocs;
            this.in.seek(fp);
            this.omitTF = omitTF;
            this.docID = -1;
            return this;
        }

        @Override
        public int docID() {
            return this.docID;
        }

        @Override
        public int freq() throws IOException {
            assert (!this.omitTF);
            return this.tf;
        }

        @Override
        public int nextDoc() throws IOException {
            long lineStart;
            if (this.docID == Integer.MAX_VALUE) {
                return this.docID;
            }
            boolean first = true;
            int termFreq = 0;
            while (true) {
                lineStart = this.in.getFilePointer();
                SimpleTextUtil.readLine(this.in, this.scratch);
                if (StringHelper.startsWith(this.scratch, DOC)) {
                    if (!first && (this.liveDocs == null || this.liveDocs.get(this.docID))) {
                        this.in.seek(lineStart);
                        if (!this.omitTF) {
                            this.tf = termFreq;
                        }
                        return this.docID;
                    }
                    UnicodeUtil.UTF8toUTF16(this.scratch.bytes, this.scratch.offset + SimpleTextFieldsReader.DOC.length, this.scratch.length - SimpleTextFieldsReader.DOC.length, this.scratchUTF16);
                    this.docID = ArrayUtil.parseInt(this.scratchUTF16.chars, 0, this.scratchUTF16.length);
                    termFreq = 0;
                    first = false;
                    continue;
                }
                if (StringHelper.startsWith(this.scratch, FREQ)) {
                    UnicodeUtil.UTF8toUTF16(this.scratch.bytes, this.scratch.offset + SimpleTextFieldsReader.FREQ.length, this.scratch.length - SimpleTextFieldsReader.FREQ.length, this.scratchUTF16);
                    termFreq = ArrayUtil.parseInt(this.scratchUTF16.chars, 0, this.scratchUTF16.length);
                    continue;
                }
                if (!(StringHelper.startsWith(this.scratch, POS) || StringHelper.startsWith(this.scratch, START_OFFSET) || StringHelper.startsWith(this.scratch, END_OFFSET) || StringHelper.startsWith(this.scratch, PAYLOAD))) break;
            }
            assert (StringHelper.startsWith(this.scratch, TERM) || StringHelper.startsWith(this.scratch, FIELD) || StringHelper.startsWith(this.scratch, END)) : "scratch=" + this.scratch.utf8ToString();
            if (!first && (this.liveDocs == null || this.liveDocs.get(this.docID))) {
                this.in.seek(lineStart);
                if (!this.omitTF) {
                    this.tf = termFreq;
                }
                return this.docID;
            }
            this.docID = Integer.MAX_VALUE;
            return Integer.MAX_VALUE;
        }

        @Override
        public int advance(int target) throws IOException {
            while (this.nextDoc() < target) {
            }
            return this.docID;
        }
    }

    private class SimpleTextTermsEnum
    extends TermsEnum {
        private final FieldInfo.IndexOptions indexOptions;
        private int docFreq;
        private long totalTermFreq;
        private long docsStart;
        private boolean ended;
        private final BytesRefFSTEnum<PairOutputs.Pair<Long, PairOutputs.Pair<Long, Long>>> fstEnum;

        public SimpleTextTermsEnum(FST<PairOutputs.Pair<Long, PairOutputs.Pair<Long, Long>>> fst, FieldInfo.IndexOptions indexOptions) throws IOException {
            this.indexOptions = indexOptions;
            this.fstEnum = new BytesRefFSTEnum<PairOutputs.Pair<Long, PairOutputs.Pair<Long, Long>>>(fst);
        }

        @Override
        public boolean seekExact(BytesRef text, boolean useCache) throws IOException {
            BytesRefFSTEnum.InputOutput<PairOutputs.Pair<Long, PairOutputs.Pair<Long, Long>>> result = this.fstEnum.seekExact(text);
            if (result != null) {
                PairOutputs.Pair pair1 = (PairOutputs.Pair)result.output;
                PairOutputs.Pair pair2 = (PairOutputs.Pair)pair1.output2;
                this.docsStart = (Long)pair1.output1;
                this.docFreq = ((Long)pair2.output1).intValue();
                this.totalTermFreq = (Long)pair2.output2;
                return true;
            }
            return false;
        }

        @Override
        public TermsEnum.SeekStatus seekCeil(BytesRef text, boolean useCache) throws IOException {
            BytesRefFSTEnum.InputOutput<PairOutputs.Pair<Long, PairOutputs.Pair<Long, Long>>> result = this.fstEnum.seekCeil(text);
            if (result == null) {
                return TermsEnum.SeekStatus.END;
            }
            PairOutputs.Pair pair1 = (PairOutputs.Pair)result.output;
            PairOutputs.Pair pair2 = (PairOutputs.Pair)pair1.output2;
            this.docsStart = (Long)pair1.output1;
            this.docFreq = ((Long)pair2.output1).intValue();
            this.totalTermFreq = (Long)pair2.output2;
            if (result.input.equals(text)) {
                return TermsEnum.SeekStatus.FOUND;
            }
            return TermsEnum.SeekStatus.NOT_FOUND;
        }

        @Override
        public BytesRef next() throws IOException {
            assert (!this.ended);
            BytesRefFSTEnum.InputOutput<PairOutputs.Pair<Long, PairOutputs.Pair<Long, Long>>> result = this.fstEnum.next();
            if (result != null) {
                PairOutputs.Pair pair1 = (PairOutputs.Pair)result.output;
                PairOutputs.Pair pair2 = (PairOutputs.Pair)pair1.output2;
                this.docsStart = (Long)pair1.output1;
                this.docFreq = ((Long)pair2.output1).intValue();
                this.totalTermFreq = (Long)pair2.output2;
                return result.input;
            }
            return null;
        }

        @Override
        public BytesRef term() {
            return this.fstEnum.current().input;
        }

        @Override
        public long ord() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void seekExact(long ord) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int docFreq() {
            return this.docFreq;
        }

        @Override
        public long totalTermFreq() {
            return this.indexOptions == FieldInfo.IndexOptions.DOCS_ONLY ? -1L : this.totalTermFreq;
        }

        @Override
        public DocsEnum docs(Bits liveDocs, DocsEnum reuse, boolean needsFreqs) throws IOException {
            if (needsFreqs && this.indexOptions == FieldInfo.IndexOptions.DOCS_ONLY) {
                return null;
            }
            SimpleTextDocsEnum docsEnum = reuse != null && reuse instanceof SimpleTextDocsEnum && ((SimpleTextDocsEnum)reuse).canReuse(SimpleTextFieldsReader.this.in) ? (SimpleTextDocsEnum)reuse : new SimpleTextDocsEnum();
            return docsEnum.reset(this.docsStart, liveDocs, !needsFreqs);
        }

        @Override
        public DocsAndPositionsEnum docsAndPositions(Bits liveDocs, DocsAndPositionsEnum reuse, boolean needsOffsets) throws IOException {
            if (this.indexOptions.compareTo(FieldInfo.IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) < 0) {
                return null;
            }
            if (needsOffsets && this.indexOptions.compareTo(FieldInfo.IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS) < 0) {
                return null;
            }
            SimpleTextDocsAndPositionsEnum docsAndPositionsEnum = reuse != null && reuse instanceof SimpleTextDocsAndPositionsEnum && ((SimpleTextDocsAndPositionsEnum)reuse).canReuse(SimpleTextFieldsReader.this.in) ? (SimpleTextDocsAndPositionsEnum)reuse : new SimpleTextDocsAndPositionsEnum();
            return docsAndPositionsEnum.reset(this.docsStart, liveDocs, this.indexOptions);
        }

        @Override
        public Comparator<BytesRef> getComparator() {
            return BytesRef.getUTF8SortedAsUnicodeComparator();
        }
    }

    private class SimpleTextFieldsEnum
    extends FieldsEnum {
        private final IndexInput in;
        private final BytesRef scratch = new BytesRef(10);
        private String current;

        public SimpleTextFieldsEnum() {
            this.in = (IndexInput)SimpleTextFieldsReader.this.in.clone();
        }

        @Override
        public String next() throws IOException {
            do {
                SimpleTextUtil.readLine(this.in, this.scratch);
                if (!this.scratch.equals(END)) continue;
                this.current = null;
                return null;
            } while (!StringHelper.startsWith(this.scratch, FIELD));
            this.current = new String(this.scratch.bytes, this.scratch.offset + SimpleTextFieldsReader.FIELD.length, this.scratch.length - SimpleTextFieldsReader.FIELD.length, "UTF-8");
            return this.current;
        }

        @Override
        public Terms terms() throws IOException {
            return SimpleTextFieldsReader.this.terms(this.current);
        }
    }
}

