/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.lucene40.values;

import java.io.IOException;
import java.util.Comparator;
import java.util.List;
import org.apache.lucene.codecs.lucene40.values.Bytes;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.MergeState;
import org.apache.lucene.index.SortedBytesMergeUtils;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.Counter;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.packed.PackedInts;

final class VarSortedBytesImpl {
    static final String CODEC_NAME_IDX = "VarDerefBytesIdx";
    static final String CODEC_NAME_DAT = "VarDerefBytesDat";
    static final int VERSION_START = 0;
    static final int VERSION_CURRENT = 0;

    VarSortedBytesImpl() {
    }

    private static final class DirectSortedSource
    extends DocValues.SortedSource {
        private final PackedInts.Reader docToOrdIndex;
        private final PackedInts.Reader ordToOffsetIndex;
        private final IndexInput datIn;
        private final long basePointer;
        private final int valueCount;

        DirectSortedSource(IndexInput datIn, IndexInput idxIn, Comparator<BytesRef> comparator, DocValues.Type type) throws IOException {
            super(type, comparator);
            idxIn.readLong();
            this.ordToOffsetIndex = PackedInts.getDirectReader(idxIn);
            this.valueCount = this.ordToOffsetIndex.size() - 1;
            this.ordToOffsetIndex.get(this.valueCount);
            this.docToOrdIndex = PackedInts.getDirectReader((IndexInput)idxIn.clone());
            this.basePointer = datIn.getFilePointer();
            this.datIn = datIn;
        }

        @Override
        public int ord(int docID) {
            return (int)this.docToOrdIndex.get(docID);
        }

        @Override
        public boolean hasPackedDocToOrd() {
            return true;
        }

        @Override
        public PackedInts.Reader getDocToOrd() {
            return this.docToOrdIndex;
        }

        @Override
        public BytesRef getByOrd(int ord, BytesRef bytesRef) {
            try {
                long offset = this.ordToOffsetIndex.get(ord);
                long nextOffset = this.ordToOffsetIndex.get(1 + ord);
                this.datIn.seek(this.basePointer + offset);
                int length = (int)(nextOffset - offset);
                bytesRef.offset = 0;
                bytesRef.grow(length);
                this.datIn.readBytes(bytesRef.bytes, 0, length);
                bytesRef.length = length;
                return bytesRef;
            }
            catch (IOException ex) {
                throw new IllegalStateException("failed", ex);
            }
        }

        @Override
        public int getValueCount() {
            return this.valueCount;
        }
    }

    private static final class VarSortedSource
    extends Bytes.BytesSortedSourceBase {
        private final int valueCount;

        VarSortedSource(IndexInput datIn, IndexInput idxIn, Comparator<BytesRef> comp) throws IOException {
            super(datIn, idxIn, comp, idxIn.readLong(), DocValues.Type.BYTES_VAR_SORTED, true);
            this.valueCount = this.ordToOffsetIndex.size() - 1;
            this.closeIndexInput();
        }

        @Override
        public BytesRef getByOrd(int ord, BytesRef bytesRef) {
            long offset = this.ordToOffsetIndex.get(ord);
            long nextOffset = this.ordToOffsetIndex.get(1 + ord);
            this.data.fillSlice(bytesRef, offset, (int)(nextOffset - offset));
            return bytesRef;
        }

        @Override
        public int getValueCount() {
            return this.valueCount;
        }
    }

    public static class Reader
    extends Bytes.BytesReaderBase {
        private final Comparator<BytesRef> comparator;

        Reader(Directory dir, String id, int maxDoc, IOContext context, DocValues.Type type, Comparator<BytesRef> comparator) throws IOException {
            super(dir, id, VarSortedBytesImpl.CODEC_NAME_IDX, VarSortedBytesImpl.CODEC_NAME_DAT, 0, true, context, type);
            this.comparator = comparator;
        }

        @Override
        public DocValues.Source load() throws IOException {
            return new VarSortedSource(this.cloneData(), this.cloneIndex(), this.comparator);
        }

        @Override
        public DocValues.Source getDirectSource() throws IOException {
            return new DirectSortedSource(this.cloneData(), this.cloneIndex(), this.comparator, this.getType());
        }
    }

    static final class Writer
    extends Bytes.DerefBytesWriterBase {
        private final Comparator<BytesRef> comp;

        public Writer(Directory dir, String id, Comparator<BytesRef> comp, Counter bytesUsed, IOContext context, float acceptableOverheadRatio) throws IOException {
            super(dir, id, VarSortedBytesImpl.CODEC_NAME_IDX, VarSortedBytesImpl.CODEC_NAME_DAT, 0, bytesUsed, context, acceptableOverheadRatio, DocValues.Type.BYTES_VAR_SORTED);
            this.comp = comp;
            this.size = 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void merge(MergeState mergeState, DocValues[] docValues) throws IOException {
            boolean success = false;
            try {
                SortedBytesMergeUtils.MergeContext ctx = SortedBytesMergeUtils.init(DocValues.Type.BYTES_VAR_SORTED, docValues, this.comp, mergeState.segmentInfo.getDocCount());
                List<SortedBytesMergeUtils.SortedSourceSlice> slices = SortedBytesMergeUtils.buildSlices(mergeState.docBase, mergeState.docMaps, docValues, ctx);
                IndexOutput datOut = this.getOrCreateDataOut();
                ctx.offsets = new long[1];
                int maxOrd = SortedBytesMergeUtils.mergeRecords(ctx, new SortedBytesMergeUtils.IndexOutputBytesRefConsumer(datOut), slices);
                long[] offsets = ctx.offsets;
                this.maxBytes = offsets[maxOrd - 1];
                IndexOutput idxOut = this.getOrCreateIndexOut();
                idxOut.writeLong(this.maxBytes);
                PackedInts.Writer offsetWriter = PackedInts.getWriter(idxOut, maxOrd + 1, PackedInts.bitsRequired(this.maxBytes), 0.2f);
                offsetWriter.add(0L);
                for (int i = 0; i < maxOrd; ++i) {
                    offsetWriter.add(offsets[i]);
                }
                offsetWriter.finish();
                PackedInts.Writer ordsWriter = PackedInts.getWriter(idxOut, ctx.docToEntry.length, PackedInts.bitsRequired(maxOrd - 1), 0.2f);
                for (SortedBytesMergeUtils.SortedSourceSlice slice : slices) {
                    slice.writeOrds(ordsWriter);
                }
                ordsWriter.finish();
                success = true;
            }
            catch (Throwable throwable) {
                this.releaseResources();
                if (success) {
                    IOUtils.close(this.getIndexOut(), this.getDataOut());
                } else {
                    IOUtils.closeWhileHandlingException(this.getIndexOut(), this.getDataOut());
                }
                throw throwable;
            }
            this.releaseResources();
            if (success) {
                IOUtils.close(this.getIndexOut(), this.getDataOut());
            } else {
                IOUtils.closeWhileHandlingException(this.getIndexOut(), this.getDataOut());
            }
        }

        @Override
        protected void checkSize(BytesRef bytes) {
        }

        @Override
        public void finishInternal(int docCount) throws IOException {
            this.fillDefault(docCount);
            int count = this.hash.size();
            IndexOutput datOut = this.getOrCreateDataOut();
            IndexOutput idxOut = this.getOrCreateIndexOut();
            long offset = 0L;
            int[] index = new int[count];
            int[] sortedEntries = this.hash.sort(this.comp);
            idxOut.writeLong(this.maxBytes);
            PackedInts.Writer offsetWriter = PackedInts.getWriter(idxOut, count + 1, PackedInts.bitsRequired(this.maxBytes), 0.2f);
            BytesRef spare = new BytesRef();
            int i = 0;
            while (i < count) {
                int e = sortedEntries[i];
                offsetWriter.add(offset);
                index[e] = i++;
                BytesRef bytes = this.hash.get(e, spare);
                datOut.writeBytes(bytes.bytes, bytes.offset, bytes.length);
                offset += (long)bytes.length;
            }
            offsetWriter.add(offset);
            offsetWriter.finish();
            this.writeIndex(idxOut, docCount, (long)count, index, this.docToEntry);
        }
    }
}

