/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.intblock;

import java.io.IOException;
import org.apache.lucene.codecs.sep.IntIndexInput;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.IntsRef;

public abstract class FixedIntBlockIndexInput
extends IntIndexInput {
    private final IndexInput in;
    protected final int blockSize;

    public FixedIntBlockIndexInput(IndexInput in) throws IOException {
        this.in = in;
        this.blockSize = in.readVInt();
    }

    @Override
    public Reader reader() throws IOException {
        int[] buffer = new int[this.blockSize];
        IndexInput clone = (IndexInput)this.in.clone();
        return new Reader(clone, buffer, this.getBlockReader(clone, buffer));
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }

    @Override
    public Index index() {
        return new Index();
    }

    protected abstract BlockReader getBlockReader(IndexInput var1, int[] var2) throws IOException;

    private class Index
    extends IntIndexInput.Index {
        private long fp;
        private int upto;

        private Index() {
        }

        @Override
        public void read(DataInput indexIn, boolean absolute) throws IOException {
            if (absolute) {
                this.upto = indexIn.readVInt();
                this.fp = indexIn.readVLong();
            } else {
                int uptoDelta = indexIn.readVInt();
                if ((uptoDelta & 1) == 1) {
                    this.upto += uptoDelta >>> 1;
                } else {
                    this.upto = uptoDelta >>> 1;
                    this.fp += indexIn.readVLong();
                }
            }
            assert (this.upto < FixedIntBlockIndexInput.this.blockSize);
        }

        @Override
        public void seek(IntIndexInput.Reader other) throws IOException {
            ((Reader)other).seek(this.fp, this.upto);
        }

        @Override
        public void set(IntIndexInput.Index other) {
            Index idx = (Index)other;
            this.fp = idx.fp;
            this.upto = idx.upto;
        }

        @Override
        public Index clone() {
            Index other = new Index();
            other.fp = this.fp;
            other.upto = this.upto;
            return other;
        }

        public String toString() {
            return "fp=" + this.fp + " upto=" + this.upto;
        }
    }

    private static class Reader
    extends IntIndexInput.Reader {
        private final IndexInput in;
        protected final int[] pending;
        int upto;
        private boolean seekPending;
        private long pendingFP;
        private int pendingUpto;
        private long lastBlockFP;
        private final BlockReader blockReader;
        private final int blockSize;
        private final IntsRef bulkResult = new IntsRef();

        public Reader(IndexInput in, int[] pending, BlockReader blockReader) throws IOException {
            this.in = in;
            this.pending = pending;
            this.blockSize = pending.length;
            this.bulkResult.ints = pending;
            this.blockReader = blockReader;
            this.upto = this.blockSize;
        }

        void seek(long fp, int upto) {
            this.pendingFP = fp;
            this.pendingUpto = upto;
            this.seekPending = true;
        }

        private void maybeSeek() throws IOException {
            if (this.seekPending) {
                if (this.pendingFP != this.lastBlockFP) {
                    this.in.seek(this.pendingFP);
                    this.lastBlockFP = this.pendingFP;
                    this.blockReader.readBlock();
                }
                this.upto = this.pendingUpto;
                this.seekPending = false;
            }
        }

        @Override
        public int next() throws IOException {
            this.maybeSeek();
            if (this.upto == this.blockSize) {
                this.lastBlockFP = this.in.getFilePointer();
                this.blockReader.readBlock();
                this.upto = 0;
            }
            return this.pending[this.upto++];
        }

        @Override
        public IntsRef read(int count) throws IOException {
            this.maybeSeek();
            if (this.upto == this.blockSize) {
                this.blockReader.readBlock();
                this.upto = 0;
            }
            this.bulkResult.offset = this.upto;
            if (this.upto + count < this.blockSize) {
                this.bulkResult.length = count;
                this.upto += count;
            } else {
                this.bulkResult.length = this.blockSize - this.upto;
                this.upto = this.blockSize;
            }
            return this.bulkResult;
        }
    }

    public static interface BlockReader {
        public void readBlock() throws IOException;
    }
}

