/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.appending;

import java.io.IOException;
import org.apache.lucene.codecs.BlockTreeTermsWriter;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.PostingsWriterBase;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.store.IndexOutput;

public class AppendingTermsWriter
extends BlockTreeTermsWriter {
    static final String TERMS_CODEC_NAME = "APPENDING_TERMS_DICT";
    static final int TERMS_VERSION_START = 0;
    static final int TERMS_VERSION_CURRENT = 0;
    static final String TERMS_INDEX_CODEC_NAME = "APPENDING_TERMS_INDEX";
    static final int TERMS_INDEX_VERSION_START = 0;
    static final int TERMS_INDEX_VERSION_CURRENT = 0;

    public AppendingTermsWriter(SegmentWriteState state, PostingsWriterBase postingsWriter, int minItemsInBlock, int maxItemsInBlock) throws IOException {
        super(state, postingsWriter, minItemsInBlock, maxItemsInBlock);
    }

    @Override
    protected void writeHeader(IndexOutput out) throws IOException {
        CodecUtil.writeHeader(out, TERMS_CODEC_NAME, 0);
    }

    @Override
    protected void writeIndexHeader(IndexOutput out) throws IOException {
        CodecUtil.writeHeader(out, TERMS_INDEX_CODEC_NAME, 0);
    }

    @Override
    protected void writeTrailer(IndexOutput out, long dirStart) throws IOException {
        out.writeLong(dirStart);
    }

    @Override
    protected void writeIndexTrailer(IndexOutput indexOut, long dirStart) throws IOException {
        indexOut.writeLong(dirStart);
    }
}

