/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.appending;

import java.io.IOException;
import org.apache.lucene.codecs.BlockTreeTermsReader;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.PostingsReaderBase;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;

public class AppendingTermsReader
extends BlockTreeTermsReader {
    public AppendingTermsReader(Directory dir, FieldInfos fieldInfos, String segment, PostingsReaderBase postingsReader, IOContext ioContext, String segmentSuffix, int indexDivisor) throws IOException {
        super(dir, fieldInfos, segment, postingsReader, ioContext, segmentSuffix, indexDivisor);
    }

    @Override
    protected void readHeader(IndexInput input) throws IOException {
        CodecUtil.checkHeader(input, "APPENDING_TERMS_DICT", 0, 0);
    }

    @Override
    protected void readIndexHeader(IndexInput input) throws IOException {
        CodecUtil.checkHeader(input, "APPENDING_TERMS_INDEX", 0, 0);
    }

    @Override
    protected void seekDir(IndexInput input, long dirOffset) throws IOException {
        input.seek(input.length() - 8L);
        long offset = input.readLong();
        input.seek(offset);
    }
}

