/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs;

import java.io.Closeable;
import java.io.IOException;
import java.util.Iterator;
import org.apache.lucene.codecs.DocValuesConsumer;
import org.apache.lucene.index.AtomicReader;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.MergeState;

public abstract class PerDocConsumer
implements Closeable {
    public abstract DocValuesConsumer addValuesField(DocValues.Type var1, FieldInfo var2) throws IOException;

    public void merge(MergeState mergeState) throws IOException {
        DocValues[] docValues = new DocValues[mergeState.readers.size()];
        Iterator<FieldInfo> i$ = mergeState.fieldInfos.iterator();
        while (i$.hasNext()) {
            FieldInfo fieldInfo;
            mergeState.fieldInfo = fieldInfo = i$.next();
            if (!this.canMerge(fieldInfo)) continue;
            for (int i = 0; i < docValues.length; ++i) {
                docValues[i] = this.getDocValuesForMerge(mergeState.readers.get((int)i).reader, fieldInfo);
            }
            DocValues.Type docValuesType = this.getDocValuesType(fieldInfo);
            assert (docValuesType != null);
            DocValuesConsumer docValuesConsumer = this.addValuesField(docValuesType, fieldInfo);
            assert (docValuesConsumer != null);
            docValuesConsumer.merge(mergeState, docValues);
        }
    }

    protected DocValues getDocValuesForMerge(AtomicReader reader, FieldInfo info) throws IOException {
        return reader.docValues(info.name);
    }

    protected boolean canMerge(FieldInfo info) {
        return info.hasDocValues();
    }

    protected DocValues.Type getDocValuesType(FieldInfo info) {
        return info.getDocValuesType();
    }

    public abstract void abort();
}

